/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.cache.AccountDeletionRecord;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import java.util.List;
import java.util.Set;

public abstract class OAuth2TokenCache<T extends OAuth2Strategy, U extends AuthorizationRequest, V extends TokenResponse> {
    private final Context mContext;

    public OAuth2TokenCache(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public abstract ICacheRecord save(T var1, U var2, V var3) throws ClientException;

    public abstract List<ICacheRecord> saveAndLoadAggregatedAccountData(T var1, U var2, V var3) throws ClientException;

    public abstract ICacheRecord save(AccountRecord var1, IdTokenRecord var2);

    public abstract ICacheRecord load(String var1, String var2, AccountRecord var3, AbstractAuthenticationScheme var4);

    public abstract List<ICacheRecord> loadWithAggregatedAccountData(String var1, String var2, AccountRecord var3, AbstractAuthenticationScheme var4);

    public abstract boolean removeCredential(Credential var1);

    public abstract AccountRecord getAccount(String var1, String var2, String var3, String var4);

    public abstract List<ICacheRecord> getAccountsWithAggregatedAccountData(String var1, String var2, String var3);

    public abstract AccountRecord getAccountByLocalAccountId(String var1, String var2, String var3);

    public abstract ICacheRecord getAccountWithAggregatedAccountDataByLocalAccountId(String var1, String var2, String var3);

    public abstract List<AccountRecord> getAccounts(String var1, String var2);

    public abstract List<AccountRecord> getAllTenantAccountsForAccountByClientId(String var1, AccountRecord var2);

    public abstract List<ICacheRecord> getAccountsWithAggregatedAccountData(String var1, String var2);

    public abstract List<IdTokenRecord> getIdTokensForAccountRecord(String var1, AccountRecord var2);

    public abstract AccountDeletionRecord removeAccount(String var1, String var2, String var3, String var4);

    public abstract void clearAll();

    protected abstract Set<String> getAllClientIds();

    protected final Context getContext() {
        return this.mContext;
    }

    public abstract AccountRecord getAccountByHomeAccountId(@Nullable String var1, @NonNull String var2, @NonNull String var3);
}

