/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import java.util.Map;

public class AzureActiveDirectoryAccount
extends MicrosoftAccount {
    private static final String TAG = AzureActiveDirectoryAccount.class.getSimpleName();
    private String mIdentityProvider;

    public AzureActiveDirectoryAccount() {
    }

    public AzureActiveDirectoryAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        super(idToken, clientInfo);
        Map<String, ?> claims = idToken.getTokenClaims();
        this.mIdentityProvider = (String)claims.get("idp");
        Logger.verbose(TAG, "Init: " + TAG);
    }

    public void setIdentityProvider(String idp) {
        this.mIdentityProvider = idp;
    }

    public String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    @Override
    public String getAuthorityType() {
        return "MSSTS";
    }

    @Override
    protected String getDisplayableId(Map<String, ?> claims) {
        String methodName = "getDisplayableId";
        String displayableId = null;
        if (!StringExtensions.isNullOrBlank((String)claims.get("upn"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning upn as displayableId");
            displayableId = (String)claims.get("upn");
        } else if (!StringExtensions.isNullOrBlank((String)claims.get("email"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning email as displayableId");
            displayableId = (String)claims.get("email");
        }
        return displayableId;
    }

    @Override
    public String toString() {
        return "AzureActiveDirectoryAccount{} " + super.toString() + ", mIdentityProvider='" + this.mIdentityProvider + '\'';
    }
}

