/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.eststelemetry;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.eststelemetry.Schema;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RequestTelemetry {
    private static final String TAG = RequestTelemetry.class.getSimpleName();
    private boolean mIsCurrentRequest;
    private String mSchemaVersion;
    private ConcurrentMap<String, String> mCommonTelemetry;
    private ConcurrentMap<String, String> mPlatformTelemetry;

    RequestTelemetry(@NonNull boolean isCurrentRequest) {
        this("1", isCurrentRequest);
    }

    RequestTelemetry(@NonNull String schemaVersion, @NonNull boolean isCurrentRequest) {
        this.mIsCurrentRequest = isCurrentRequest;
        this.mSchemaVersion = schemaVersion;
        this.mCommonTelemetry = new ConcurrentHashMap<String, String>();
        this.mPlatformTelemetry = new ConcurrentHashMap<String, String>();
    }

    private void putInCommonTelemetry(String key, String value) {
        this.mCommonTelemetry.putIfAbsent(key, value);
    }

    private void putInPlatformTelemetry(String key, String value) {
        this.mPlatformTelemetry.putIfAbsent(key, value);
    }

    void clearTelemetry() {
        this.mCommonTelemetry.clear();
        this.mPlatformTelemetry.clear();
    }

    void putTelemetry(@Nullable String key, @Nullable String value) {
        if (key == null) {
            return;
        }
        String methodName = ":putTelemetry";
        String schemaCompliantValueString = Schema.getSchemaCompliantString(value);
        if (Schema.isCommonField(key, this.mIsCurrentRequest)) {
            this.putInCommonTelemetry(key, schemaCompliantValueString);
        } else if (Schema.isPlatformField(key, this.mIsCurrentRequest)) {
            this.putInPlatformTelemetry(key, schemaCompliantValueString);
        } else {
            Logger.verbose(TAG + ":putTelemetry", "Supplied key not added to Server telemetry map as it is not part of either common or platform schema.");
        }
    }

    String getSchemaVersion() {
        return this.mSchemaVersion;
    }

    Map<String, String> getCommonTelemetry() {
        return this.mCommonTelemetry;
    }

    Map<String, String> getPlatformTelemetry() {
        return this.mPlatformTelemetry;
    }

    @Nullable
    String getCompleteTelemetryHeaderString() {
        String methodName = ":getCompleteTelemetryHeaderString";
        if (StringUtil.isEmpty(this.mSchemaVersion)) {
            Logger.verbose(TAG + ":getCompleteTelemetryHeaderString", "SCHEMA_VERSION is null or empty. Telemetry Header String cannot be formed.");
            return null;
        }
        String schemaVersionString = Schema.getSchemaCompliantString(this.mSchemaVersion);
        String commonSchemaString = this.getCommonTelemetryHeaderString();
        String platformSchemaString = this.getPlatformTelemetryHeaderString();
        return schemaVersionString + "|" + commonSchemaString + "|" + platformSchemaString;
    }

    private String getCommonTelemetryHeaderString() {
        String[] commonFields = Schema.getCommonFields(this.mIsCurrentRequest);
        return this.getTelemetryHeaderStringFromFields(commonFields, this.mCommonTelemetry);
    }

    private String getPlatformTelemetryHeaderString() {
        String[] platformFields = Schema.getPlatformFields(this.mIsCurrentRequest);
        return this.getTelemetryHeaderStringFromFields(platformFields, this.mPlatformTelemetry);
    }

    @NonNull
    private String getTelemetryHeaderStringFromFields(@Nullable String[] fields, @Nullable Map<String, String> telemetry) {
        if (fields == null || telemetry == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            String key = fields[i];
            String value = telemetry.get(key);
            String compliantValueString = Schema.getSchemaCompliantString(value);
            sb.append(compliantValueString);
            if (i == fields.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }
}

