/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.Intent;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.internal.controllers.BaseCommand;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.CommandCallback;
import com.microsoft.identity.common.internal.controllers.TokenOperation;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import java.util.List;

public class TokenCommand
extends BaseCommand<AcquireTokenResult>
implements TokenOperation {
    private static final String TAG = TokenCommand.class.getSimpleName();

    public TokenCommand(@NonNull OperationParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback) {
        super(parameters, controller, callback);
    }

    public TokenCommand(@NonNull OperationParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback) {
        super(parameters, controllers, callback);
    }

    @Override
    public AcquireTokenResult execute() throws Exception {
        AcquireTokenResult result = null;
        String methodName = ":execute";
        for (int ii = 0; ii < this.getControllers().size(); ++ii) {
            BaseController controller = this.getControllers().get(ii);
            try {
                Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
                result = controller.acquireTokenSilent((AcquireTokenSilentOperationParameters)this.getParameters());
                if (!result.getSucceeded().booleanValue()) continue;
                Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName() + ": Succeeded");
                return result;
            }
            catch (ClientException | UiRequiredException e) {
                if (e.getErrorCode().equals("invalid_grant") && this.getControllers().size() > ii + 1 || (e.getErrorCode().equals("no_tokens_found") || e.getErrorCode().equals("no_account_found")) && this.getControllers().size() > ii + 1) continue;
                throw e;
            }
        }
        return result;
    }

    @Override
    public boolean isEligibleForCaching() {
        return false;
    }

    @Override
    public int getCommandNameHashCode() {
        return TAG.hashCode();
    }

    @Override
    public void notify(int requestCode, int resultCode, Intent data) {
        throw new UnsupportedOperationException();
    }
}

