/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.Command;
import com.microsoft.identity.common.internal.controllers.CommandCallback;
import com.microsoft.identity.common.internal.request.OperationParameters;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseCommand<T>
implements Command<T> {
    private OperationParameters mParameters;
    private List<BaseController> mControllers;
    private CommandCallback mCallback;
    private String mPublicApiId;

    public BaseCommand(@NonNull OperationParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback) {
        this.mParameters = parameters;
        this.mControllers = new ArrayList<BaseController>();
        this.mCallback = callback;
        this.mControllers.add(controller);
    }

    public BaseCommand(@NonNull OperationParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback) {
        this.mParameters = parameters;
        this.mControllers = controllers;
        this.mCallback = callback;
    }

    public OperationParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(OperationParameters parameters) {
        this.mParameters = parameters;
    }

    public List<BaseController> getControllers() {
        return this.mControllers;
    }

    public void setControllers(List<BaseController> controllers) {
        this.mControllers = controllers;
    }

    public CommandCallback getCallback() {
        return this.mCallback;
    }

    public void setCallback(CommandCallback callback) {
        this.mCallback = callback;
    }

    public void setPublicApiId(String publicApiId) {
        this.mPublicApiId = publicApiId;
    }

    public String getPublicApiId() {
        return this.mPublicApiId;
    }

    @Override
    public abstract T execute() throws Exception;

    public BaseController getDefaultController() {
        return this.mControllers.get(0);
    }

    public abstract int getCommandNameHashCode();

    public boolean isEligibleForCaching() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseCommand)) {
            return false;
        }
        BaseCommand that = (BaseCommand)o;
        return this.mParameters.equals(that.mParameters);
    }

    public int hashCode() {
        return 31 * this.getCommandNameHashCode() + this.mParameters.hashCode();
    }
}

