/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authscheme;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.internal.authscheme.TokenAuthenticationScheme;
import com.microsoft.identity.common.internal.platform.Device;
import java.net.URL;

public class PopAuthenticationSchemeInternal
extends TokenAuthenticationScheme
implements IPoPAuthenticationSchemeParams {
    public static final String SCHEME_POP = "PoP";
    @SerializedName(value="http_method")
    private String mHttpMethod;
    @SerializedName(value="url")
    private URL mUrl;
    @SerializedName(value="nonce")
    private String mNonce;

    PopAuthenticationSchemeInternal() {
        super(SCHEME_POP);
    }

    PopAuthenticationSchemeInternal(@NonNull String httpMethod, @NonNull URL url, @Nullable String nonce) {
        super(SCHEME_POP);
        this.mHttpMethod = httpMethod;
        this.mUrl = url;
        this.mNonce = nonce;
    }

    @Override
    public String getAccessTokenForScheme(@NonNull String accessToken) throws ClientException {
        return Device.getDevicePoPManagerInstance().mintSignedAccessToken(this.getHttpMethod(), this.getUrl(), accessToken, this.getNonce());
    }

    @Override
    public String getHttpMethod() {
        return this.mHttpMethod;
    }

    @Override
    public URL getUrl() {
        return this.mUrl;
    }

    @Override
    @Nullable
    public String getNonce() {
        return this.mNonce;
    }

    public static final class SerializedNames {
        public static final String HTTP_METHOD = "http_method";
        public static final String URL = "url";
        public static final String NONCE = "nonce";
    }
}

