/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authscheme;

import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.authscheme.INameable;
import com.microsoft.identity.common.internal.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.internal.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.internal.logging.Logger;

public class AuthenticationSchemeFactory {
    private static final String TAG = AuthenticationSchemeFactory.class.getSimpleName();

    public static AbstractAuthenticationScheme createScheme(@Nullable INameable nameable) {
        if (null == nameable) {
            return new BearerAuthenticationSchemeInternal();
        }
        switch (nameable.getName()) {
            case "Bearer": {
                Logger.verbose(TAG, "Constructing Bearer Authentication Scheme.");
                return new BearerAuthenticationSchemeInternal();
            }
            case "PoP": {
                if (nameable instanceof IPoPAuthenticationSchemeParams) {
                    Logger.verbose(TAG, "Constructing PoP Authentication Scheme.");
                    IPoPAuthenticationSchemeParams params = (IPoPAuthenticationSchemeParams)((Object)nameable);
                    return new PopAuthenticationSchemeInternal(params.getHttpMethod(), params.getUrl(), params.getNonce());
                }
                throw new IllegalStateException("Unrecognized parameter type.");
            }
        }
        throw new UnsupportedOperationException("Unknown or unsupported scheme: " + nameable.getName());
    }
}

