/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authorities;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authorities.ActiveDirectoryFederationServicesAuthority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.internal.authorities.UnknownAuthority;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2StrategyParameters;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public abstract class Authority {
    private static final String TAG = Authority.class.getSimpleName();
    private static final String ADFS_PATH_SEGMENT = "adfs";
    private static final String B2C_PATH_SEGMENT = "tfp";
    public static final String B2C = "B2C";
    protected boolean mKnownToMicrosoft = false;
    protected boolean mKnownToDeveloper = false;
    @SerializedName(value="default")
    protected boolean mIsDefault = false;
    @SerializedName(value="type")
    protected String mAuthorityTypeString;
    @SerializedName(value="authority_url")
    protected String mAuthorityUrl;
    private static List<Authority> knownAuthorities = new ArrayList<Authority>();
    private static Object sLock = new Object();

    public abstract Uri getAuthorityUri();

    public abstract URL getAuthorityURL();

    public boolean getDefault() {
        return this.mIsDefault;
    }

    public String getAuthorityTypeString() {
        return this.mAuthorityTypeString;
    }

    public void setDefault(Boolean isDefault) {
        this.mIsDefault = isDefault;
    }

    public static Authority getAuthorityFromAuthorityUrl(String authorityUrl) {
        URL authUrl;
        String methodName = ":getAuthorityFromAuthorityUrl";
        try {
            authUrl = new URL(authorityUrl);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid authority URL");
        }
        Uri authorityUri = Uri.parse((String)authUrl.toString());
        List pathSegments = authorityUri.getPathSegments();
        if (pathSegments.size() == 0) {
            return new UnknownAuthority();
        }
        Authority authority = null;
        if (Authority.authorityIsKnownFromConfiguration(authorityUrl)) {
            Authority configuredAuthority = Authority.getEquivalentConfiguredAuthority(authorityUrl);
            String authorityTypeStr = configuredAuthority.mAuthorityTypeString;
            authority = B2C.equalsIgnoreCase(authorityTypeStr) ? new AzureActiveDirectoryB2CAuthority(authorityUrl) : Authority.createAadAuthority(authorityUri, pathSegments);
        } else {
            String authorityType = (String)pathSegments.get(0);
            switch (authorityType.toLowerCase()) {
                case "adfs": {
                    Logger.verbose(TAG + ":getAuthorityFromAuthorityUrl", "Authority type is ADFS");
                    authority = new ActiveDirectoryFederationServicesAuthority(authorityUrl);
                    break;
                }
                case "tfp": {
                    Logger.verbose(TAG + ":getAuthorityFromAuthorityUrl", "Authority type is B2C");
                    authority = new AzureActiveDirectoryB2CAuthority(authorityUrl);
                    break;
                }
                default: {
                    Logger.verbose(TAG + ":getAuthorityFromAuthorityUrl", "Authority type default: AAD");
                    authority = Authority.createAadAuthority(authorityUri, pathSegments);
                }
            }
        }
        return authority;
    }

    @Nullable
    private static Authority getEquivalentConfiguredAuthority(@NonNull String authorityStr) {
        Authority result = null;
        try {
            URL authorityUrl = new URL(authorityStr);
            String httpAuthority = authorityUrl.getAuthority();
            for (Authority currentAuthority : knownAuthorities) {
                URL currentAuthorityUrl;
                String currentHttpAuthority;
                if (TextUtils.isEmpty((CharSequence)currentAuthority.mAuthorityUrl) || !httpAuthority.equalsIgnoreCase(currentHttpAuthority = (currentAuthorityUrl = new URL(currentAuthority.mAuthorityUrl)).getAuthority())) continue;
                result = currentAuthority;
                break;
            }
        }
        catch (MalformedURLException e) {
            Logger.errorPII(TAG, "Error parsing authority", e);
        }
        return result;
    }

    private static boolean authorityIsKnownFromConfiguration(@NonNull String authorityStr) {
        return null != Authority.getEquivalentConfiguredAuthority(authorityStr);
    }

    private static Authority createAadAuthority(@NonNull Uri authorityUri, @NonNull List<String> pathSegments) {
        AzureActiveDirectoryAudience audience = AzureActiveDirectoryAudience.getAzureActiveDirectoryAudience(authorityUri.getScheme() + "://" + authorityUri.getHost(), pathSegments.get(0));
        return new AzureActiveDirectoryAuthority(audience);
    }

    public abstract OAuth2Strategy createOAuth2Strategy(@NonNull OAuth2StrategyParameters var1) throws ClientException;

    protected boolean getKnownToMicrosoft() {
        return this.mKnownToMicrosoft;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Authority)) {
            return false;
        }
        Authority authority = (Authority)o;
        if (!this.mAuthorityTypeString.equals(authority.mAuthorityTypeString)) {
            return false;
        }
        return this.getAuthorityURL().equals(authority.getAuthorityURL());
    }

    public int hashCode() {
        int result = this.mAuthorityTypeString.hashCode();
        result = 31 * result + this.getAuthorityURL().hashCode();
        return result;
    }

    protected boolean getKnownToDeveloper() {
        return this.mKnownToDeveloper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCloudDiscovery() throws IOException {
        String methodName = ":performCloudDiscovery";
        Logger.verbose(TAG + ":performCloudDiscovery", "Performing cloud discovery...");
        Object object = sLock;
        synchronized (object) {
            if (!AzureActiveDirectory.isInitialized()) {
                AzureActiveDirectory.performCloudDiscovery();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKnownAuthorities(List<Authority> authorities) {
        Object object = sLock;
        synchronized (object) {
            knownAuthorities.addAll(authorities);
        }
    }

    public static boolean isKnownAuthority(Authority authority) {
        String methodName = ":isKnownAuthority";
        boolean knownToDeveloper = false;
        if (authority == null) {
            Logger.warn(TAG + ":isKnownAuthority", "Authority is null");
            return false;
        }
        if (authority.getKnownToDeveloper()) {
            knownToDeveloper = true;
        } else {
            for (Authority currentAuthority : knownAuthorities) {
                if (currentAuthority.mAuthorityUrl == null || authority.getAuthorityURL() == null || authority.getAuthorityURL().getAuthority() == null || !currentAuthority.mAuthorityUrl.toLowerCase().contains(authority.getAuthorityURL().getAuthority().toLowerCase())) continue;
                knownToDeveloper = true;
                break;
            }
        }
        boolean knownToMicrosoft = AzureActiveDirectory.hasCloudHost(authority.getAuthorityURL());
        boolean isKnown = knownToDeveloper || knownToMicrosoft;
        Logger.verbose(TAG + ":isKnownAuthority", "Authority is known to developer? [" + knownToDeveloper + "]");
        Logger.verbose(TAG + ":isKnownAuthority", "Authority is known to Microsoft? [" + knownToMicrosoft + "]");
        return isKnown;
    }

    public static KnownAuthorityResult getKnownAuthorityResult(Authority authority) {
        String methodName = ":getKnownAuthorityResult";
        Logger.verbose(TAG + ":getKnownAuthorityResult", "Getting known authority result...");
        ClientException clientException = null;
        boolean known = false;
        try {
            Logger.verbose(TAG + ":getKnownAuthorityResult", "Performing cloud discovery");
            Authority.performCloudDiscovery();
        }
        catch (IOException ex) {
            clientException = new ClientException("io_error", "Unable to perform cloud discovery", ex);
        }
        if (clientException == null) {
            if (!Authority.isKnownAuthority(authority)) {
                clientException = new ClientException("unknown_authority", "Provided authority is not known.  MSAL will only make requests to known authorities");
            } else {
                known = true;
            }
        }
        return new KnownAuthorityResult(known, clientException);
    }

    public static class KnownAuthorityResult {
        private boolean mKnown;
        private ClientException mClientException;

        KnownAuthorityResult(boolean known, ClientException exception) {
            this.mKnown = known;
            this.mClientException = exception;
        }

        public boolean getKnown() {
            return this.mKnown;
        }

        public ClientException getClientException() {
            return this.mClientException;
        }
    }
}

