/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.List;

public class ProcessUtil {
    private ProcessUtil() {
    }

    public static boolean isBrokerProcess(@NonNull Context context) {
        String processName = ProcessUtil.getProcessName(context);
        String authAppAuthProcess = "com.azure.authenticator:auth";
        String cpAuthProcess = "com.microsoft.windowsintune.companyportal:auth";
        return "com.azure.authenticator:auth".equalsIgnoreCase(processName) || "com.microsoft.windowsintune.companyportal:auth".equalsIgnoreCase(processName);
    }

    @Nullable
    private static String getProcessName(@NonNull Context context) {
        int pid = Process.myPid();
        ActivityManager am = (ActivityManager)context.getApplicationContext().getSystemService("activity");
        List runningProcesses = am.getRunningAppProcesses();
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo procInfo : runningProcesses) {
                if (procInfo.pid != pid) continue;
                return procInfo.processName;
            }
        }
        return null;
    }
}

