/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import android.util.Base64;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.JsonExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ServiceException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import org.json.JSONException;

public class ClientInfo
implements Serializable {
    private static final String UNIQUE_IDENTIFIER = "uid";
    private static final String UNIQUE_TENANT_IDENTIFIER = "utid";
    private static final long serialVersionUID = 3326461566190095403L;
    private String mUid;
    private String mUtid;
    private String mRawClientInfo;

    public ClientInfo(@NonNull String rawClientInfo) throws ServiceException {
        Map<String, String> clientInfoItems;
        if (StringExtensions.isNullOrBlank(rawClientInfo)) {
            throw new IllegalArgumentException("ClientInfo cannot be null or blank.");
        }
        String decodedClientInfo = new String(Base64.decode((String)rawClientInfo, (int)8), Charset.forName("UTF-8"));
        try {
            clientInfoItems = JsonExtensions.extractJsonObjectIntoMap(decodedClientInfo);
        }
        catch (JSONException e) {
            throw new ServiceException("", "invalid_jwt", e);
        }
        this.mUid = clientInfoItems.get(UNIQUE_IDENTIFIER);
        this.mUtid = clientInfoItems.get(UNIQUE_TENANT_IDENTIFIER);
        this.mRawClientInfo = rawClientInfo;
    }

    public String getUid() {
        return this.mUid;
    }

    public String getUtid() {
        return this.mUtid;
    }

    public String getRawClientInfo() {
        return this.mRawClientInfo;
    }
}

