/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.commands.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.commands.parameters.BrokerInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.CommandResult;
import com.microsoft.identity.common.internal.controllers.CommandResultCache;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class CommandDispatcher {
    private static final String TAG = CommandDispatcher.class.getSimpleName();
    private static final int SILENT_REQUEST_THREAD_POOL_SIZE = 5;
    private static final ExecutorService sInteractiveExecutor = Executors.newSingleThreadExecutor();
    private static final ExecutorService sSilentExecutor = Executors.newFixedThreadPool(5);
    private static final Object sLock = new Object();
    private static InteractiveTokenCommand sCommand = null;
    private static final CommandResultCache sCommandResultCache = new CommandResultCache();
    private static final Set<BaseCommand> sExecutingCommands = Collections.synchronizedSet(new HashSet());

    public static void submitSilent(final @NonNull BaseCommand command) {
        String methodName = ":submitSilent";
        Logger.verbose(TAG + ":submitSilent", "Beginning execution of silent command.");
        if (sExecutingCommands.contains(command)) {
            new Handler(Looper.getMainLooper()).post(new Runnable(){

                @Override
                public void run() {
                    command.getCallback().onError(new ClientException("duplicate_command", "The same command was already received and is being processed."));
                }
            });
        } else if (command.isEligibleForCaching()) {
            sExecutingCommands.add(command);
        }
        sSilentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String correlationId = CommandDispatcher.initializeDiagnosticContext(command.getParameters().getCorrelationId());
                command.getParameters().setCorrelationId(correlationId);
                EstsTelemetry.getInstance().initTelemetryForCommand(command);
                EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                CommandResult commandResult = null;
                Handler handler = new Handler(Looper.getMainLooper());
                if (command.getParameters() instanceof SilentTokenCommandParameters) {
                    CommandDispatcher.logSilentRequestParams(":submitSilent", (SilentTokenCommandParameters)command.getParameters());
                    EstsTelemetry.getInstance().emitForceRefresh(((SilentTokenCommandParameters)command.getParameters()).isForceRefresh());
                }
                if ((commandResult = sCommandResultCache.get(command)) == null) {
                    commandResult = CommandDispatcher.executeCommand(command);
                    CommandDispatcher.cacheCommandResult(command, commandResult);
                } else {
                    Logger.info(TAG + ":submitSilent", "Silent command result returned from cache.");
                }
                CommandDispatcher.setCorrelationIdOnResult(commandResult, correlationId);
                Telemetry.getInstance().flush(correlationId);
                EstsTelemetry.getInstance().flush(command, commandResult);
                sExecutingCommands.remove(command);
                CommandDispatcher.returnCommandResult(command, commandResult, handler);
            }
        });
    }

    static void clearCommandCache() {
        sCommandResultCache.clear();
    }

    private static CommandResult executeCommand(BaseCommand command) {
        Object result = null;
        BaseException baseException = null;
        try {
            result = command.execute();
        }
        catch (Exception e) {
            baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
        }
        CommandResult commandResult = baseException != null ? (baseException instanceof UserCancelException ? new CommandResult(CommandResult.ResultStatus.CANCEL, null) : new CommandResult(CommandResult.ResultStatus.ERROR, baseException)) : (result != null && result instanceof AcquireTokenResult ? CommandDispatcher.getCommandResultFromTokenResult(baseException, result) : new CommandResult(CommandResult.ResultStatus.COMPLETED, result));
        return commandResult;
    }

    private static void returnCommandResult(final BaseCommand command, final CommandResult result, Handler handler) {
        handler.post(new Runnable(){

            @Override
            public void run() {
                switch (result.getStatus()) {
                    case ERROR: {
                        command.getCallback().onError(result.getResult());
                        break;
                    }
                    case COMPLETED: {
                        command.getCallback().onTaskCompleted(result.getResult());
                        break;
                    }
                    case CANCEL: {
                        command.getCallback().onCancel();
                    }
                }
            }
        });
    }

    private static void cacheCommandResult(BaseCommand command, CommandResult commandResult) {
        if (command.isEligibleForCaching() && CommandDispatcher.eligibleToCache(commandResult)) {
            sCommandResultCache.put(command, commandResult);
        }
    }

    private static boolean eligibleToCache(CommandResult commandResult) {
        switch (commandResult.getStatus()) {
            case ERROR: {
                return CommandDispatcher.eligibleToCacheException((BaseException)commandResult.getResult());
            }
            case COMPLETED: {
                return true;
            }
        }
        return false;
    }

    private static boolean eligibleToCacheException(BaseException exception) {
        return !(exception instanceof IntuneAppProtectionPolicyRequiredException);
    }

    private static CommandResult getCommandResultFromTokenResult(BaseException baseException, AcquireTokenResult result) {
        if (result.getSucceeded().booleanValue()) {
            return new CommandResult(CommandResult.ResultStatus.COMPLETED, result.getLocalAuthenticationResult());
        }
        baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
        if (baseException instanceof UserCancelException) {
            return new CommandResult(CommandResult.ResultStatus.CANCEL, null);
        }
        return new CommandResult(CommandResult.ResultStatus.ERROR, baseException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final InteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Logger.info(TAG + ":beginInteractive", "Beginning interactive request");
        Object object = sLock;
        synchronized (object) {
            final LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)command.getParameters().getAndroidApplicationContext());
            if (command.getParameters() instanceof BrokerInteractiveTokenCommandParameters) {
                localBroadcastManager.sendBroadcast(new Intent("cancel_interactive_request"));
            }
            sInteractiveExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    String correlationId = CommandDispatcher.initializeDiagnosticContext(command.getParameters().getCorrelationId());
                    command.getParameters().setCorrelationId(correlationId);
                    EstsTelemetry.getInstance().initTelemetryForCommand(command);
                    EstsTelemetry.getInstance().emitApiId(command.getPublicApiId());
                    if (command.getParameters() instanceof InteractiveTokenCommandParameters) {
                        CommandDispatcher.logInteractiveRequestParameters(":beginInteractive", (InteractiveTokenCommandParameters)command.getParameters());
                    }
                    BroadcastReceiver resultReceiver = new BroadcastReceiver(){

                        public void onReceive(Context context, Intent intent) {
                            CommandDispatcher.completeInteractive(intent);
                        }
                    };
                    Handler handler = new Handler(Looper.getMainLooper());
                    localBroadcastManager.registerReceiver(resultReceiver, new IntentFilter("return_interactive_request_result"));
                    sCommand = command;
                    CommandResult commandResult = CommandDispatcher.executeCommand(command);
                    sCommand = null;
                    localBroadcastManager.unregisterReceiver(resultReceiver);
                    CommandDispatcher.setCorrelationIdOnResult(commandResult, correlationId);
                    EstsTelemetry.getInstance().flush(command, commandResult);
                    Telemetry.getInstance().flush(correlationId);
                    CommandDispatcher.returnCommandResult(command, commandResult, handler);
                }
            });
        }
    }

    private static void logInteractiveRequestParameters(String methodName, InteractiveTokenCommandParameters params) {
        Logger.info(TAG + methodName, "Requested " + params.getScopes().size() + " scopes");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String string : params.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + string);
        }
        Logger.infoPII(TAG + methodName, "----");
        Logger.infoPII(TAG + methodName, "ClientId: [" + params.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "RedirectUri: [" + params.getRedirectUri() + "]");
        Logger.infoPII(TAG + methodName, "Login hint: [" + params.getLoginHint() + "]");
        if (null != params.getExtraQueryStringParameters()) {
            Logger.infoPII(TAG + methodName, "Extra query params:");
            for (Pair pair : params.getExtraQueryStringParameters()) {
                Logger.infoPII(TAG + methodName, "\t\"" + (String)pair.first + "\":\"" + (String)pair.second + "\"");
            }
        }
        if (null != params.getExtraScopesToConsent()) {
            Logger.infoPII(TAG + methodName, "Extra scopes to consent:");
            for (String string : params.getExtraScopesToConsent()) {
                Logger.infoPII(TAG + methodName, "\t" + string);
            }
        }
        Logger.info(TAG + methodName, "Using authorization agent: " + params.getAuthorizationAgent().toString());
        if (null != params.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + params.getAccount().getHomeAccountId());
        }
    }

    private static void logSilentRequestParams(String methodName, SilentTokenCommandParameters parameters) {
        Logger.infoPII(TAG + methodName, "ClientId: [" + parameters.getClientId() + "]");
        Logger.infoPII(TAG + methodName, "----\nRequested scopes:");
        for (String scope : parameters.getScopes()) {
            Logger.infoPII(TAG + methodName, "\t" + scope);
        }
        Logger.infoPII(TAG + methodName, "----");
        if (null != parameters.getAccount()) {
            Logger.infoPII(TAG + methodName, "Using account: " + parameters.getAccount().getHomeAccountId());
        }
        Logger.info(TAG + methodName, "Force refresh? [" + parameters.isForceRefresh() + "]");
    }

    private static void completeInteractive(Intent resultIntent) {
        String methodName = ":completeInteractive";
        int requestCode = resultIntent.getIntExtra("com.microsoft.identity.client.request.code", 0);
        int resultCode = resultIntent.getIntExtra("com.microsoft.identity.client.result.code", 0);
        if (sCommand != null) {
            sCommand.notify(requestCode, resultCode, resultIntent);
        } else {
            Logger.warn(TAG + ":completeInteractive", "sCommand is null, No interactive call in progress to complete.");
        }
    }

    public static String initializeDiagnosticContext(@Nullable String requestCorrelationId) {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = TextUtils.isEmpty((CharSequence)requestCorrelationId) ? UUID.randomUUID().toString() : requestCorrelationId;
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":initializeDiagnosticContext", "Initialized new DiagnosticContext");
        return correlationId;
    }

    public static int getCachedResultCount() {
        return sCommandResultCache.getSize();
    }

    private static void setCorrelationIdOnResult(@NonNull CommandResult commandResult, @NonNull String correlationId) {
        if (commandResult.getResult() != null && commandResult.getResult() instanceof LocalAuthenticationResult) {
            LocalAuthenticationResult localAuthenticationResult = (LocalAuthenticationResult)commandResult.getResult();
            localAuthenticationResult.setCorrelationId(correlationId);
        }
    }
}

