/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.BrokerAccountServiceConnection;
import com.microsoft.identity.common.internal.broker.BrokerAccountServiceFuture;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.logging.Logger;

public class InactiveBrokerClient {
    private static final String TAG = InactiveBrokerClient.class.getSimpleName();
    private static final String BROKER_ACCOUNT_SERVICE_INTENT_FILTER = "com.microsoft.workaccount.BrokerAccount";
    private static final String BROKER_ACCOUNT_SERVICE_CLASS_NAME = "com.microsoft.aad.adal.BrokerAccountService";
    private Context mContext;
    private String mInactiveBrokerPackageName;
    private BrokerAccountServiceConnection mBrokerAccountServiceConnection;
    private Boolean mBound = false;

    public InactiveBrokerClient(@NonNull Context context, @NonNull BrokerData inactiveBrokerData) {
        this.mContext = context;
        this.mInactiveBrokerPackageName = inactiveBrokerData.packageName;
    }

    @NonNull
    public BrokerAccountServiceFuture connect() throws ClientException {
        BrokerAccountServiceFuture future = new BrokerAccountServiceFuture();
        this.mBrokerAccountServiceConnection = new BrokerAccountServiceConnection(future);
        this.mBound = this.mContext.bindService(this.getIntentForBrokerAccountService(), (ServiceConnection)this.mBrokerAccountServiceConnection, 1);
        Logger.verbose(TAG + "connect", "The status for BrokerAccountService bindService call is: " + Boolean.valueOf(this.mBound));
        if (!this.mBound.booleanValue()) {
            throw new ClientException("Service is unavailable or does not support binding. BrokerAccountService.");
        }
        return future;
    }

    public void disconnect() {
        if (this.mBound.booleanValue()) {
            this.mContext.unbindService((ServiceConnection)this.mBrokerAccountServiceConnection);
            this.mBound = false;
        }
    }

    @Nullable
    private Intent getIntentForBrokerAccountService() {
        Intent authServiceToBind = new Intent(BROKER_ACCOUNT_SERVICE_INTENT_FILTER);
        authServiceToBind.setPackage(this.mInactiveBrokerPackageName);
        authServiceToBind.setClassName(this.mInactiveBrokerPackageName, BROKER_ACCOUNT_SERVICE_CLASS_NAME);
        return authServiceToBind;
    }
}

