/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.platform.Device;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.oauth2.AccessToken;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Configuration;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.util.ClockSkewManager;
import com.microsoft.identity.common.internal.util.IClockSkewManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.TreeMap;
import java.util.concurrent.Future;

public abstract class OAuth2Strategy<GenericAccessToken extends AccessToken, GenericAccount extends BaseAccount, GenericAuthorizationRequest extends AuthorizationRequest, GenericAuthorizationRequestBuilder extends AuthorizationRequest.Builder, GenericAuthorizationStrategy extends AuthorizationStrategy, GenericOAuth2Configuration extends OAuth2Configuration, GenericOAuth2StrategyParameters extends OAuth2StrategyParameters, GenericAuthorizationResponse extends AuthorizationResponse, GenericRefreshToken extends RefreshToken, GenericTokenRequest extends TokenRequest, GenericTokenResponse extends TokenResponse, GenericTokenResult extends TokenResult, GenericAuthorizationResult extends AuthorizationResult> {
    private static final String TAG = OAuth2Strategy.class.getSimpleName();
    protected static final String TOKEN_REQUEST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected final GenericOAuth2Configuration mConfig;
    protected final GenericOAuth2StrategyParameters mStrategyParameters;
    protected final IClockSkewManager mClockSkewManager;
    protected String mTokenEndpoint;
    protected String mAuthorizationEndpoint;
    private Uri mIssuer;

    public OAuth2Strategy(GenericOAuth2Configuration config, GenericOAuth2StrategyParameters strategyParameters) {
        this.mConfig = config;
        this.mStrategyParameters = strategyParameters;
        if (null != ((OAuth2StrategyParameters)this.mStrategyParameters).getContext()) {
            this.mClockSkewManager = new ClockSkewManager(((OAuth2StrategyParameters)this.mStrategyParameters).getContext());
        } else {
            Logger.info(TAG, "No valid context to persist clock skew with!");
            this.mClockSkewManager = null;
        }
    }

    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest request, GenericAuthorizationStrategy authorizationStrategy) {
        this.validateAuthorizationRequest(request);
        Future<AuthorizationResult> future = null;
        try {
            future = ((AuthorizationStrategy)authorizationStrategy).requestAuthorization(request, (OAuth2Strategy)this);
        }
        catch (ClientException | UnsupportedEncodingException exception) {
            // empty catch block
        }
        return future;
    }

    public abstract AuthorizationResultFactory getAuthorizationResultFactory();

    public GenericTokenResult requestToken(GenericTokenRequest request) throws IOException, ClientException {
        String methodName = ":requestToken";
        Logger.verbose(TAG + ":requestToken", "Requesting token...");
        this.validateTokenRequest(request);
        HttpResponse response = this.performTokenRequest(request);
        GenericTokenResult result = this.getTokenResultFromHttpResponse(response);
        if (((TokenResult)result).getSuccess()) {
            this.validateTokenResponse(request, ((TokenResult)result).getSuccessResponse());
        }
        return result;
    }

    protected HttpResponse performTokenRequest(GenericTokenRequest request) throws IOException, ClientException {
        String methodName = ":performTokenRequest";
        Logger.verbose(TAG + ":performTokenRequest", "Performing token request...");
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(request);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        headers.put("client-request-id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        if (request instanceof MicrosoftTokenRequest && !TextUtils.isEmpty((CharSequence)((MicrosoftTokenRequest)request).getBrokerVersion())) {
            headers.put("x-client-brkrver", ((MicrosoftTokenRequest)request).getBrokerVersion());
        }
        headers.putAll(Device.getPlatformIdParameters());
        headers.putAll(EstsTelemetry.getInstance().getTelemetryHeaders());
        HttpResponse response = HttpRequest.sendPost(new URL(this.mTokenEndpoint), headers, requestBody.getBytes("UTF-8"), TOKEN_REQUEST_CONTENT_TYPE);
        if (null != response.getDate()) {
            this.recordClockSkew(response.getDate().getTime());
        }
        return response;
    }

    private void recordClockSkew(long referenceTimeMillis) {
        if (null != this.mClockSkewManager) {
            this.mClockSkewManager.onTimestampReceived(referenceTimeMillis);
        }
    }

    protected final void setTokenEndpoint(String tokenEndpoint) {
        MicrosoftStsOAuth2Configuration oauth2Config;
        AzureActiveDirectorySlice slice;
        this.mTokenEndpoint = tokenEndpoint;
        if (this.mConfig != null && this.mConfig instanceof MicrosoftStsOAuth2Configuration && (slice = (oauth2Config = (MicrosoftStsOAuth2Configuration)this.mConfig).getSlice()) != null) {
            Uri.Builder uriBuilder = Uri.parse((String)this.mTokenEndpoint).buildUpon();
            if (!TextUtils.isEmpty((CharSequence)slice.getSlice())) {
                uriBuilder.appendQueryParameter("slice", slice.getSlice());
            }
            if (!TextUtils.isEmpty((CharSequence)slice.getDC())) {
                uriBuilder.appendQueryParameter("dc", slice.getDC());
            }
            this.mTokenEndpoint = uriBuilder.build().toString();
        }
    }

    public String getAuthorityFromTokenEndpoint() {
        return this.mTokenEndpoint.toLowerCase().replace("oauth2/v2.0/token", "");
    }

    protected final void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.mAuthorizationEndpoint = authorizationEndpoint;
    }

    protected GenericOAuth2Configuration getOAuth2Configuration() {
        return this.mConfig;
    }

    protected Uri getIssuer() {
        return this.mIssuer;
    }

    protected final void setIssuer(Uri issuer) {
        this.mIssuer = issuer;
    }

    public abstract String getIssuerCacheIdentifier(GenericAuthorizationRequest var1);

    public abstract GenericAccessToken getAccessTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericRefreshToken getRefreshTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericAccount createAccount(GenericTokenResponse var1);

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder();

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder(IAccountRecord var1);

    public abstract GenericTokenRequest createTokenRequest(GenericAuthorizationRequest var1, GenericAuthorizationResponse var2, AbstractAuthenticationScheme var3) throws ClientException;

    public abstract GenericTokenRequest createRefreshTokenRequest(AbstractAuthenticationScheme var1) throws ClientException;

    protected abstract void validateAuthorizationRequest(GenericAuthorizationRequest var1);

    protected abstract void validateTokenRequest(GenericTokenRequest var1);

    protected abstract GenericTokenResult getTokenResultFromHttpResponse(HttpResponse var1) throws ClientException;

    protected abstract void validateTokenResponse(GenericTokenRequest var1, GenericTokenResponse var2) throws ClientException;

    public boolean validateCachedResult(@NonNull AbstractAuthenticationScheme authScheme, @NonNull ICacheRecord cacheRecord) {
        return true;
    }
}

