/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.content.Context;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.util.IClockSkewManager;
import java.util.Calendar;
import java.util.Date;

public class ClockSkewManager
implements IClockSkewManager {
    private SharedPreferencesFileManager mClockSkewPreferences;

    public ClockSkewManager(@NonNull Context context) {
        this.mClockSkewPreferences = new SharedPreferencesFileManager(context, "com.microsoft.identity.client.clock_correction");
    }

    @Override
    public void onTimestampReceived(long referenceTime) {
        long clientTime = this.getCurrentClientTime().getTime();
        long skewMillis = clientTime - referenceTime;
        this.mClockSkewPreferences.putLong("skew", skewMillis);
    }

    @Override
    public long getSkewMillis() {
        return this.mClockSkewPreferences.getLong("skew");
    }

    @Override
    public Date toClientTime(long referenceTime) {
        return new Date(referenceTime + this.getSkewMillis());
    }

    @Override
    public Date toReferenceTime(long clientTime) {
        return new Date(clientTime - this.getSkewMillis());
    }

    @Override
    public Date getCurrentClientTime() {
        return Calendar.getInstance().getTime();
    }

    @Override
    public Date getAdjustedReferenceTime() {
        return this.toReferenceTime(this.getCurrentClientTime().getTime());
    }

    private static final class PreferencesMetadata {
        private static final String SKEW_PREFERENCES_FILENAME = "com.microsoft.identity.client.clock_correction";
        private static final String KEY_SKEW = "skew";

        private PreferencesMetadata() {
        }
    }
}

