/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.result;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class LocalAuthenticationResult
implements ILocalAuthenticationResult {
    private String mRawIdToken;
    private AccessTokenRecord mAccessTokenRecord;
    private IAccountRecord mAccountRecord;
    private String mRefreshToken;
    private String mFamilyId;
    private String mSpeRing;
    private String mRefreshTokenAge;
    private List<ICacheRecord> mCompleteResultFromCache;
    private boolean mServicedFromCache;
    private static final String TAG = LocalAuthenticationResult.class.getName();

    public LocalAuthenticationResult(@NonNull ICacheRecord lastAuthorized, @NonNull List<ICacheRecord> completeResultFromCache, @NonNull SdkType sdkType, boolean isServicedFromCache) {
        this(lastAuthorized, sdkType);
        this.mCompleteResultFromCache = completeResultFromCache;
        this.mServicedFromCache = isServicedFromCache;
    }

    private LocalAuthenticationResult(@NonNull ICacheRecord cacheRecord, @NonNull SdkType sdkType) {
        IdTokenRecord idTokenRecord;
        this.mAccessTokenRecord = cacheRecord.getAccessToken();
        this.mAccountRecord = cacheRecord.getAccount();
        if (cacheRecord.getRefreshToken() != null) {
            this.mRefreshToken = cacheRecord.getRefreshToken().getSecret();
        }
        IdTokenRecord idTokenRecord2 = idTokenRecord = sdkType == SdkType.ADAL ? cacheRecord.getV1IdToken() : cacheRecord.getIdToken();
        if (idTokenRecord != null) {
            this.mRawIdToken = idTokenRecord.getSecret();
            Logger.info(TAG, "Id Token type: " + idTokenRecord.getCredentialType());
        } else if (cacheRecord.getV1IdToken() != null) {
            Logger.info(TAG, "V1 Id Token returned here, ");
            this.mRawIdToken = cacheRecord.getV1IdToken().getSecret();
        }
        Logger.info(TAG, "Constructing LocalAuthentication result, AccessTokenRecord null: " + (this.mAccessTokenRecord == null) + ", AccountRecord null: " + (this.mAccountRecord == null) + ", RefreshTokenRecord null or empty: " + TextUtils.isEmpty((CharSequence)this.mRefreshToken) + ", IdTokenRecord null: " + (idTokenRecord == null));
    }

    @Override
    @NonNull
    public String getAccessToken() {
        return this.mAccessTokenRecord.getSecret();
    }

    @Override
    @NonNull
    public Date getExpiresOn() {
        Date expiresOn = new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(this.mAccessTokenRecord.getExpiresOn())));
        return expiresOn;
    }

    @Override
    @Nullable
    public String getTenantId() {
        return this.mAccessTokenRecord.getRealm();
    }

    @Override
    @NonNull
    public String getUniqueId() {
        return this.mAccessTokenRecord.getHomeAccountId();
    }

    @Override
    @NonNull
    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    @Override
    @Nullable
    public String getIdToken() {
        return this.mRawIdToken;
    }

    @Override
    @NonNull
    public IAccountRecord getAccountRecord() {
        return this.mAccountRecord;
    }

    @Override
    @NonNull
    public String[] getScope() {
        return this.mAccessTokenRecord.getTarget().split("\\s");
    }

    @Override
    @Nullable
    public String getSpeRing() {
        return this.mSpeRing;
    }

    public void setSpeRing(String speRing) {
        this.mSpeRing = speRing;
    }

    @Override
    @Nullable
    public String getRefreshTokenAge() {
        return this.mRefreshTokenAge;
    }

    @Override
    @Nullable
    public String getFamilyId() {
        return this.mFamilyId;
    }

    @Override
    public List<ICacheRecord> getCacheRecordWithTenantProfileData() {
        return this.mCompleteResultFromCache;
    }

    public void setRefreshTokenAge(String refreshTokenAge) {
        this.mRefreshTokenAge = refreshTokenAge;
    }

    @Override
    @NonNull
    public AccessTokenRecord getAccessTokenRecord() {
        return this.mAccessTokenRecord;
    }

    @Override
    public boolean isServicedFromCache() {
        return this.mServicedFromCache;
    }
}

