/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.ArrayList;
import java.util.List;

public class LoadAccountCommand
extends BaseCommand<List<ICacheRecord>> {
    private static final String TAG = LoadAccountCommand.class.getSimpleName();

    public LoadAccountCommand(@NonNull CommandParameters parameters, @NonNull BaseController controller, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controller, callback, publicApiId);
    }

    public LoadAccountCommand(@NonNull CommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controllers, callback, publicApiId);
    }

    @Override
    public List<ICacheRecord> execute() throws Exception {
        String methodName = ":execute";
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        for (int ii = 0; ii < this.getControllers().size(); ++ii) {
            BaseController controller = this.getControllers().get(ii);
            Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
            result.addAll(controller.getAccounts(this.getParameters()));
        }
        return result;
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoadAccountCommand)) {
            return false;
        }
        LoadAccountCommand other = (LoadAccountCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LoadAccountCommand;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

