/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class AbstractAccountCredentialCache
implements IAccountCredentialCache {
    private static final String TAG = AbstractAccountCredentialCache.class.getSimpleName();
    private static final String NEW_LINE = "\n";

    @Nullable
    protected Class<? extends Credential> getTargetClassForCredentialType(@Nullable String cacheKey, @NonNull CredentialType targetType) {
        Class credentialClass = null;
        switch (targetType) {
            case AccessToken: 
            case AccessToken_With_AuthScheme: {
                credentialClass = AccessTokenRecord.class;
                break;
            }
            case RefreshToken: {
                credentialClass = RefreshTokenRecord.class;
                break;
            }
            case IdToken: 
            case V1IdToken: {
                credentialClass = IdTokenRecord.class;
                break;
            }
            default: {
                Logger.warn(TAG, "Could not match CredentialType to class. Did you forget to update this method with a new type?");
                if (null == cacheKey) break;
                Logger.warnPII(TAG, "Sought key was: [" + cacheKey + "]");
            }
        }
        return credentialClass;
    }

    @NonNull
    protected List<AccountRecord> getAccountsFilteredByInternal(@Nullable String homeAccountId, @Nullable String environment, @Nullable String realm, @NonNull List<AccountRecord> allAccounts) {
        boolean mustMatchOnHomeAccountId = !StringExtensions.isNullOrBlank(homeAccountId);
        boolean mustMatchOnEnvironment = !StringExtensions.isNullOrBlank(environment);
        boolean mustMatchOnRealm = !StringExtensions.isNullOrBlank(realm);
        Logger.verbose(TAG, "Account lookup filtered by home_account_id? [" + mustMatchOnHomeAccountId + "]" + NEW_LINE + "Account lookup filtered by realm? [" + mustMatchOnRealm + "]");
        ArrayList<AccountRecord> matchingAccounts = new ArrayList<AccountRecord>();
        for (AccountRecord account : allAccounts) {
            boolean matches = true;
            if (mustMatchOnHomeAccountId) {
                matches = homeAccountId.equalsIgnoreCase(account.getHomeAccountId());
            }
            if (mustMatchOnEnvironment) {
                boolean bl = matches = matches && environment.equalsIgnoreCase(account.getEnvironment());
            }
            if (mustMatchOnRealm) {
                boolean bl = matches = matches && realm.equalsIgnoreCase(account.getRealm());
            }
            if (!matches) continue;
            matchingAccounts.add(account);
        }
        Logger.verbose(TAG, "Found [" + matchingAccounts.size() + "] matching accounts");
        return matchingAccounts;
    }

    protected List<Credential> getCredentialsFilteredByInternal(@Nullable String homeAccountId, @Nullable String environment, @Nullable CredentialType credentialType, @Nullable String clientId, @Nullable String realm, @Nullable String target, @Nullable String authScheme, @NonNull List<Credential> allCredentials) {
        boolean mustMatchOnEnvironment = !StringExtensions.isNullOrBlank(environment);
        boolean mustMatchOnHomeAccountId = !StringExtensions.isNullOrBlank(homeAccountId);
        boolean mustMatchOnRealm = !StringExtensions.isNullOrBlank(realm);
        boolean mustMatchOnTarget = !StringExtensions.isNullOrBlank(target);
        boolean mustMatchOnClientId = !StringExtensions.isNullOrBlank(clientId);
        boolean mustMatchOnCredentialType = null != credentialType;
        boolean mustMatchOnAuthScheme = mustMatchOnCredentialType && !StringExtensions.isNullOrBlank(authScheme) && credentialType == CredentialType.AccessToken_With_AuthScheme;
        Logger.verbose(TAG, "Credential lookup filtered by home_account_id? [" + mustMatchOnHomeAccountId + "]" + NEW_LINE + "Credential lookup filtered by realm? [" + mustMatchOnRealm + "]" + NEW_LINE + "Credential lookup filtered by target? [" + mustMatchOnTarget + "]" + NEW_LINE + "Credential lookup filtered by clientId? [" + mustMatchOnClientId + "]" + NEW_LINE + "Credential lookup filtered by credential type? [" + mustMatchOnCredentialType + "]" + NEW_LINE + "Credential lookup filtered by auth scheme? [" + mustMatchOnAuthScheme + "]");
        ArrayList<Credential> matchingCredentials = new ArrayList<Credential>();
        for (Credential credential : allCredentials) {
            AccessTokenRecord accessToken;
            boolean matches = true;
            if (mustMatchOnHomeAccountId) {
                matches = homeAccountId.equalsIgnoreCase(credential.getHomeAccountId());
            }
            if (mustMatchOnEnvironment) {
                boolean bl = matches = matches && environment.equalsIgnoreCase(credential.getEnvironment());
            }
            if (mustMatchOnCredentialType) {
                boolean bl = matches = matches && credentialType.name().equalsIgnoreCase(credential.getCredentialType());
            }
            if (mustMatchOnClientId) {
                boolean bl = matches = matches && clientId.equalsIgnoreCase(credential.getClientId());
            }
            if (mustMatchOnRealm && credential instanceof AccessTokenRecord) {
                accessToken = (AccessTokenRecord)credential;
                boolean bl = matches = matches && realm.equalsIgnoreCase(accessToken.getRealm());
            }
            if (mustMatchOnRealm && credential instanceof IdTokenRecord) {
                IdTokenRecord idToken = (IdTokenRecord)credential;
                boolean bl = matches = matches && realm.equalsIgnoreCase(idToken.getRealm());
            }
            if (mustMatchOnTarget) {
                if (credential instanceof AccessTokenRecord) {
                    accessToken = (AccessTokenRecord)credential;
                    matches = matches && AbstractAccountCredentialCache.targetsIntersect(target, accessToken.getTarget(), true);
                } else if (credential instanceof RefreshTokenRecord) {
                    RefreshTokenRecord refreshToken = (RefreshTokenRecord)credential;
                    matches = matches && AbstractAccountCredentialCache.targetsIntersect(target, refreshToken.getTarget(), true);
                } else {
                    Logger.verbose(TAG, "Query specified target-match, but no target to match.");
                }
            }
            if (mustMatchOnAuthScheme && credential instanceof AccessTokenRecord) {
                accessToken = (AccessTokenRecord)credential;
                boolean bl = matches = matches && authScheme.equalsIgnoreCase(accessToken.getAccessTokenType());
            }
            if (!matches) continue;
            matchingCredentials.add(credential);
        }
        return matchingCredentials;
    }

    static boolean targetsIntersect(@NonNull String targetToMatch, @NonNull String credentialTarget, boolean omitDefaultScopes) {
        String splitCriteria = "\\s+";
        String[] targetToMatchArray = targetToMatch.split("\\s+");
        String[] credentialTargetArray = credentialTarget.split("\\s+");
        HashSet<String> soughtTargetSet = new HashSet<String>();
        HashSet<String> credentialTargetSet = new HashSet<String>();
        for (String target : targetToMatchArray) {
            soughtTargetSet.add(target.toLowerCase());
        }
        for (String target : credentialTargetArray) {
            credentialTargetSet.add(target.toLowerCase());
        }
        if (omitDefaultScopes) {
            soughtTargetSet.removeAll(BaseController.DEFAULT_SCOPES);
            credentialTargetSet.removeAll(BaseController.DEFAULT_SCOPES);
        }
        return credentialTargetSet.containsAll(soughtTargetSet);
    }
}

