/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.net;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import com.microsoft.identity.common.adal.internal.PowerManagerWrapper;
import com.microsoft.identity.common.adal.internal.net.IConnectionService;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import io.opentelemetry.api.metrics.LongCounter;

public class DefaultConnectionService
implements IConnectionService {
    private final Context mConnectionContext;
    private static final LongCounter sNetworkCheckFailureCount = OTelUtility.createLongCounter((String)"network_check_failure_count", (String)"Number of times network was not available");
    private static final LongCounter sNetworkCheckSuccessCount = OTelUtility.createLongCounter((String)"network_check_success_count", (String)"Number of times network was available");

    public DefaultConnectionService(Context ctx) {
        this.mConnectionContext = ctx;
    }

    @Override
    public boolean isConnectionAvailable() {
        boolean isConnectionAvailable;
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
        boolean useNetworkCapabilityForNetworkCheck = CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.USE_NETWORK_CAPABILITY_FOR_NETWORK_CHECK);
        if (useNetworkCapabilityForNetworkCheck && Build.VERSION.SDK_INT >= 23) {
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            boolean bl = isConnectionAvailable = networkCapabilities != null && networkCapabilities.hasCapability(12) && networkCapabilities.hasCapability(16);
            if (isConnectionAvailable) {
                sNetworkCheckSuccessCount.add(1L);
            } else {
                sNetworkCheckFailureCount.add(1L);
            }
        } else {
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            isConnectionAvailable = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        }
        Telemetry.emit((BaseEvent)((BaseEvent)new BaseEvent().put("Microsoft.MSAL.network_connection", String.valueOf(isConnectionAvailable))));
        return isConnectionAvailable;
    }

    @TargetApi(value=23)
    public boolean isNetworkDisabledFromOptimizations() {
        PowerManagerWrapper powerManagerWrapper;
        if (Build.VERSION.SDK_INT >= 23 && (powerManagerWrapper = PowerManagerWrapper.getInstance()).isDeviceIdleMode(this.mConnectionContext) && !powerManagerWrapper.isIgnoringBatteryOptimizations(this.mConnectionContext)) {
            Telemetry.emit((BaseEvent)((BaseEvent)new BaseEvent().put("Microsoft.MSAL.power_optimization", String.valueOf(true))));
            return true;
        }
        Telemetry.emit((BaseEvent)((BaseEvent)new BaseEvent().put("Microsoft.MSAL.power_optimization", String.valueOf(false))));
        return false;
    }
}

