/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import com.microsoft.identity.common.java.exception.TerminalException;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import lombok.NonNull;

public class CommonMoshiJsonAdapter {
    private final Moshi mMoshi = new Moshi.Builder().build();

    public <T> String toJson(@NonNull T obj) {
        if (obj == null) {
            throw new NullPointerException("obj is marked non-null but is null");
        }
        Class<?> type = obj.getClass();
        JsonAdapter jsonAdapter = this.mMoshi.adapter(type);
        return jsonAdapter.toJson(obj);
    }

    public <T> T fromJson(@NonNull String json, @NonNull Class<T> classOfT) throws TerminalException {
        if (json == null) {
            throw new NullPointerException("json is marked non-null but is null");
        }
        if (classOfT == null) {
            throw new NullPointerException("classOfT is marked non-null but is null");
        }
        JsonAdapter jsonAdapter = this.mMoshi.adapter(classOfT);
        try {
            return (T)jsonAdapter.fromJson(json);
        }
        catch (IOException e) {
            throw new TerminalException(e.getMessage(), (Throwable)e, "json_deserialization_failure");
        }
    }
}

