/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.base64;

import android.util.Base64;
import com.microsoft.identity.common.java.base64.Base64Flags;
import com.microsoft.identity.common.java.base64.IBase64;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\bJ)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007H\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/identity/common/base64/AndroidBase64;", "Lcom/microsoft/identity/common/java/base64/IBase64;", "()V", "combineFlags", "", "flags", "", "Lcom/microsoft/identity/common/java/base64/Base64Flags;", "([Lcom/microsoft/identity/common/java/base64/Base64Flags;)I", "decode", "", "input", "([B[Lcom/microsoft/identity/common/java/base64/Base64Flags;)[B", "encode", "common_distRelease"})
public final class AndroidBase64
implements IBase64 {
    @NotNull
    public byte[] encode(@NotNull byte[] input, Base64Flags ... flags) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        byte[] byArray = Base64.encode((byte[])input, (int)this.combineFlags(Arrays.copyOf(flags, flags.length)));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encode(input, combineFlags(*flags))");
        return byArray;
    }

    @NotNull
    public byte[] decode(@NotNull byte[] input, Base64Flags ... flags) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        byte[] byArray = Base64.decode((byte[])input, (int)this.combineFlags(Arrays.copyOf(flags, flags.length)));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(input, combineFlags(*flags))");
        return byArray;
    }

    private final int combineFlags(Base64Flags ... flags) {
        int combinedFlag = 0;
        if (ArraysKt.contains((Object[])flags, (Object)Base64Flags.URL_SAFE)) {
            combinedFlag |= 8;
        }
        if (ArraysKt.contains((Object[])flags, (Object)Base64Flags.NO_WRAP)) {
            combinedFlag |= 2;
        }
        if (ArraysKt.contains((Object[])flags, (Object)Base64Flags.NO_PADDING)) {
            combinedFlag |= 1;
        }
        return combinedFlag;
    }
}

