/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.fido;

import android.util.Base64;
import com.microsoft.identity.common.internal.fido.PublicKeyCredentialDescriptor;
import com.microsoft.identity.common.internal.fido.PublicKeyCredentialRequestOptions;
import com.microsoft.identity.common.internal.util.CommonMoshiJsonAdapter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/microsoft/identity/common/internal/fido/WebAuthnJsonUtil;", "", "()V", "Companion", "common_distRelease"})
public final class WebAuthnJsonUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final String createAssertionString(@NotNull String clientDataJson, @NotNull String authenticatorData, @NotNull String signature, @NotNull String userHandle, @NotNull String id2) {
        return Companion.createAssertionString(clientDataJson, authenticatorData, signature, userHandle, id2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J.\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\n\u0010\u0012\u001a\u00020\u0004*\u00020\u0004\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/identity/common/internal/fido/WebAuthnJsonUtil$Companion;", "", "()V", "createAssertionString", "", "clientDataJson", "authenticatorData", "signature", "userHandle", "id", "createJsonAuthRequest", "challenge", "relyingPartyIdentifier", "allowedCredentials", "", "userVerificationPolicy", "extractAuthenticatorAssertionResponseJson", "fullResponseJson", "base64UrlEncoded", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String createJsonAuthRequest(@NotNull String challenge, @NotNull String relyingPartyIdentifier, @Nullable List<String> allowedCredentials, @NotNull String userVerificationPolicy) {
            Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
            Intrinsics.checkNotNullParameter((Object)relyingPartyIdentifier, (String)"relyingPartyIdentifier");
            Intrinsics.checkNotNullParameter((Object)userVerificationPolicy, (String)"userVerificationPolicy");
            ArrayList<PublicKeyCredentialDescriptor> publicKeyCredentialDescriptorList = new ArrayList<PublicKeyCredentialDescriptor>();
            List<String> list = allowedCredentials;
            if (list != null) {
                List<String> it = list;
                boolean bl = false;
                for (String id2 : allowedCredentials) {
                    publicKeyCredentialDescriptorList.add(new PublicKeyCredentialDescriptor("public-key", id2));
                }
            }
            PublicKeyCredentialRequestOptions options = new PublicKeyCredentialRequestOptions(this.base64UrlEncoded(challenge), relyingPartyIdentifier, (List<PublicKeyCredentialDescriptor>)publicKeyCredentialDescriptorList, userVerificationPolicy);
            String string2 = new CommonMoshiJsonAdapter().toJson(options);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CommonMoshiJsonAdapter().toJson(options)");
            return string2;
        }

        @NotNull
        public final String extractAuthenticatorAssertionResponseJson(@NotNull String fullResponseJson) {
            Intrinsics.checkNotNullParameter((Object)fullResponseJson, (String)"fullResponseJson");
            JSONObject fullResponseJsonObject = new JSONObject(fullResponseJson);
            JSONObject authResponseJsonObject = fullResponseJsonObject.getJSONObject("response");
            JSONObject assertionResult = new JSONObject();
            assertionResult.put("id", fullResponseJsonObject.get("id"));
            assertionResult.put("authenticatorData", authResponseJsonObject.get("authenticatorData"));
            assertionResult.put("clientDataJSON", authResponseJsonObject.get("clientDataJSON"));
            assertionResult.put("signature", authResponseJsonObject.get("signature"));
            assertionResult.put("userHandle", authResponseJsonObject.get("userHandle"));
            String string2 = assertionResult.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"assertionResult.toString()");
            return string2;
        }

        @JvmStatic
        @NotNull
        public final String createAssertionString(@NotNull String clientDataJson, @NotNull String authenticatorData, @NotNull String signature, @NotNull String userHandle, @NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)clientDataJson, (String)"clientDataJson");
            Intrinsics.checkNotNullParameter((Object)authenticatorData, (String)"authenticatorData");
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            Intrinsics.checkNotNullParameter((Object)userHandle, (String)"userHandle");
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            JSONObject assertionResult = new JSONObject();
            assertionResult.put("id", (Object)id2);
            assertionResult.put("authenticatorData", (Object)authenticatorData);
            assertionResult.put("clientDataJSON", (Object)clientDataJson);
            assertionResult.put("signature", (Object)signature);
            assertionResult.put("userHandle", (Object)userHandle);
            String string2 = assertionResult.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"assertionResult.toString()");
            return string2;
        }

        @NotNull
        public final String base64UrlEncoded(@NotNull String $this$base64UrlEncoded) {
            Intrinsics.checkNotNullParameter((Object)$this$base64UrlEncoded, (String)"<this>");
            byte[] byArray = $this$base64UrlEncoded.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] data = byArray;
            String string2 = Base64.encodeToString((byte[])data, (int)11);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(data, (Ba\u2026AP or Base64.NO_PADDING))");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

