/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.internal.activebrokerdiscovery.BrokerDiscoveryClientFactory;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.controllers.BrokerMsalController;
import com.microsoft.identity.common.java.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.java.cache.ICacheKeyValueDelegate;
import com.microsoft.identity.common.java.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.logging.Logger;
import java.util.UUID;

public class SDMBroadcastReceiver {
    private static final String TAG = SDMBroadcastReceiver.class.getSimpleName();
    private static BroadcastReceiver sSDMBroadcastReceiver;

    public static synchronized void initialize(@NonNull Context context, final @NonNull SharedDeviceModeCallback sharedDeviceModeCallback) {
        if (sSDMBroadcastReceiver == null) {
            sSDMBroadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    SDMBroadcastReceiver.handleSharedDeviceModeBroadCast(context, intent, sharedDeviceModeCallback);
                }
            };
            IntentFilter filter = new IntentFilter("com.microsoft.identity.client.sharedmode.CURRENT_ACCOUNT_CHANGED");
            if (Build.VERSION.SDK_INT >= 26) {
                context.registerReceiver(sSDMBroadcastReceiver, filter, 2);
            } else {
                context.registerReceiver(sSDMBroadcastReceiver, filter);
            }
        }
    }

    private static void handleSharedDeviceModeBroadCast(@NonNull Context context, @NonNull Intent intent, @NonNull SharedDeviceModeCallback sharedDeviceModeCallback) {
        String methodTag = TAG + ":handleSharedDeviceModeBroadCast";
        String broadcastType = intent.getStringExtra("BROADCAST_TYPE");
        Logger.info(methodTag, "Received SDM broadcast with type: " + broadcastType);
        try {
            IPlatformComponents platformComponents = AndroidPlatformComponentsFactory.createFromContext(context);
            if (broadcastType == null) {
                Logger.warn(methodTag, "ignoring null broadcast type ");
            } else {
                switch (broadcastType) {
                    case "SDM_REGISTRATION_START": {
                        sharedDeviceModeCallback.onSharedDeviceModeRegistrationStarted();
                        break;
                    }
                    case "SDM_REGISTERED": {
                        if (SDMBroadcastReceiver.isDeviceInSharedMode(context, platformComponents)) {
                            Logger.info(methodTag, "Device is registered in SDM, clearing default account cache.");
                            SharedPreferencesAccountCredentialCache accountCredentialCache = new SharedPreferencesAccountCredentialCache((ICacheKeyValueDelegate)new CacheKeyValueDelegate(), platformComponents.getStorageSupplier().getEncryptedNameValueStore("com.microsoft.identity.client.account_credential_cache", String.class));
                            accountCredentialCache.clearAll();
                            sharedDeviceModeCallback.onSharedDeviceModeRegistered();
                            break;
                        }
                        Logger.warn(methodTag, "Device not in shared device mode, ignore broadcast.");
                        break;
                    }
                    case "GLOBAL_SIGN_OUT": {
                        sharedDeviceModeCallback.onGlobalSignOut();
                        break;
                    }
                    default: {
                        Logger.warn(methodTag, "ignoring unknown broadcast type " + broadcastType);
                    }
                }
            }
        }
        catch (BaseException e) {
            Logger.error(methodTag, "Failed to handle SDM broadcast", e);
        }
    }

    private static boolean isDeviceInSharedMode(@NonNull Context context, @NonNull IPlatformComponents platformComponents) throws BaseException {
        BrokerData activeBroker = BrokerDiscoveryClientFactory.getInstanceForBrokerSdk(context, platformComponents).getActiveBroker(false);
        if (activeBroker == null) {
            return false;
        }
        BrokerMsalController brokerMsalController = new BrokerMsalController(context, platformComponents, activeBroker.getPackageName());
        CommandParameters commandParameters = CommandParameters.builder().platformComponents(platformComponents).correlationId(UUID.randomUUID().toString()).build();
        return brokerMsalController.getDeviceMode(commandParameters);
    }

    public static interface SharedDeviceModeCallback {
        public void onSharedDeviceModeRegistrationStarted();

        public void onSharedDeviceModeRegistered();

        public void onGlobalSignOut();
    }
}

