/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.os.Build;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.java.crypto.Algorithm;
import com.microsoft.identity.common.java.crypto.CryptoSuite;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import com.microsoft.identity.common.java.crypto.SymmetricAlgorithm;
import java.security.KeyStore;

public enum SymmetricCipher implements CryptoSuite
{
    AES_GCM_NONE_HMACSHA256(SymmetricAlgorithm.Builder.of((String)"AES/GCM/NoPadding"), "HmacSHA256", 256){

        @Override
        public KeyGenParameterSpec.Builder decorateKeyGenerator(@NonNull KeyGenParameterSpec.Builder spec) {
            if (Build.VERSION.SDK_INT >= 23) {
                return spec.setBlockModes(new String[]{"GCM"}).setEncryptionPaddings(new String[]{"NoPadding"}).setKeySize(this.keySize());
            }
            return spec;
        }
    };

    SymmetricAlgorithm mValue;
    String mMacString;
    int mKeySize;

    private SymmetricCipher(SymmetricAlgorithm value, String macValue, int keySize) {
        this.mValue = value;
        this.mMacString = macValue;
        this.mKeySize = keySize;
    }

    public Algorithm cipher() {
        return this.mValue;
    }

    public String macName() {
        return this.mMacString;
    }

    public boolean isAsymmetric() {
        return false;
    }

    public Class<? extends KeyStore.Entry> keyClass() {
        return KeyStore.SecretKeyEntry.class;
    }

    public int keySize() {
        return this.mKeySize;
    }

    public SigningAlgorithm signingAlgorithm() {
        return null;
    }

    @NonNull
    public abstract KeyGenParameterSpec.Builder decorateKeyGenerator(@NonNull KeyGenParameterSpec.Builder var1);
}

