/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.migration;

import com.microsoft.identity.common.adal.internal.cache.ADALTokenCacheItem;
import com.microsoft.identity.common.internal.migration.AdalMigrationAdapter;
import com.microsoft.identity.common.java.cache.ITokenCacheItem;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.foci.FociQueryUtilities;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.java.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.java.providers.oauth2.TokenResult;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.NonNull;

public class TokenCacheItemMigrationAdapter {
    private static final String TAG = TokenCacheItemMigrationAdapter.class.getSimpleName();
    private static final String COMMON = "/common";
    public static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();

    public static List<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>> migrateTokens(@NonNull Map<String, String> redirects, @NonNull Collection<ADALTokenCacheItem> cacheItems) {
        if (redirects == null) {
            throw new NullPointerException("redirects is marked non-null but is null");
        }
        if (cacheItems == null) {
            throw new NullPointerException("cacheItems is marked non-null but is null");
        }
        ArrayList<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>> result = new ArrayList<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>>();
        boolean cloudMetadataLoaded = AdalMigrationAdapter.loadCloudDiscoveryMetadata();
        if (cloudMetadataLoaded) {
            List<ADALTokenCacheItem> cacheItemsWithoutDuplicates = TokenCacheItemMigrationAdapter.filterDuplicateTokens(cacheItems);
            Map<String, List<ADALTokenCacheItem>> tokensByClientId = TokenCacheItemMigrationAdapter.splitTokensByClientId(cacheItemsWithoutDuplicates);
            Map<String, List<ADALTokenCacheItem>> filteredTokens = TokenCacheItemMigrationAdapter.preferentiallySelectTokens(tokensByClientId);
            ArrayList<ADALTokenCacheItem> cacheItemsToRenew = new ArrayList<ADALTokenCacheItem>();
            for (List<ADALTokenCacheItem> cacheItemList : filteredTokens.values()) {
                cacheItemsToRenew.addAll(cacheItemList);
            }
            result.addAll(TokenCacheItemMigrationAdapter.renewTokens(redirects, cacheItemsToRenew));
        }
        return result;
    }

    private static List<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>> renewTokens(final @NonNull Map<String, String> redirects, final @NonNull List<ADALTokenCacheItem> filteredTokens) {
        if (redirects == null) {
            throw new NullPointerException("redirects is marked non-null but is null");
        }
        if (filteredTokens == null) {
            throw new NullPointerException("filteredTokens is marked non-null but is null");
        }
        final ArrayList<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>> result = new ArrayList<Map.Entry<MicrosoftAccount, MicrosoftRefreshToken>>();
        int tokenCount = filteredTokens.size();
        final CountDownLatch latch = new CountDownLatch(tokenCount);
        int ii = 0;
        while (ii < tokenCount) {
            final int subIndex = ii++;
            sBackgroundExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    ADALTokenCacheItem targetCacheItemToRenew = (ADALTokenCacheItem)filteredTokens.get(subIndex);
                    Map.Entry<MicrosoftAccount, MicrosoftRefreshToken> renewedKeyValuePair = TokenCacheItemMigrationAdapter.renewToken((String)redirects.get(targetCacheItemToRenew.getClientId()), (ITokenCacheItem)targetCacheItemToRenew);
                    if (null != renewedKeyValuePair) {
                        result.add(renewedKeyValuePair);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Logger.error((String)TAG, (String)"Interrupted while requesting tokens...", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return result;
    }

    @Nullable
    public static Map.Entry<MicrosoftAccount, MicrosoftRefreshToken> renewToken(@Nullable String redirectUri, @NonNull ITokenCacheItem targetCacheItemToRenew) {
        if (targetCacheItemToRenew == null) {
            throw new NullPointerException("targetCacheItemToRenew is marked non-null but is null");
        }
        AbstractMap.SimpleEntry<MicrosoftStsAccount, MicrosoftStsRefreshToken> resultKeyValuePair = null;
        if (!StringUtil.isNullOrEmpty((String)redirectUri)) {
            try {
                String authority = targetCacheItemToRenew.getAuthority();
                String clientId = targetCacheItemToRenew.getClientId();
                String refreshToken = targetCacheItemToRenew.getRefreshToken();
                MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
                config.setAuthorityUrl(new URL(authority));
                UUID correlationId = UUID.randomUUID();
                String scopes = StringUtil.isNullOrEmpty((String)targetCacheItemToRenew.getResource()) ? BaseController.getDelimitedDefaultScopeString() : TokenCacheItemMigrationAdapter.getScopesForTokenRequest(targetCacheItemToRenew.getResource());
                OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().build();
                MicrosoftStsOAuth2Strategy strategy = new MicrosoftStsOAuth2Strategy(config, strategyParameters);
                MicrosoftStsTokenRequest tokenRequest = FociQueryUtilities.createTokenRequest((String)clientId, (String)scopes, (String)refreshToken, (String)redirectUri, (MicrosoftStsOAuth2Strategy)strategy, (UUID)correlationId, (String)"2");
                TokenResult tokenResult = strategy.requestToken((TokenRequest)tokenRequest);
                if (tokenResult.getSuccess()) {
                    MicrosoftStsTokenResponse tokenResponse = (MicrosoftStsTokenResponse)tokenResult.getTokenResponse();
                    tokenResponse.setClientId(clientId);
                    MicrosoftStsAccount account = strategy.createAccount(tokenResponse);
                    MicrosoftStsRefreshToken msStsRt = new MicrosoftStsRefreshToken(tokenResponse);
                    msStsRt.setEnvironment(AzureActiveDirectory.getAzureActiveDirectoryCloud((URL)new URL(authority)).getPreferredCacheHostName());
                    resultKeyValuePair = new AbstractMap.SimpleEntry<MicrosoftStsAccount, MicrosoftStsRefreshToken>(account, msStsRt);
                } else {
                    Logger.warn((String)TAG, (String)correlationId.toString(), (String)"TokenRequest was unsuccessful.");
                    if (null != tokenResult.getErrorResponse()) {
                        TokenCacheItemMigrationAdapter.logTokenResultError(correlationId, tokenResult);
                    }
                }
            }
            catch (Exception e) {
                Logger.errorPII((String)TAG, (String)"Failed to request new refresh token...", (Throwable)e);
            }
        }
        return resultKeyValuePair;
    }

    @NonNull
    public static List<ADALTokenCacheItem> filterDuplicateTokens(@NonNull Collection<ADALTokenCacheItem> cacheItems) {
        if (cacheItems == null) {
            throw new NullPointerException("cacheItems is marked non-null but is null");
        }
        ArrayList<ADALTokenCacheItem> cacheItemsFiltered = new ArrayList<ADALTokenCacheItem>();
        HashMap<String, ADALTokenCacheItem> cacheItemMap = new HashMap<String, ADALTokenCacheItem>();
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (null == cacheItem.getResource()) {
                Logger.warn((String)TAG, (String)"Skipping resourceless token.");
                continue;
            }
            if (null == cacheItemMap.get(cacheItem.getRefreshToken())) {
                cacheItemMap.put(cacheItem.getRefreshToken(), cacheItem);
            }
            if (null == cacheItemMap.get(cacheItem.getRefreshToken()) || !cacheItem.getAuthority().contains(COMMON)) continue;
            cacheItemMap.put(cacheItem.getRefreshToken(), cacheItem);
        }
        cacheItemsFiltered.addAll(cacheItemMap.values());
        return cacheItemsFiltered;
    }

    @NonNull
    public static Map<String, List<ADALTokenCacheItem>> splitTokensByClientId(@NonNull List<ADALTokenCacheItem> cacheItemsIn) {
        if (cacheItemsIn == null) {
            throw new NullPointerException("cacheItemsIn is marked non-null but is null");
        }
        String methodTag = TAG + ":splitTokensByClientId";
        Logger.verbose((String)methodTag, (String)("Splitting [" + cacheItemsIn.size() + "] cache items."));
        HashMap<String, List<ADALTokenCacheItem>> cacheItemsOut = new HashMap<String, List<ADALTokenCacheItem>>();
        for (ADALTokenCacheItem cacheItem : cacheItemsIn) {
            if (null == cacheItemsOut.get(cacheItem.getClientId())) {
                cacheItemsOut.put(cacheItem.getClientId(), new ArrayList());
            }
            ((List)cacheItemsOut.get(cacheItem.getClientId())).add(cacheItem);
        }
        return cacheItemsOut;
    }

    public static Map<String, List<ADALTokenCacheItem>> preferentiallySelectTokens(@NonNull Map<String, List<ADALTokenCacheItem>> tokensByClientId) {
        if (tokensByClientId == null) {
            throw new NullPointerException("tokensByClientId is marked non-null but is null");
        }
        String methodTag = TAG + ":preferentiallySelectTokens";
        HashMap<String, List<ADALTokenCacheItem>> result = new HashMap<String, List<ADALTokenCacheItem>>();
        for (Map.Entry<String, List<ADALTokenCacheItem>> entry : tokensByClientId.entrySet()) {
            String clientId = entry.getKey();
            List<ADALTokenCacheItem> tokens = entry.getValue();
            ADALTokenCacheItem refreshToken = TokenCacheItemMigrationAdapter.findFrt(tokens);
            if (null == refreshToken) {
                Logger.verbose((String)methodTag, (String)"FRT was null. Try MRRT.");
                refreshToken = TokenCacheItemMigrationAdapter.findMrrt(tokens);
            }
            if (null == refreshToken) {
                Logger.verbose((String)methodTag, (String)"MRRT was null. Try RT.");
                refreshToken = TokenCacheItemMigrationAdapter.findRt(tokens);
            }
            if (null != refreshToken) {
                if (null == result.get(clientId)) {
                    result.put(clientId, new ArrayList());
                }
                ((List)result.get(clientId)).add(refreshToken);
                continue;
            }
            Logger.warn((String)methodTag, (String)"Refresh token could not be located.");
        }
        return result;
    }

    @Nullable
    public static ADALTokenCacheItem findRt(@NonNull List<ADALTokenCacheItem> cacheItems) {
        if (cacheItems == null) {
            throw new NullPointerException("cacheItems is marked non-null but is null");
        }
        String methodTag = TAG + ":findRt";
        ADALTokenCacheItem result = null;
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (StringUtil.isNullOrEmpty((String)cacheItem.getRefreshToken())) continue;
            result = cacheItem;
            Logger.verbose((String)methodTag, (String)"RT found.");
            break;
        }
        return result;
    }

    @Nullable
    public static ADALTokenCacheItem findMrrt(@NonNull List<ADALTokenCacheItem> cacheItems) {
        if (cacheItems == null) {
            throw new NullPointerException("cacheItems is marked non-null but is null");
        }
        String methodTag = TAG + ":findMrrt";
        ADALTokenCacheItem result = null;
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (StringUtil.isNullOrEmpty((String)cacheItem.getRefreshToken()) || !cacheItem.getIsMultiResourceRefreshToken()) continue;
            result = cacheItem;
            Logger.verbose((String)methodTag, (String)"Mrrt found.");
            break;
        }
        return result;
    }

    @Nullable
    public static ADALTokenCacheItem findFrt(@NonNull List<ADALTokenCacheItem> cacheItems) {
        if (cacheItems == null) {
            throw new NullPointerException("cacheItems is marked non-null but is null");
        }
        String methodTag = TAG + ":findFrt";
        ADALTokenCacheItem result = null;
        for (ADALTokenCacheItem cacheItem : cacheItems) {
            if (StringUtil.isNullOrEmpty((String)cacheItem.getRefreshToken()) || StringUtil.isNullOrEmpty((String)cacheItem.getFamilyClientId())) continue;
            result = cacheItem;
            Logger.verbose((String)methodTag, (String)"Frt found.");
            break;
        }
        return result;
    }

    @NonNull
    public static String getScopesForTokenRequest(@NonNull String v1Resource) {
        if (v1Resource == null) {
            throw new NullPointerException("v1Resource is marked non-null but is null");
        }
        String scopes = MicrosoftStsOAuth2Strategy.getScopeFromResource((String)v1Resource);
        scopes = scopes + " " + BaseController.getDelimitedDefaultScopeString();
        return scopes;
    }

    public static void logTokenResultError(@NonNull UUID correlationId, @NonNull TokenResult tokenResult) {
        if (correlationId == null) {
            throw new NullPointerException("correlationId is marked non-null but is null");
        }
        if (tokenResult == null) {
            throw new NullPointerException("tokenResult is marked non-null but is null");
        }
        TokenErrorResponse tokenErrorResponse = tokenResult.getErrorResponse();
        Logger.warn((String)TAG, (String)correlationId.toString(), (String)("Status code: [" + tokenErrorResponse.getStatusCode() + "]"));
        Logger.warn((String)TAG, (String)correlationId.toString(), (String)("Error description: [" + tokenErrorResponse.getErrorDescription() + "]"));
    }
}

