/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.internal.ui.webview.ISendResultCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICancelCbaCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICertDetails;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDisconnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ISmartcardSession;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardCertPickerDialog;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardPinDialog;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractSmartcardCertBasedAuthChallengeHandler<T extends AbstractSmartcardCertBasedAuthManager>
extends AbstractCertBasedAuthChallengeHandler {
    protected static final String MAX_ATTEMPTS_MESSAGE = "User has reached the maximum failed attempts allowed.";
    protected static final String NO_PIV_CERTS_FOUND_MESSAGE = "No PIV certificates found on smartcard device.";
    protected static final String USER_CANCEL_MESSAGE = "User canceled smartcard CBA flow.";
    protected final String TAG;
    protected final Activity mActivity;
    protected final T mCbaManager;
    protected final IDialogHolder mDialogHolder;

    public AbstractSmartcardCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull T smartcardCertBasedAuthManager, @NonNull IDialogHolder dialogHolder, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper, @NonNull String tag) {
        this.TAG = tag;
        this.mActivity = activity;
        this.mIsCertBasedAuthProceeding = false;
        this.mCbaManager = smartcardCertBasedAuthManager;
        this.mDialogHolder = dialogHolder;
        this.mTelemetryHelper = telemetryHelper;
        this.mTelemetryHelper.setCertBasedAuthChallengeHandler(this.TAG);
    }

    @Override
    @RequiresApi(api=21)
    public Void processChallenge(final ClientCertRequest request) {
        final String methodTag = this.TAG + ":processChallenge";
        ((AbstractSmartcardCertBasedAuthManager)this.mCbaManager).requestDeviceSession(new AbstractSmartcardCertBasedAuthManager.ISessionCallback(){

            @Override
            public void onGetSession(@NonNull ISmartcardSession session) throws Exception {
                final int pinAttemptsRemaining = session.getPinAttemptsRemaining();
                final List<ICertDetails> certList = session.getCertDetailsList();
                AbstractSmartcardCertBasedAuthChallengeHandler.this.prepForNextUserInteraction(new IDisconnectionCallback(){

                    @Override
                    public void onClosedConnection() {
                        if (pinAttemptsRemaining == 0) {
                            AbstractSmartcardCertBasedAuthChallengeHandler.this.promptTooManyFailedPinAttempts(methodTag);
                            request.cancel();
                            return;
                        }
                        if (certList.isEmpty()) {
                            Logger.info(methodTag, AbstractSmartcardCertBasedAuthChallengeHandler.NO_PIV_CERTS_FOUND_MESSAGE);
                            AbstractSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure(AbstractSmartcardCertBasedAuthChallengeHandler.NO_PIV_CERTS_FOUND_MESSAGE);
                            AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showErrorDialog(R.string.smartcard_no_cert_dialog_title, R.string.smartcard_no_cert_dialog_message);
                            request.cancel();
                            return;
                        }
                        AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showCertPickerDialog(certList, AbstractSmartcardCertBasedAuthChallengeHandler.this.getSmartcardCertPickerDialogPositiveButtonListener(request), AbstractSmartcardCertBasedAuthChallengeHandler.this.getGeneralCancelCbaCallback(request));
                    }
                });
            }

            @Override
            public void onException(final @NonNull Exception e) {
                request.cancel();
                AbstractSmartcardCertBasedAuthChallengeHandler.this.prepForNextUserInteraction(new IDisconnectionCallback(){

                    @Override
                    public void onClosedConnection() {
                        AbstractSmartcardCertBasedAuthChallengeHandler.this.indicateGeneralException(methodTag, e);
                    }
                });
            }
        });
        return null;
    }

    protected abstract void prepForNextUserInteraction(@NonNull IDisconnectionCallback var1);

    @NonNull
    protected ICancelCbaCallback getGeneralCancelCbaCallback(final @NonNull ClientCertRequest request) {
        return new ICancelCbaCallback(){

            @Override
            @RequiresApi(api=21)
            public void onCancel() {
                AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.dismissDialog();
                AbstractSmartcardCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure(AbstractSmartcardCertBasedAuthChallengeHandler.USER_CANCEL_MESSAGE);
                request.cancel();
            }
        };
    }

    protected void promptTooManyFailedPinAttempts(@NonNull String methodTag) {
        Logger.info(methodTag, MAX_ATTEMPTS_MESSAGE);
        this.mTelemetryHelper.setResultFailure(MAX_ATTEMPTS_MESSAGE);
        this.mDialogHolder.showErrorDialog(R.string.smartcard_max_attempt_dialog_title, R.string.smartcard_max_attempt_dialog_message);
    }

    protected abstract void indicateDisconnectionError(@NonNull String var1);

    protected void indicateGeneralException(@NonNull String methodTag, @NonNull Exception e) {
        Logger.error(methodTag, e.getMessage(), e);
        this.mTelemetryHelper.setResultFailure(e);
        this.mDialogHolder.showErrorDialog(R.string.smartcard_general_error_dialog_title, R.string.smartcard_general_error_dialog_message);
    }

    private SmartcardCertPickerDialog.PositiveButtonListener getSmartcardCertPickerDialogPositiveButtonListener(final @NonNull ClientCertRequest request) {
        return new SmartcardCertPickerDialog.PositiveButtonListener(){

            @Override
            @RequiresApi(api=21)
            public void onClick(@NonNull ICertDetails certDetails) {
                AbstractSmartcardCertBasedAuthChallengeHandler.this.mDialogHolder.showPinDialog(AbstractSmartcardCertBasedAuthChallengeHandler.this.getSmartcardPinDialogPositiveButtonListener(certDetails, request), AbstractSmartcardCertBasedAuthChallengeHandler.this.getGeneralCancelCbaCallback(request));
            }
        };
    }

    protected abstract SmartcardPinDialog.PositiveButtonListener getSmartcardPinDialogPositiveButtonListener(@NonNull ICertDetails var1, @NonNull ClientCertRequest var2);

    @RequiresApi(api=21)
    protected void tryUsingSmartcardWithPin(@NonNull char[] pin, final @NonNull ICertDetails certDetails, final @NonNull ClientCertRequest request, @NonNull ISmartcardSession session) throws Exception {
        final String methodTag = this.TAG + ":tryUsingSmartcardWithPin";
        if (session.verifyPin(pin)) {
            this.useSmartcardCertForAuth(certDetails, pin, session, request);
            return;
        }
        final int attemptsRemaining = session.getPinAttemptsRemaining();
        this.prepForNextUserInteraction(new IDisconnectionCallback(){

            @Override
            public void onClosedConnection() {
                if (attemptsRemaining == 0) {
                    AbstractSmartcardCertBasedAuthChallengeHandler.this.promptTooManyFailedPinAttempts(methodTag);
                    request.cancel();
                    return;
                }
                AbstractSmartcardCertBasedAuthChallengeHandler.this.setPinDialogForIncorrectAttempt(certDetails, request);
            }
        });
    }

    protected abstract void setPinDialogForIncorrectAttempt(@NonNull ICertDetails var1, @NonNull ClientCertRequest var2);

    @RequiresApi(api=21)
    protected void useSmartcardCertForAuth(@NonNull ICertDetails certDetails, @NonNull char[] pin, @NonNull ISmartcardSession session, @NonNull ClientCertRequest request) throws Exception {
        ((AbstractSmartcardCertBasedAuthManager)this.mCbaManager).initBeforeProceedingWithRequest(this.mTelemetryHelper);
        PrivateKey privateKey = session.getKeyForAuth(certDetails, pin);
        X509Certificate[] chain = new X509Certificate[]{certDetails.getCertificate()};
        this.mTelemetryHelper.setPublicKeyAlgoType(chain[0].getPublicKey().getAlgorithm());
        this.mDialogHolder.dismissDialog();
        this.mIsCertBasedAuthProceeding = true;
        request.proceed(privateKey, chain);
    }

    protected void clearPin(@NonNull char[] pin) {
        Arrays.fill(pin, '\u0000');
    }

    public abstract void promptSmartcardRemovalForResult(@NonNull ISendResultCallback var1);

    @Override
    public void cleanUp() {
        this.mDialogHolder.dismissDialog();
        this.clearAllManagerCallbacks();
    }

    protected abstract void clearAllManagerCallbacks();
}

