/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.fido;

import android.os.Build;
import android.webkit.WebView;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleOwnerKt;
import com.microsoft.identity.common.internal.fido.FidoChallenge;
import com.microsoft.identity.common.internal.fido.IFidoManager;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B)\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u0015H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u0002H\u0016J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eJD\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0010\b\u0002\u0010\u0013\u001a\n\u0018\u00010\u0014j\u0004\u0018\u0001`\u00152\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u000eR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/microsoft/identity/common/internal/fido/AuthFidoChallengeHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/IChallengeHandler;", "Lcom/microsoft/identity/common/internal/fido/FidoChallenge;", "Ljava/lang/Void;", "fidoManager", "Lcom/microsoft/identity/common/internal/fido/IFidoManager;", "webView", "Landroid/webkit/WebView;", "spanContext", "Lio/opentelemetry/api/trace/SpanContext;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "(Lcom/microsoft/identity/common/internal/fido/IFidoManager;Landroid/webkit/WebView;Lio/opentelemetry/api/trace/SpanContext;Landroidx/lifecycle/LifecycleOwner;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "getErrorAssertion", "errorMessage", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "processChallenge", "fidoChallenge", "respondToChallenge", "", "submitUrl", "assertion", "context", "span", "Lio/opentelemetry/api/trace/Span;", "respondToChallengeWithError", "methodTag", "common_distRelease"})
public final class AuthFidoChallengeHandler
implements IChallengeHandler<FidoChallenge, Void> {
    @NotNull
    private final IFidoManager fidoManager;
    @NotNull
    private final WebView webView;
    @Nullable
    private final SpanContext spanContext;
    @Nullable
    private final LifecycleOwner lifecycleOwner;
    @NotNull
    private final String TAG;

    public AuthFidoChallengeHandler(@NotNull IFidoManager fidoManager, @NotNull WebView webView, @Nullable SpanContext spanContext, @Nullable LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)fidoManager, (String)"fidoManager");
        Intrinsics.checkNotNullParameter((Object)webView, (String)"webView");
        this.fidoManager = fidoManager;
        this.webView = webView;
        this.spanContext = spanContext;
        this.lifecycleOwner = lifecycleOwner;
        this.TAG = String.valueOf(Reflection.getOrCreateKotlinClass(AuthFidoChallengeHandler.class).getSimpleName());
    }

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    @Override
    @Nullable
    public Void processChallenge(@NotNull FidoChallenge fidoChallenge) {
        Intrinsics.checkNotNullParameter((Object)fidoChallenge, (String)"fidoChallenge");
        String methodTag = this.TAG + ":processChallenge";
        Span span = this.spanContext != null ? OTelUtility.createSpanFromParent((String)SpanName.Fido.name(), (SpanContext)this.spanContext) : OTelUtility.createSpan((String)SpanName.Fido.name());
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"if (spanContext != null)\u2026Name.Fido.name)\n        }");
        Span span2 = span;
        span2.setAttribute(AttributeName.fido_challenge_handler.name(), this.TAG);
        String submitUrl = fidoChallenge.getSubmitUrl().getOrThrow();
        String context = fidoChallenge.getContext().getOrThrow();
        if (Build.VERSION.SDK_INT < 28) {
            AuthFidoChallengeHandler.respondToChallengeWithError$default(this, submitUrl, context, span2, "Device is running on an Android version less than 9 (API 28), which is the minimum level for passkeys.", null, methodTag, 16, null);
            return null;
        }
        String authChallenge = null;
        String relyingPartyIdentifier = null;
        String userVerificationPolicy = null;
        List<String> allowedCredentials = null;
        try {
            authChallenge = fidoChallenge.getChallenge().getOrThrow();
            relyingPartyIdentifier = fidoChallenge.getRelyingPartyIdentifier().getOrThrow();
            userVerificationPolicy = fidoChallenge.getUserVerificationPolicy().getOrThrow();
            allowedCredentials = fidoChallenge.getAllowedCredentials().getOrThrow();
            fidoChallenge.getVersion().getOrThrow();
            fidoChallenge.getKeyTypes().getOrThrow();
        }
        catch (Exception e) {
            this.respondToChallengeWithError(submitUrl, context, span2, String.valueOf(e.getMessage()), e, methodTag);
            return null;
        }
        if (this.lifecycleOwner == null) {
            AuthFidoChallengeHandler.respondToChallengeWithError$default(this, submitUrl, context, span2, "Cannot get lifecycle owner needed for FIDO API calls.", null, methodTag, 16, null);
            return null;
        }
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)LifecycleOwnerKt.getLifecycleScope((LifecycleOwner)this.lifecycleOwner)), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, authChallenge, relyingPartyIdentifier, allowedCredentials, userVerificationPolicy, span2, submitUrl, context, methodTag, null){
            int label;
            final /* synthetic */ AuthFidoChallengeHandler this$0;
            final /* synthetic */ String $authChallenge;
            final /* synthetic */ String $relyingPartyIdentifier;
            final /* synthetic */ List<String> $allowedCredentials;
            final /* synthetic */ String $userVerificationPolicy;
            final /* synthetic */ Span $span;
            final /* synthetic */ String $submitUrl;
            final /* synthetic */ String $context;
            final /* synthetic */ String $methodTag;
            {
                this.this$0 = $receiver;
                this.$authChallenge = $authChallenge;
                this.$relyingPartyIdentifier = $relyingPartyIdentifier;
                this.$allowedCredentials = $allowedCredentials;
                this.$userVerificationPolicy = $userVerificationPolicy;
                this.$span = $span;
                this.$submitUrl = $submitUrl;
                this.$context = $context;
                this.$methodTag = $methodTag;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = AuthFidoChallengeHandler.access$getFidoManager$p(this.this$0).authenticate(this.$authChallenge, this.$relyingPartyIdentifier, this.$allowedCredentials, this.$userVerificationPolicy, (Continuation<? super String>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            assertion = (String)v0;
                            this.$span.setStatus(StatusCode.OK);
                            this.this$0.respondToChallenge(this.$submitUrl, assertion, this.$context, this.$span);
                        }
                        catch (Exception e) {
                            this.this$0.respondToChallengeWithError(this.$submitUrl, this.$context, this.$span, String.valueOf(e.getMessage()), e, this.$methodTag);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return null;
    }

    public final void respondToChallenge(@NotNull String submitUrl, @NotNull String assertion, @NotNull String context, @NotNull Span span) {
        Intrinsics.checkNotNullParameter((Object)submitUrl, (String)"submitUrl");
        Intrinsics.checkNotNullParameter((Object)assertion, (String)"assertion");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        String methodTag = this.TAG + ":respondToChallenge";
        span.end();
        String[] stringArray = new String[]{" "};
        List splitContextList = StringsKt.split$default((CharSequence)context, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String actualContext = null;
        String flowToken = null;
        if (splitContextList.size() == 2) {
            actualContext = (String)splitContextList.get(0);
            flowToken = (String)splitContextList.get(1);
        } else {
            actualContext = (String)splitContextList.get(0);
            flowToken = "";
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Assertion", (Object)assertion), TuplesKt.to((Object)"x-ms-ctx", (Object)actualContext), TuplesKt.to((Object)"x-ms-flowToken", (Object)flowToken)};
        Map header = MapsKt.mapOf((Pair[])pairArray);
        this.webView.post(() -> AuthFidoChallengeHandler.respondToChallenge$lambda$0(methodTag, this, submitUrl, header));
    }

    public final void respondToChallengeWithError(@NotNull String submitUrl, @NotNull String context, @NotNull Span span, @NotNull String errorMessage, @Nullable Exception exception, @Nullable String methodTag) {
        Intrinsics.checkNotNullParameter((Object)submitUrl, (String)"submitUrl");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Logger.error(methodTag, errorMessage, exception);
        if (exception != null) {
            span.recordException((Throwable)exception);
            span.setStatus(StatusCode.ERROR);
        } else {
            span.setStatus(StatusCode.ERROR, errorMessage);
        }
        this.respondToChallenge(submitUrl, this.getErrorAssertion(errorMessage, exception), context, span);
    }

    public static /* synthetic */ void respondToChallengeWithError$default(AuthFidoChallengeHandler authFidoChallengeHandler, String string, String string2, Span span, String string3, Exception exception, String string4, int n, Object object) {
        if ((n & 0x10) != 0) {
            exception = null;
        }
        if ((n & 0x20) != 0) {
            string4 = authFidoChallengeHandler.TAG + ":respondToChallengeWithError";
        }
        authFidoChallengeHandler.respondToChallengeWithError(string, string2, span, string3, exception, string4);
    }

    private final String getErrorAssertion(String errorMessage, Exception exception) {
        if (exception != null) {
            return "ERROR: " + exception.getClass().getName() + ": " + exception.getMessage();
        }
        return "ERROR: " + errorMessage;
    }

    static /* synthetic */ String getErrorAssertion$default(AuthFidoChallengeHandler authFidoChallengeHandler, String string, Exception exception, int n, Object object) {
        if ((n & 2) != 0) {
            exception = null;
        }
        return authFidoChallengeHandler.getErrorAssertion(string, exception);
    }

    private static final void respondToChallenge$lambda$0(String $methodTag, AuthFidoChallengeHandler this$0, String $submitUrl, Map $header) {
        Intrinsics.checkNotNullParameter((Object)$methodTag, (String)"$methodTag");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$submitUrl, (String)"$submitUrl");
        Intrinsics.checkNotNullParameter((Object)$header, (String)"$header");
        Logger.info($methodTag, "Responding to Fido challenge.");
        this$0.webView.loadUrl($submitUrl, $header);
    }

    public static final /* synthetic */ IFidoManager access$getFidoManager$p(AuthFidoChallengeHandler $this) {
        return $this.fidoManager;
    }
}

