/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.content.Context;
import android.security.KeyChain;
import android.security.KeyChainAliasCallback;
import android.security.KeyChainException;
import android.webkit.ClientCertRequest;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;

public class OnDeviceCertBasedAuthChallengeHandler
extends AbstractCertBasedAuthChallengeHandler {
    private static final String TAG = OnDeviceCertBasedAuthChallengeHandler.class.getSimpleName();
    private static final String ECDSA_CONSTANT = "ECDSA";
    private final Activity mActivity;

    public OnDeviceCertBasedAuthChallengeHandler(@NonNull Activity activity, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        this.mActivity = activity;
        this.mTelemetryHelper = telemetryHelper;
        this.mTelemetryHelper.setCertBasedAuthChallengeHandler(TAG);
        this.mIsCertBasedAuthProceeding = false;
    }

    @Override
    @RequiresApi(api=23)
    public Void processChallenge(final ClientCertRequest request) {
        final String methodTag = TAG + ":processChallenge";
        Logger.info(methodTag, this.printRequestDetails(request));
        KeyChain.choosePrivateKeyAlias((Activity)this.mActivity, (KeyChainAliasCallback)new KeyChainAliasCallback(){

            public void alias(String alias) {
                if (alias == null) {
                    String message = "No certificate chosen by user, cancelling the TLS request.";
                    Logger.info(methodTag, "No certificate chosen by user, cancelling the TLS request.");
                    OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure("No certificate chosen by user, cancelling the TLS request.");
                    request.cancel();
                    return;
                }
                try {
                    X509Certificate[] certChain = KeyChain.getCertificateChain((Context)OnDeviceCertBasedAuthChallengeHandler.this.mActivity.getApplicationContext(), (String)alias);
                    if (certChain.length > 0) {
                        OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setPublicKeyAlgoType(certChain[0].getPublicKey().getAlgorithm());
                    }
                    PrivateKey privateKey = KeyChain.getPrivateKey((Context)OnDeviceCertBasedAuthChallengeHandler.this.mActivity, (String)alias);
                    Logger.info(methodTag, "Certificate is chosen by user, proceed with TLS request.");
                    OnDeviceCertBasedAuthChallengeHandler.this.mIsCertBasedAuthProceeding = true;
                    request.proceed(privateKey, certChain);
                    return;
                }
                catch (KeyChainException e) {
                    Logger.errorPII(methodTag, "KeyChain exception", e);
                    OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure((Exception)((Object)e));
                }
                catch (InterruptedException e) {
                    Logger.errorPII(methodTag, "InterruptedException exception", e);
                    OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure((Exception)e);
                }
                OnDeviceCertBasedAuthChallengeHandler.this.mTelemetryHelper.setResultFailure("ClientCertRequest unexpectedly cancelled.");
                request.cancel();
            }
        }, (String[])OnDeviceCertBasedAuthChallengeHandler.mapKeyTypes(request.getKeyTypes()), (Principal[])request.getPrincipals(), (String)request.getHost(), (int)request.getPort(), null);
        return null;
    }

    @RequiresApi(api=23)
    private String printRequestDetails(ClientCertRequest request) {
        StringBuilder logLine = new StringBuilder(256);
        logLine.append("Processing CBA challenge.");
        if (request.getKeyTypes() != null) {
            logLine.append("\nKey Types: ");
            for (String k : request.getKeyTypes()) {
                logLine.append(k).append(", ");
            }
        }
        if (request.getPrincipals() != null) {
            logLine.append("\nPrincipals: ");
            for (Principal p : request.getPrincipals()) {
                logLine.append(p.getName()).append(", ");
            }
        }
        logLine.append("\nHost: ").append(request.getHost()).append("\nPort: ").append(request.getPort());
        return logLine.toString();
    }

    @Override
    public void cleanUp() {
    }

    @RequiresApi(api=23)
    @Nullable
    public static String[] mapKeyTypes(@Nullable String[] keyTypes) {
        if (keyTypes == null) {
            return null;
        }
        for (int i = 0; i < keyTypes.length; ++i) {
            if (!keyTypes[i].equals(ECDSA_CONSTANT)) continue;
            keyTypes[i] = "EC";
            break;
        }
        return keyTypes;
    }
}

