/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.AuthenticationConstants;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.request.AuthenticationSchemeTypeAdapter;
import com.microsoft.identity.common.internal.request.IBrokerRequestAdapter;
import com.microsoft.identity.common.internal.util.GzipUtil;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authscheme.AuthenticationSchemeFactory;
import com.microsoft.identity.common.java.authscheme.INameable;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.commands.parameters.AcquirePrtSsoTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.opentelemetry.SerializableSpanContext;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.java.util.BrokerProtocolVersionUtil;
import com.microsoft.identity.common.java.util.ObjectMapper;
import com.microsoft.identity.common.java.util.QueryParamsAdapter;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MsalBrokerRequestAdapter
implements IBrokerRequestAdapter {
    private static final String TAG = MsalBrokerRequestAdapter.class.getSimpleName();

    @Override
    public BrokerRequest brokerRequestFromAcquireTokenParameters(@NonNull InteractiveTokenCommandParameters parameters) {
        String methodTag = TAG + ":brokerRequestFromAcquireTokenParameters";
        Logger.info(methodTag, "Constructing result bundle from AcquireTokenOperationParameters.");
        String extraQueryStringParameter = parameters.getExtraQueryStringParameters() != null ? QueryParamsAdapter._toJson((List)parameters.getExtraQueryStringParameters()) : null;
        String extraOptions = parameters.getExtraOptions() != null ? QueryParamsAdapter._toJson((List)parameters.getExtraOptions()) : null;
        BrokerRequest brokerRequest = BrokerRequest.builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", (Iterable)parameters.getScopes())).redirect(parameters.getRedirectUri()).clientId(parameters.getClientId()).childRedirectUri(parameters.getChildRedirectUri()).childClientId(parameters.getChildClientId()).userName(parameters.getLoginHint()).extraQueryStringParameter(extraQueryStringParameter).extraOptions(extraOptions).prompt(OpenIdConnectPromptParameter.UNSET.name().equals(parameters.getPrompt().name()) ? null : parameters.getPrompt().name()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.isForceRefresh()).correlationId(parameters.getCorrelationId()).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).sdkType(parameters.getSdkType()).environment(AzureActiveDirectory.getEnvironment().name()).multipleCloudsSupported(this.getMultipleCloudsSupported((TokenCommandParameters)parameters)).authorizationAgent(parameters.isBrokerBrowserSupportEnabled() ? AuthorizationAgent.BROWSER.name() : AuthorizationAgent.WEBVIEW.name()).authenticationScheme(parameters.getAuthenticationScheme()).powerOptCheckEnabled(parameters.isPowerOptCheckEnabled()).spanContext(SerializableSpanContext.builder().traceId(SpanExtension.current().getSpanContext().getTraceId()).spanId(SpanExtension.current().getSpanContext().getSpanId()).traceFlags(SpanExtension.current().getSpanContext().getTraceFlags().asByte()).build()).preferredBrowser(parameters.getPreferredBrowser()).preferredAuthMethod(parameters.getPreferredAuthMethod()).accountTransferToken(parameters.getAccountTransferToken()).build();
        return brokerRequest;
    }

    @Override
    public BrokerRequest brokerRequestFromDeviceCodeFlowCommandParameters(@NonNull DeviceCodeFlowCommandParameters parameters) {
        String methodTag = TAG + ":brokerRequestFromDeviceCodeFlowCommandParameters";
        Logger.info(methodTag, "Constructing result bundle from DeviceCodeFlowCommandParameters.");
        String extraOptions = parameters.getExtraOptions() != null ? QueryParamsAdapter._toJson((List)parameters.getExtraOptions()) : null;
        BrokerRequest brokerRequest = BrokerRequest.builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", (Iterable)parameters.getScopes())).redirect(parameters.getRedirectUri()).extraOptions(extraOptions).clientId(parameters.getClientId()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.isForceRefresh()).correlationId(parameters.getCorrelationId()).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).sdkType(parameters.getSdkType()).environment(AzureActiveDirectory.getEnvironment().name()).multipleCloudsSupported(this.getMultipleCloudsSupported((TokenCommandParameters)parameters)).authenticationScheme(parameters.getAuthenticationScheme()).build();
        return brokerRequest;
    }

    @Override
    public BrokerRequest brokerRequestFromSilentOperationParameters(@NonNull SilentTokenCommandParameters parameters) {
        String methodTag = TAG + ":brokerRequestFromSilentOperationParameters";
        Logger.info(methodTag, "Constructing result bundle from AcquireTokenSilentOperationParameters.");
        String extraOptions = parameters.getExtraOptions() != null ? QueryParamsAdapter._toJson((List)parameters.getExtraOptions()) : null;
        BrokerRequest brokerRequest = BrokerRequest.builder().authority(parameters.getAuthority().getAuthorityURL().toString()).scope(TextUtils.join((CharSequence)" ", (Iterable)parameters.getScopes())).redirect(parameters.getRedirectUri()).extraOptions(extraOptions).clientId(parameters.getClientId()).childRedirectUri(parameters.getChildRedirectUri()).childClientId(parameters.getChildClientId()).homeAccountId(parameters.getAccount().getHomeAccountId()).localAccountId(parameters.getAccount().getLocalAccountId()).userName(parameters.getAccount().getUsername()).claims(parameters.getClaimsRequestJson()).forceRefresh(parameters.isForceRefresh()).correlationId(parameters.getCorrelationId()).applicationName(parameters.getApplicationName()).applicationVersion(parameters.getApplicationVersion()).msalVersion(parameters.getSdkVersion()).sdkType(parameters.getSdkType()).environment(AzureActiveDirectory.getEnvironment().name()).multipleCloudsSupported(this.getMultipleCloudsSupported((TokenCommandParameters)parameters)).authenticationScheme(parameters.getAuthenticationScheme()).powerOptCheckEnabled(parameters.isPowerOptCheckEnabled()).spanContext(SerializableSpanContext.builder().traceId(SpanExtension.current().getSpanContext().getTraceId()).spanId(SpanExtension.current().getSpanContext().getSpanId()).traceFlags(SpanExtension.current().getSpanContext().getTraceFlags().asByte()).build()).build();
        return brokerRequest;
    }

    @NonNull
    public Bundle getRequestBundleForSsoToken(@NonNull AcquirePrtSsoTokenCommandParameters parameters, @NonNull String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.name", parameters.getAccountName());
        requestBundle.putString("account.home.account.id", parameters.getHomeAccountId());
        requestBundle.putString("account.local.account.id", parameters.getLocalAccountId());
        requestBundle.putString("broker.sso.clientId", parameters.getClientId());
        if (parameters.getRequestAuthority() != null) {
            requestBundle.putString("request.authority", parameters.getRequestAuthority());
        }
        if (parameters.getSsoUrl() != null) {
            requestBundle.putString("ssoUrl", parameters.getSsoUrl());
        }
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        this.addRequiredBrokerProtocolVersionToRequestBundle(requestBundle, parameters.getRequiredBrokerProtocolVersion());
        requestBundle.putString("account.correlationid", parameters.getCorrelationId());
        return requestBundle;
    }

    public Bundle getRequestBundleForHello(@NonNull CommandParameters parameters) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("broker.protocol.version.name", "15.0");
        this.addRequiredBrokerProtocolVersionToRequestBundle(requestBundle, parameters.getRequiredBrokerProtocolVersion());
        return requestBundle;
    }

    public Bundle getRequestBundleForAcquireTokenInteractive(@NonNull InteractiveTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        BrokerRequest brokerRequest = this.brokerRequestFromAcquireTokenParameters(parameters);
        return this.getRequestBundleFromBrokerRequest(brokerRequest, negotiatedBrokerProtocolVersion, parameters.getRequiredBrokerProtocolVersion());
    }

    public Bundle getRequestBundleForDeviceCodeFlowAuthRequest(@NonNull Context context, @NonNull DeviceCodeFlowCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        BrokerRequest brokerRequest = this.brokerRequestFromDeviceCodeFlowCommandParameters(parameters);
        Bundle requestBundle = this.getRequestBundleFromBrokerRequest(brokerRequest, negotiatedBrokerProtocolVersion, parameters.getRequiredBrokerProtocolVersion());
        requestBundle.putInt("caller.info.uid", context.getApplicationInfo().uid);
        return requestBundle;
    }

    public Bundle getRequestBundleForDeviceCodeFlowTokenRequest(@NonNull Context context, @NonNull DeviceCodeFlowCommandParameters parameters, @NonNull AuthorizationResult authorizationResult, @Nullable String negotiatedBrokerProtocolVersion) {
        BrokerRequest brokerRequest = this.brokerRequestFromDeviceCodeFlowCommandParameters(parameters);
        Bundle requestBundle = this.getRequestBundleFromBrokerRequest(brokerRequest, negotiatedBrokerProtocolVersion, parameters.getRequiredBrokerProtocolVersion());
        requestBundle.putInt("caller.info.uid", context.getApplicationInfo().uid);
        MicrosoftStsAuthorizationResult microsoftStsAuthorizationResult = (MicrosoftStsAuthorizationResult)authorizationResult;
        requestBundle.putString("broker_dcf_auth_result", ObjectMapper.serializeObjectToJsonString((Object)microsoftStsAuthorizationResult));
        return requestBundle;
    }

    public Bundle getRequestBundleForAcquireTokenSilent(@NonNull Context context, @NonNull SilentTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        BrokerRequest brokerRequest = this.brokerRequestFromSilentOperationParameters(parameters);
        Bundle requestBundle = this.getRequestBundleFromBrokerRequest(brokerRequest, negotiatedBrokerProtocolVersion, parameters.getRequiredBrokerProtocolVersion());
        requestBundle.putInt("caller.info.uid", context.getApplicationInfo().uid);
        return requestBundle;
    }

    private Bundle getRequestBundleFromBrokerRequest(@NonNull BrokerRequest brokerRequest, @Nullable String negotiatedBrokerProtocolVersion, @Nullable String requiredBrokerProtocolVersion) {
        String methodTag = TAG + ":getRequestBundleFromBrokerRequest";
        Bundle requestBundle = new Bundle();
        if (BrokerProtocolVersionUtil.canCompressBrokerPayloads((String)negotiatedBrokerProtocolVersion)) {
            try {
                String jsonString = AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)brokerRequest, BrokerRequest.class);
                byte[] compressedBytes = GzipUtil.compressString(jsonString);
                Logger.info(methodTag, "Broker Result, raw payload size:" + jsonString.getBytes(AuthenticationConstants.CHARSET_UTF8).length + " ,compressed bytes size: " + compressedBytes.length);
                requestBundle.putByteArray("broker_request_v2_compressed", compressedBytes);
            }
            catch (IOException e) {
                Logger.error(methodTag, "Compression to bytes failed, sending broker request as json String", e);
                requestBundle.putString("broker_request_v2", AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)brokerRequest, BrokerRequest.class));
            }
        } else {
            Logger.info(methodTag, "Broker protocol version: " + negotiatedBrokerProtocolVersion + " lower than compression changes, sending as string");
            requestBundle.putString("broker_request_v2", AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)brokerRequest, BrokerRequest.class));
        }
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        this.addRequiredBrokerProtocolVersionToRequestBundle(requestBundle, requiredBrokerProtocolVersion);
        requestBundle.putBoolean("should.send.pkeyauth.header", BrokerProtocolVersionUtil.canSendPKeyAuthHeaderToTheTokenEndpoint((String)requiredBrokerProtocolVersion));
        return requestBundle;
    }

    public Bundle getRequestBundleForGetAccounts(@NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", parameters.getClientId());
        requestBundle.putString("account.redirect", parameters.getRedirectUri());
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        requestBundle.putBoolean("can.construct.accounts.from.prt.id.token", BrokerProtocolVersionUtil.canFociAppsConstructAccountsFromPrtIdTokens((String)parameters.getRequiredBrokerProtocolVersion()));
        this.addRequiredBrokerProtocolVersionToRequestBundle(requestBundle, parameters.getRequiredBrokerProtocolVersion());
        return requestBundle;
    }

    public Bundle getRequestBundleForRemoveAccount(@NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        if (null != parameters.getAccount()) {
            requestBundle.putString("account.clientid.key", parameters.getClientId());
            requestBundle.putString("environment", parameters.getAccount().getEnvironment());
            requestBundle.putString("account.home.account.id", parameters.getAccount().getHomeAccountId());
        }
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        this.addRequiredBrokerProtocolVersionToRequestBundle(requestBundle, parameters.getRequiredBrokerProtocolVersion());
        return requestBundle;
    }

    public Bundle getRequestBundleForRemoveAccountFromSharedDevice(@NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        this.addRequiredBrokerProtocolVersionToRequestBundle(requestBundle, parameters.getRequiredBrokerProtocolVersion());
        return requestBundle;
    }

    public Bundle getRequestBundleForGenerateShr(@NonNull GenerateShrCommandParameters parameters, @NonNull String negotiatedBrokerProtocolVersion) throws ClientException {
        String clientId = parameters.getClientId();
        String homeAccountId = parameters.getHomeAccountId();
        PopAuthenticationSchemeInternal popParameters = (PopAuthenticationSchemeInternal)AuthenticationSchemeFactory.createScheme((IPlatformComponents)parameters.getPlatformComponents(), (INameable)((INameable)parameters.getPopParameters()));
        String popParamsJson = AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)popParameters, PopAuthenticationSchemeInternal.class);
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", clientId);
        requestBundle.putString("account.home.account.id", homeAccountId);
        requestBundle.putString("pop_parameters", popParamsJson);
        requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        this.addRequiredBrokerProtocolVersionToRequestBundle(requestBundle, parameters.getRequiredBrokerProtocolVersion());
        return requestBundle;
    }

    private boolean getMultipleCloudsSupported(@NonNull TokenCommandParameters parameters) {
        if (parameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority authority = (AzureActiveDirectoryAuthority)parameters.getAuthority();
            return authority.isMultipleCloudsSupported();
        }
        return false;
    }

    public static List<BrowserDescriptor> getBrowserSafeListForBroker() {
        ArrayList<BrowserDescriptor> browserDescriptors = new ArrayList<BrowserDescriptor>();
        HashSet<String> signatureHashes = new HashSet<String>();
        signatureHashes.add("7fmduHKTdHHrlMvldlEqAIlSfii1tl35bxj1OXN5Ve8c4lU6URVu4xtSHc3BVZxS6WWJnxMDhIfQN0N0K2NDJg==");
        BrowserDescriptor chrome = new BrowserDescriptor("com.android.chrome", signatureHashes, null, null);
        browserDescriptors.add(chrome);
        return browserDescriptors;
    }

    private void addRequiredBrokerProtocolVersionToRequestBundle(@NonNull Bundle requestBundle, @Nullable String requiredBrokerProtocolVersion) {
        if (!StringUtil.isNullOrEmpty((String)requiredBrokerProtocolVersion)) {
            requestBundle.putString("required.broker.protocol.version.name", requiredBrokerProtocolVersion);
        }
    }
}

