/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.certbasedauth;

import android.app.Activity;
import android.os.Build;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractNfcSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.AbstractUsbSmartcardCertBasedAuthManager;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.DialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.ICancelCbaCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IConnectionCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDialogHolder;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.IDismissCallback;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.NfcSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.OnDeviceCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.SmartcardCertBasedAuthManagerFactory;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.UsbSmartcardCertBasedAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.certbasedauth.UserChoiceDialog;
import com.microsoft.identity.common.java.opentelemetry.CertBasedAuthChoice;
import com.microsoft.identity.common.java.opentelemetry.CertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.java.opentelemetry.ICertBasedAuthTelemetryHelper;
import com.microsoft.identity.common.logging.Logger;

public class CertBasedAuthFactory {
    private static final String TAG = CertBasedAuthFactory.class.getSimpleName();
    private static final String USER_CANCEL_MESSAGE = "User canceled smartcard CBA flow.";
    private static final String NON_APPLICABLE = "N/A";
    private final Activity mActivity;
    private final AbstractUsbSmartcardCertBasedAuthManager mUsbSmartcardCertBasedAuthManager;
    private final AbstractNfcSmartcardCertBasedAuthManager mNfcSmartcardCertBasedAuthManager;
    private final IDialogHolder mDialogHolder;
    private boolean wasCertBasedAuthInitiated;

    public CertBasedAuthFactory(@NonNull Activity activity) {
        this.mActivity = activity;
        this.mUsbSmartcardCertBasedAuthManager = SmartcardCertBasedAuthManagerFactory.createUsbSmartcardCertBasedAuthManager(this.mActivity.getApplicationContext());
        this.mNfcSmartcardCertBasedAuthManager = SmartcardCertBasedAuthManagerFactory.createNfcSmartcardCertBasedAuthManager(this.mActivity.getApplicationContext());
        this.mDialogHolder = new DialogHolder(this.mActivity);
        this.wasCertBasedAuthInitiated = false;
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.startDiscovery(activity);
        }
    }

    @VisibleForTesting
    protected CertBasedAuthFactory(@NonNull Activity activity, AbstractUsbSmartcardCertBasedAuthManager usbManager, AbstractNfcSmartcardCertBasedAuthManager nfcManager, @NonNull IDialogHolder dialogHolder) {
        this.mActivity = activity;
        this.mUsbSmartcardCertBasedAuthManager = usbManager;
        this.mNfcSmartcardCertBasedAuthManager = nfcManager;
        this.mDialogHolder = dialogHolder;
        this.wasCertBasedAuthInitiated = false;
    }

    public void createCertBasedAuthChallengeHandler(final @NonNull CertBasedAuthChallengeHandlerCallback callback) {
        CertBasedAuthTelemetryHelper telemetryHelper = this.mActivity instanceof AuthorizationActivity && ((AuthorizationActivity)this.mActivity).getSpanContext() != null ? new CertBasedAuthTelemetryHelper(((AuthorizationActivity)this.mActivity).getSpanContext()) : new CertBasedAuthTelemetryHelper();
        telemetryHelper.setUserChoice(CertBasedAuthChoice.NON_APPLICABLE);
        telemetryHelper.setCertBasedAuthChallengeHandler(NON_APPLICABLE);
        telemetryHelper.setPublicKeyAlgoType(NON_APPLICABLE);
        this.wasCertBasedAuthInitiated = true;
        if (this.mUsbSmartcardCertBasedAuthManager != null && this.mUsbSmartcardCertBasedAuthManager.isDeviceConnected()) {
            telemetryHelper.setUserChoice(CertBasedAuthChoice.SMARTCARD_CHOICE);
            callback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(this.mActivity, this.mUsbSmartcardCertBasedAuthManager, this.mDialogHolder, (ICertBasedAuthTelemetryHelper)telemetryHelper));
            return;
        }
        this.mDialogHolder.showUserChoiceDialog(new UserChoiceDialog.PositiveButtonListener((ICertBasedAuthTelemetryHelper)telemetryHelper, callback){
            final /* synthetic */ ICertBasedAuthTelemetryHelper val$telemetryHelper;
            final /* synthetic */ CertBasedAuthChallengeHandlerCallback val$callback;
            {
                this.val$telemetryHelper = iCertBasedAuthTelemetryHelper;
                this.val$callback = certBasedAuthChallengeHandlerCallback;
            }

            @Override
            @RequiresApi(api=21)
            public void onClick(int checkedPosition) {
                if (checkedPosition == 0) {
                    CertBasedAuthFactory.this.mDialogHolder.dismissDialog();
                    this.val$telemetryHelper.setUserChoice(CertBasedAuthChoice.ON_DEVICE_CHOICE);
                    this.val$callback.onReceived(new OnDeviceCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, this.val$telemetryHelper));
                    return;
                }
                this.val$telemetryHelper.setUserChoice(CertBasedAuthChoice.SMARTCARD_CHOICE);
                CertBasedAuthFactory.this.setUpForSmartcardCertBasedAuth(this.val$callback, this.val$telemetryHelper);
            }
        }, new ICancelCbaCallback((ICertBasedAuthTelemetryHelper)telemetryHelper){
            final /* synthetic */ ICertBasedAuthTelemetryHelper val$telemetryHelper;
            {
                this.val$telemetryHelper = iCertBasedAuthTelemetryHelper;
            }

            @Override
            @RequiresApi(api=21)
            public void onCancel() {
                CertBasedAuthFactory.this.onCancelHelper(callback, this.val$telemetryHelper);
            }
        });
    }

    private void onCancelHelper(@NonNull CertBasedAuthChallengeHandlerCallback callback, @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        this.mDialogHolder.dismissDialog();
        telemetryHelper.setResultFailure(USER_CANCEL_MESSAGE);
        if (this.mNfcSmartcardCertBasedAuthManager != null) {
            this.mNfcSmartcardCertBasedAuthManager.clearConnectionCallback();
        }
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.clearConnectionCallback();
        }
        callback.onReceived(null);
    }

    private void setUpForSmartcardCertBasedAuth(final @NonNull CertBasedAuthChallengeHandlerCallback callback, final @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        if (this.mUsbSmartcardCertBasedAuthManager != null && this.mUsbSmartcardCertBasedAuthManager.isDeviceConnected()) {
            callback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(this.mActivity, this.mUsbSmartcardCertBasedAuthManager, this.mDialogHolder, telemetryHelper));
            return;
        }
        if (this.mNfcSmartcardCertBasedAuthManager != null && this.mNfcSmartcardCertBasedAuthManager.startDiscovery(this.mActivity)) {
            this.mDialogHolder.showSmartcardNfcReminderDialog(new IDismissCallback(){

                @Override
                public void onDismiss() {
                    if (CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager != null && CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager.isDeviceConnected()) {
                        callback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager, CertBasedAuthFactory.this.mDialogHolder, telemetryHelper));
                        return;
                    }
                    CertBasedAuthFactory.this.showSmartcardPromptDialogAndSetConnectionCallback(callback, telemetryHelper);
                }
            });
            return;
        }
        this.showSmartcardPromptDialogAndSetConnectionCallback(callback, telemetryHelper);
    }

    private void showSmartcardPromptDialogAndSetConnectionCallback(final @NonNull CertBasedAuthChallengeHandlerCallback challengeHandlerCallback, final @NonNull ICertBasedAuthTelemetryHelper telemetryHelper) {
        this.mDialogHolder.showSmartcardPromptDialog(new ICancelCbaCallback(){

            @Override
            @RequiresApi(api=21)
            public void onCancel() {
                if (CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager != null) {
                    CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager.stopDiscovery(CertBasedAuthFactory.this.mActivity);
                }
                CertBasedAuthFactory.this.onCancelHelper(challengeHandlerCallback, telemetryHelper);
            }
        });
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.setConnectionCallback(new IConnectionCallback(){

                @Override
                @RequiresApi(api=21)
                public void onCreateConnection() {
                    if (CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager != null) {
                        CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager.stopDiscovery(CertBasedAuthFactory.this.mActivity);
                        CertBasedAuthFactory.this.clearAllSmartcardConnectionAndDisconnectionCallbacks();
                    }
                    challengeHandlerCallback.onReceived(new UsbSmartcardCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager, CertBasedAuthFactory.this.mDialogHolder, telemetryHelper));
                }
            });
        }
        if (this.mNfcSmartcardCertBasedAuthManager == null) {
            return;
        }
        this.mNfcSmartcardCertBasedAuthManager.setConnectionCallback(new IConnectionCallback(){

            @Override
            @RequiresApi(api=21)
            public void onCreateConnection() {
                if (CertBasedAuthFactory.this.mUsbSmartcardCertBasedAuthManager != null) {
                    CertBasedAuthFactory.this.clearAllSmartcardConnectionAndDisconnectionCallbacks();
                }
                CertBasedAuthFactory.this.mDialogHolder.showSmartcardNfcLoadingDialog();
                challengeHandlerCallback.onReceived(new NfcSmartcardCertBasedAuthChallengeHandler(CertBasedAuthFactory.this.mActivity, CertBasedAuthFactory.this.mNfcSmartcardCertBasedAuthManager, CertBasedAuthFactory.this.mDialogHolder, telemetryHelper));
            }
        });
    }

    public void clearAllSmartcardConnectionAndDisconnectionCallbacks() {
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.clearConnectionCallback();
            this.mUsbSmartcardCertBasedAuthManager.clearDisconnectionCallback();
        }
        if (this.mNfcSmartcardCertBasedAuthManager != null) {
            this.mNfcSmartcardCertBasedAuthManager.clearConnectionCallback();
        }
    }

    public void onDestroy() {
        String methodTag = TAG + ":onDestroy";
        if (this.mUsbSmartcardCertBasedAuthManager != null) {
            this.mUsbSmartcardCertBasedAuthManager.onDestroy(this.mActivity);
        }
        if (this.mNfcSmartcardCertBasedAuthManager != null) {
            this.mNfcSmartcardCertBasedAuthManager.onDestroy(this.mActivity);
        }
        if (this.wasCertBasedAuthInitiated) {
            if (Build.VERSION.SDK_INT >= 21) {
                WebView.clearClientCertPreferences(null);
            } else {
                Logger.warn(methodTag, "Client Cert Preferences cache not cleared due to SDK version < 21 (LOLLIPOP). Subsequent CBA attempts will fail due to the cached action, so the user must restart the app before attempting to login with CBA again.");
            }
        }
    }

    public static interface CertBasedAuthChallengeHandlerCallback {
        public void onReceived(@Nullable AbstractCertBasedAuthChallengeHandler var1);
    }
}

