/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.java.crypto.AsymmetricAlgorithm;
import com.microsoft.identity.common.java.crypto.CryptoSuite;
import com.microsoft.identity.common.java.crypto.IDevicePopManager;
import com.microsoft.identity.common.java.crypto.SigningAlgorithm;
import java.security.KeyStore;

public enum AsymmetricCipher implements CryptoSuite
{
    RSA_NONE_OAEPWithSHA_1AndMGF1PaddingAndHmacSha256{

        public AsymmetricAlgorithm cipher() {
            return IDevicePopManager.Cipher.RSA_NONE_OAEPWithSHA_1AndMGF1Padding;
        }

        public String macName() {
            return "HmacSHA256";
        }

        public boolean isAsymmetric() {
            return true;
        }

        public Class<? extends KeyStore.Entry> keyClass() {
            return KeyStore.PrivateKeyEntry.class;
        }

        public int keySize() {
            return 2048;
        }

        @RequiresApi(api=18)
        public SigningAlgorithm signingAlgorithm() {
            return SigningAlgorithm.SHA_256_WITH_RSA;
        }
    }
    ,
    RSA_ECB_PKCS1_PADDING_HMACSHA256{

        public AsymmetricAlgorithm cipher() {
            return AsymmetricAlgorithm.Builder.of((String)"RSA/ECB/PKCS1Padding");
        }

        public String macName() {
            return "HmacSHA256";
        }

        public boolean isAsymmetric() {
            return true;
        }

        public Class<? extends KeyStore.Entry> keyClass() {
            return KeyStore.PrivateKeyEntry.class;
        }

        public int keySize() {
            return 2048;
        }

        @RequiresApi(api=18)
        public SigningAlgorithm signingAlgorithm() {
            return SigningAlgorithm.SHA_256_WITH_RSA;
        }
    };

}

