/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.PropertyBagUtil;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.BrokerActivity;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.ipc.AccountManagerAddAccountStrategy;
import com.microsoft.identity.common.internal.broker.ipc.BoundServiceStrategy;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.cache.ActiveBrokerCacheUpdater;
import com.microsoft.identity.common.internal.cache.ClientActiveBrokerCache;
import com.microsoft.identity.common.internal.cache.HelloCache;
import com.microsoft.identity.common.internal.cache.HelloCacheResult;
import com.microsoft.identity.common.internal.commands.parameters.AndroidActivityInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BrokerOperationExecutor;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.java.BaseAccount;
import com.microsoft.identity.common.java.authscheme.PopAuthenticationSchemeWithClientKeyInternal;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.commands.AcquirePrtSsoTokenResult;
import com.microsoft.identity.common.java.commands.parameters.AcquirePrtSsoTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RopcTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.TokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.exception.UnsupportedBrokerException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.BrokerProtocolVersionUtil;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ThreadUtils;
import com.microsoft.identity.common.java.util.ported.LocalBroadcaster;
import com.microsoft.identity.common.java.util.ported.PropertyBag;
import com.microsoft.identity.common.logging.Logger;
import com.microsoft.identity.common.sharedwithoneauth.OneAuthSharedFunctions;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    private static final long WAIT_BETWEEN_DCF_POLLING_MILLISECONDS = TimeUnit.SECONDS.toMillis(5L);
    private static final long HELLO_CACHE_ENTRY_TIMEOUT = TimeUnit.HOURS.toMillis(4L);
    protected final MsalBrokerRequestAdapter mRequestAdapter = new MsalBrokerRequestAdapter();
    protected final MsalBrokerResultAdapter mResultAdapter = new MsalBrokerResultAdapter();
    private ResultFuture<Bundle> mBrokerResultFuture;
    private final String mActiveBrokerPackageName;
    private final BrokerOperationExecutor mBrokerOperationExecutor;
    private final HelloCache mHelloCache;
    private final IPlatformComponents mComponents;
    private final Context mApplicationContext;

    public BrokerMsalController(@androidx.annotation.NonNull Context applicationContext, @androidx.annotation.NonNull IPlatformComponents components, @androidx.annotation.NonNull String activeBrokerPackageName, @androidx.annotation.NonNull List<IIpcStrategy> ipcStrategies) {
        this.mComponents = components;
        this.mApplicationContext = applicationContext;
        this.mActiveBrokerPackageName = activeBrokerPackageName;
        this.mBrokerOperationExecutor = new BrokerOperationExecutor(ipcStrategies, new ActiveBrokerCacheUpdater(applicationContext, ClientActiveBrokerCache.getClientSdkCache(components.getStorageSupplier())));
        this.mHelloCache = this.getHelloCache();
    }

    public BrokerMsalController(@androidx.annotation.NonNull Context applicationContext, @androidx.annotation.NonNull IPlatformComponents components, @androidx.annotation.NonNull String activeBrokerPackageName) {
        this(applicationContext, components, activeBrokerPackageName, OneAuthSharedFunctions.getIpcStrategies(applicationContext, activeBrokerPackageName));
    }

    @VisibleForTesting
    public HelloCache getHelloCache() {
        return new HelloCache(this.mApplicationContext, "msal.to.broker", this.mActiveBrokerPackageName, this.mComponents, HELLO_CACHE_ENTRY_TIMEOUT);
    }

    @VisibleForTesting
    @androidx.annotation.NonNull
    public String hello(@androidx.annotation.NonNull IIpcStrategy strategy, @Nullable String minRequestedVersion) throws BaseException {
        return this.hello(strategy, minRequestedVersion, "15.0");
    }

    @VisibleForTesting
    @androidx.annotation.NonNull
    public String hello(@androidx.annotation.NonNull IIpcStrategy strategy, @Nullable String minRequestedVersion, @androidx.annotation.NonNull String clientMaxProtocolVersion) throws BaseException {
        String methodTag = TAG + ":hello";
        String cachedProtocolVersion = this.tryGetNegotiatedProtocolVersionFromHelloCache(minRequestedVersion, clientMaxProtocolVersion);
        if (!StringUtil.isNullOrEmpty((String)cachedProtocolVersion)) {
            return cachedProtocolVersion;
        }
        Logger.info(methodTag, String.format("Calling broker for to establish negotiated protocol version for: MinRequestVersion=%s, ClientMaxProtocolVersion=%s, ActiveBroker=%s", minRequestedVersion, clientMaxProtocolVersion, this.mActiveBrokerPackageName));
        Bundle bundle = new Bundle();
        bundle.putString("broker.protocol.version.name", clientMaxProtocolVersion);
        if (!StringUtil.isNullOrEmpty((String)minRequestedVersion)) {
            bundle.putString("required.broker.protocol.version.name", minRequestedVersion);
        }
        BrokerOperationBundle helloBundle = new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_HELLO, this.mActiveBrokerPackageName, bundle);
        try {
            String negotiatedProtocolVersion = this.mResultAdapter.verifyHelloFromResultBundle(this.mActiveBrokerPackageName, strategy.communicateToBroker(helloBundle));
            this.mHelloCache.saveNegotiatedProtocolVersion(minRequestedVersion, clientMaxProtocolVersion, negotiatedProtocolVersion);
            return negotiatedProtocolVersion;
        }
        catch (UnsupportedBrokerException e) {
            this.mHelloCache.saveHandshakeError(minRequestedVersion, clientMaxProtocolVersion);
            throw e;
        }
    }

    @edu.umd.cs.findbugs.annotations.Nullable
    private String tryGetNegotiatedProtocolVersionFromHelloCache(@Nullable String minRequestedVersion, @androidx.annotation.NonNull String clientMaxProtocolVersion) throws UnsupportedBrokerException {
        String methodTag = TAG + ":tryGetNegotiatedProtocolVersionFromHelloCache";
        HelloCacheResult helloCacheResult = this.mHelloCache.getHelloCacheResult(minRequestedVersion, clientMaxProtocolVersion);
        if (helloCacheResult == null) {
            Logger.info(methodTag, "No valid entry found in cache");
            return null;
        }
        if (helloCacheResult.isHandShakeError()) {
            Logger.info(methodTag, "Handshake error from cache.");
            throw new UnsupportedBrokerException(this.mActiveBrokerPackageName);
        }
        String cachedProtocolVersion = helloCacheResult.getNegotiatedProtocolVersion();
        if (!StringUtil.isNullOrEmpty((String)cachedProtocolVersion)) {
            return cachedProtocolVersion;
        }
        Logger.warn(methodTag, "Unexpected: cachedProtocolVersion is empty. Continue with hello IPC protocol.");
        return null;
    }

    public AcquireTokenResult acquireToken(@androidx.annotation.NonNull InteractiveTokenCommandParameters parameters) throws BaseException, InterruptedException, ExecutionException {
        AcquireTokenResult result;
        final String methodTag = TAG + ":acquireToken";
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((CommandParameters)parameters).putApiId("201"));
        this.mBrokerResultFuture = new ResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        Activity activity = null;
        if (parameters instanceof AndroidActivityInteractiveTokenCommandParameters) {
            activity = ((AndroidActivityInteractiveTokenCommandParameters)parameters).getActivity();
        }
        Intent brokerActivityIntent = new Intent(this.mApplicationContext, BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        LocalBroadcaster.INSTANCE.registerCallback("return_broker_interactive_acquire_token_result", new LocalBroadcaster.IReceiverCallback(){

            public void onReceive(@androidx.annotation.NonNull PropertyBag propertyBag) {
                Logger.verbose(methodTag, "Received result from Broker...");
                Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("202").put("Microsoft.MSAL.request_code", ((Integer)propertyBag.getOrDefault("com.microsoft.identity.client.request.code", (Serializable)Integer.valueOf(-1))).toString()).put("Microsoft.MSAL.result_code", ((Integer)propertyBag.getOrDefault("com.microsoft.identity.client.result.code", (Serializable)Integer.valueOf(-1))).toString()));
                BrokerMsalController.this.mBrokerResultFuture.setResult((Object)PropertyBagUtil.toBundle(propertyBag));
                Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("202"));
                LocalBroadcaster.INSTANCE.unregisterCallback("return_broker_interactive_acquire_token_result");
            }
        });
        if (null == activity) {
            brokerActivityIntent.addFlags(0x10000000);
            this.mApplicationContext.startActivity(brokerActivityIntent);
        } else {
            activity.startActivity(brokerActivityIntent);
        }
        try {
            Bundle resultBundle = (Bundle)this.mBrokerResultFuture.get();
            String negotiatedBrokerProtocolVersion = interactiveRequestIntent.getStringExtra("common.broker.protocol.version.name");
            if (parameters.getOAuth2TokenCache() != null && !BrokerProtocolVersionUtil.canSupportMsaAccountsInBroker((String)negotiatedBrokerProtocolVersion)) {
                this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getOAuth2TokenCache());
            }
            this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
            result = this.mResultAdapter.getAcquireTokenResultFromResultBundle(resultBundle);
        }
        catch (BaseException | ExecutionException e) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)e).putApiId("201"));
            throw e;
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(result).putApiId("201"));
        return result;
    }

    public void onFinishAuthorizationSession(int requestCode, int resultCode, @androidx.annotation.NonNull PropertyBag data) {
        throw new UnsupportedOperationException();
    }

    @androidx.annotation.NonNull
    private Intent getBrokerAuthorizationIntent(final @androidx.annotation.NonNull InteractiveTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Intent>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                BrokerMsalController.this.verifyTokenParametersAreSupported((TokenCommandParameters)parameters);
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_INTENT_FOR_INTERACTIVE_REQUEST, BrokerMsalController.this.mActiveBrokerPackageName, null);
            }

            @Override
            @androidx.annotation.NonNull
            public Intent extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                Intent intent = BrokerMsalController.this.mResultAdapter.getIntentForInteractiveRequestFromResultBundle(resultBundle, this.negotiatedBrokerProtocolVersion);
                intent.putExtras(BrokerMsalController.this.mRequestAdapter.getRequestBundleForAcquireTokenInteractive(parameters, this.negotiatedBrokerProtocolVersion));
                return intent;
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull Intent result) {
            }
        });
    }

    public AuthorizationResult deviceCodeFlowAuthRequest(final DeviceCodeFlowCommandParameters parameters) throws BaseException, ClientException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<AuthorizationResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_FETCH_DCF_AUTH_RESULT, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForDeviceCodeFlowAuthRequest(BrokerMsalController.this.mApplicationContext, parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            public AuthorizationResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                return BrokerMsalController.this.mResultAdapter.getDeviceCodeFlowAuthResultFromResultBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":deviceCodeFlowAuthRequest";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull AuthorizationResult result) {
            }
        });
    }

    public AcquireTokenResult acquireDeviceCodeFlowToken(final AuthorizationResult authorizationResult, final DeviceCodeFlowCommandParameters parameters) throws BaseException, ClientException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<AcquireTokenResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_ACQUIRE_TOKEN_DCF, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForDeviceCodeFlowTokenRequest(BrokerMsalController.this.mApplicationContext, parameters, authorizationResult, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            public AcquireTokenResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                AcquireTokenResult acquireTokenResult = BrokerMsalController.this.mResultAdapter.getDeviceCodeFlowTokenResultFromResultBundle(resultBundle);
                if (acquireTokenResult == null) {
                    ThreadUtils.sleepSafely((int)((int)WAIT_BETWEEN_DCF_POLLING_MILLISECONDS), (String)TAG, (String)"Attempting to sleep thread during Device Code Flow token polling...");
                    return BrokerMsalController.this.acquireDeviceCodeFlowToken(authorizationResult, parameters);
                }
                return acquireTokenResult;
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":deviceCodeFlowAuthRequest";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull AcquireTokenResult result) {
                event.putResult(result);
            }
        });
    }

    @androidx.annotation.NonNull
    public AcquireTokenResult acquireTokenSilent(final @androidx.annotation.NonNull SilentTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<AcquireTokenResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                BrokerMsalController.this.verifyTokenParametersAreSupported((TokenCommandParameters)parameters);
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_ACQUIRE_TOKEN_SILENT, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForAcquireTokenSilent(BrokerMsalController.this.mApplicationContext, parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @androidx.annotation.NonNull
            public AcquireTokenResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                return BrokerMsalController.this.mResultAdapter.getAcquireTokenResultFromResultBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":acquireTokenSilent";
            }

            @Override
            @androidx.annotation.NonNull
            public String getTelemetryApiId() {
                return "203";
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull AcquireTokenResult result) {
                event.putResult(result);
            }
        });
    }

    @androidx.annotation.NonNull
    public List<ICacheRecord> getAccounts(final @androidx.annotation.NonNull CommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<List<ICacheRecord>>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_ACCOUNTS, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @androidx.annotation.NonNull
            public List<ICacheRecord> extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                return BrokerMsalController.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":getAccounts";
            }

            @Override
            @androidx.annotation.NonNull
            public String getTelemetryApiId() {
                return "206";
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    public boolean removeAccount(final @androidx.annotation.NonNull RemoveAccountCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_REMOVE_ACCOUNT, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForRemoveAccount(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @androidx.annotation.NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                BrokerMsalController.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                return true;
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":removeAccount";
            }

            @Override
            @androidx.annotation.NonNull
            public String getTelemetryApiId() {
                return "207";
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull Boolean result) {
            }
        });
    }

    public boolean isQrPinAvailable() throws BaseException {
        final String methodTag = TAG + ":isQrPinAvailable";
        return this.mBrokerOperationExecutor.execute(null, new BrokerOperationExecutor.BrokerOperation<Boolean>(){

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BrokerCommunicationException {
                if (strategy instanceof BoundServiceStrategy || strategy instanceof AccountManagerAddAccountStrategy) {
                    String errorMessage = strategy + " is not supported for isQrPinAvailable operation";
                    Logger.warn(methodTag, errorMessage);
                    throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE, strategy.getType(), errorMessage, null);
                }
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_IS_QR_PIN_AVAILABLE, BrokerMsalController.this.mActiveBrokerPackageName, null);
            }

            @Override
            @androidx.annotation.NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                return BrokerMsalController.this.mResultAdapter.getIfQrPinIsAvailableFromResultBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":isQrPinAvailable";
            }

            @Override
            @androidx.annotation.NonNull
            public String getTelemetryApiId() {
                return "209";
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull Boolean result) {
            }
        });
    }

    public boolean getDeviceMode(@androidx.annotation.NonNull CommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) {
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_DEVICE_MODE, BrokerMsalController.this.mActiveBrokerPackageName, null);
            }

            @Override
            @androidx.annotation.NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                return BrokerMsalController.this.mResultAdapter.getDeviceModeFromResultBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":getDeviceMode";
            }

            @Override
            @androidx.annotation.NonNull
            public String getTelemetryApiId() {
                return "204";
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull Boolean result) {
                event.put("Microsoft.MSAL.is_device_shared", Boolean.toString(result));
            }
        });
    }

    @androidx.annotation.NonNull
    public List<ICacheRecord> getCurrentAccount(final @androidx.annotation.NonNull CommandParameters parameters) throws BaseException {
        String methodName = ":getCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(TAG + ":getCurrentAccount", "Not a shared device, invoke getAccounts() instead of getCurrentAccount()");
            return this.getAccounts(parameters);
        }
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<List<ICacheRecord>>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GET_CURRENT_ACCOUNT_IN_SHARED_DEVICE, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @androidx.annotation.NonNull
            public List<ICacheRecord> extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (resultBundle == null) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                return BrokerMsalController.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":getCurrentAccount";
            }

            @Override
            @androidx.annotation.NonNull
            public String getTelemetryApiId() {
                return "205";
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    public boolean removeCurrentAccount(final @androidx.annotation.NonNull RemoveAccountCommandParameters parameters) throws BaseException {
        String methodName = ":removeCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose(":removeCurrentAccount", "Not a shared device, invoke removeAccount() instead of removeCurrentAccount()");
            return this.removeAccount(parameters);
        }
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<Boolean>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_SIGN_OUT_FROM_SHARED_DEVICE, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForRemoveAccountFromSharedDevice(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @androidx.annotation.NonNull
            public Boolean extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                BrokerMsalController.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                return true;
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":removeCurrentAccount";
            }

            @Override
            @androidx.annotation.NonNull
            public String getTelemetryApiId() {
                return "208";
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull Boolean result) {
            }
        });
    }

    public AcquireTokenResult acquireTokenWithPassword(@NonNull RopcTokenCommandParameters parameters) throws Exception {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        throw new ClientException("acquireTokenWithPassword() not supported in BrokerMsalController");
    }

    public GenerateShrResult generateSignedHttpRequest(final @androidx.annotation.NonNull GenerateShrCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<GenerateShrResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() throws ClientException {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_GENERATE_SHR, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForGenerateShr(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @androidx.annotation.NonNull
            public GenerateShrResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (null == resultBundle) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                return BrokerMsalController.this.mResultAdapter.getGenerateShrResultFromResultBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":generateSignedHttpRequest";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull GenerateShrResult result) {
            }
        });
    }

    public AcquirePrtSsoTokenResult getSsoToken(final @androidx.annotation.NonNull AcquirePrtSsoTokenCommandParameters parameters) throws BaseException {
        return this.mBrokerOperationExecutor.execute(parameters, new BrokerOperationExecutor.BrokerOperation<AcquirePrtSsoTokenResult>(){
            private String negotiatedBrokerProtocolVersion;

            @Override
            public void performPrerequisites(@androidx.annotation.NonNull IIpcStrategy strategy) throws BaseException {
                this.negotiatedBrokerProtocolVersion = BrokerMsalController.this.hello(strategy, parameters.getRequiredBrokerProtocolVersion());
            }

            @Override
            @androidx.annotation.NonNull
            public BrokerOperationBundle getBundle() throws ClientException {
                return new BrokerOperationBundle(BrokerOperationBundle.Operation.MSAL_SSO_TOKEN, BrokerMsalController.this.mActiveBrokerPackageName, BrokerMsalController.this.mRequestAdapter.getRequestBundleForSsoToken(parameters, this.negotiatedBrokerProtocolVersion));
            }

            @Override
            @androidx.annotation.NonNull
            public AcquirePrtSsoTokenResult extractResultBundle(@Nullable Bundle resultBundle) throws BaseException {
                if (null == resultBundle) {
                    throw BrokerMsalController.this.mResultAdapter.getExceptionForEmptyResultBundle();
                }
                BrokerMsalController.this.verifyBrokerVersionIsSupported(resultBundle, parameters.getRequiredBrokerProtocolVersion());
                return BrokerMsalController.this.mResultAdapter.getAcquirePrtSsoTokenResultFromBundle(resultBundle);
            }

            @Override
            @androidx.annotation.NonNull
            public String getMethodName() {
                return ":getSsoToken";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(@androidx.annotation.NonNull ApiEndEvent event, @androidx.annotation.NonNull AcquirePrtSsoTokenResult result) {
            }
        });
    }

    private void saveMsaAccountToCache(@androidx.annotation.NonNull Bundle resultBundle, @androidx.annotation.NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws BaseException {
        String methodTag = TAG + ":saveMsaAccountToCache";
        BrokerResult brokerResult = new MsalBrokerResultAdapter().brokerResultFromBundle(resultBundle);
        if (resultBundle.getBoolean("broker_request_v2_success") && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info(methodTag, "Result returned for MSA Account, saving to cache");
            if (StringUtil.isNullOrEmpty((String)brokerResult.getClientInfo())) {
                Logger.error(methodTag, "ClientInfo is empty.", null);
                throw new ClientException("unknown_error", "ClientInfo is empty.");
            }
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                this.msalOAuth2TokenCacheSetSingleSignOnState(msalOAuth2TokenCache, microsoftStsAccount, microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII(methodTag, "Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", e);
                throw new ClientException("invalid_jwt", e.getMessage(), (Throwable)e);
            }
        }
    }

    private void msalOAuth2TokenCacheSetSingleSignOnState(@androidx.annotation.NonNull MsalOAuth2TokenCache msalOAuth2TokenCache, MicrosoftStsAccount microsoftStsAccount, MicrosoftRefreshToken microsoftRefreshToken) throws ClientException {
        msalOAuth2TokenCache.setSingleSignOnState((BaseAccount)microsoftStsAccount, (RefreshToken)microsoftRefreshToken);
    }

    private void verifyTokenParametersAreSupported(@androidx.annotation.NonNull TokenCommandParameters parameters) throws ClientException {
        String requiredProtocolVersion = parameters.getRequiredBrokerProtocolVersion();
        if (parameters.getAuthenticationScheme() instanceof PopAuthenticationSchemeWithClientKeyInternal && !BrokerProtocolVersionUtil.canSupportPopAuthenticationSchemeWithClientKey((String)requiredProtocolVersion)) {
            throw new ClientException("auth_scheme_not_supported", "The min broker protocol version for PopAuthenticationSchemeWithClientKey should be equal or more than 11.0. Current required version is set to: " + requiredProtocolVersion);
        }
        this.validateNestedAppAuthParameters(parameters, requiredProtocolVersion);
    }

    private void validateNestedAppAuthParameters(@androidx.annotation.NonNull TokenCommandParameters parameters, @androidx.annotation.NonNull String requiredProtocolVersion) throws ClientException {
        if (parameters.hasNestedAppParameters()) {
            if (!(StringUtil.isNullOrEmpty((String)parameters.getChildClientId()) || StringUtil.isNullOrEmpty((String)parameters.getChildRedirectUri()) || BrokerProtocolVersionUtil.canSupportNestedAppAuthentication((String)requiredProtocolVersion))) {
                throw new ClientException("nested_app_auth_not_supported", "The min broker protocol version for Nested app auth should be equal or more than 15.0. Current required version is set to: " + requiredProtocolVersion);
            }
            if (StringUtil.isNullOrEmpty((String)parameters.getChildClientId())) {
                throw new ClientException("nested_app_invalid_parameters", "ClientId of the nested app is null or empty");
            }
            if (StringUtil.isNullOrEmpty((String)parameters.getChildRedirectUri())) {
                throw new ClientException("nested_app_invalid_parameters", "RedirectURI of the nested app is null or empty");
            }
            if (parameters.getSdkType() != SdkType.MSAL_CPP) {
                throw new ClientException("nested_app_invalid_parameters", "Nested app auth is only supported for request originating from OneAuth");
            }
        }
    }

    private void verifyBrokerVersionIsSupported(@Nullable Bundle resultBundle, @Nullable String requiredBrokerProtocolVersion) throws UnsupportedBrokerException {
        String methodTag = TAG + ":verifyBrokerVersionIsSupported";
        if (resultBundle == null) {
            Logger.info(methodTag, "result bundle is null");
            return;
        }
        try {
            BrokerResult brokerResult = this.mResultAdapter.brokerResultFromBundle(resultBundle);
            if (!brokerResult.isSuccess() && "unsupported_broker_version".equals(brokerResult.getErrorCode())) {
                this.mHelloCache.saveHandshakeError(requiredBrokerProtocolVersion, "15.0");
                throw new UnsupportedBrokerException(this.mActiveBrokerPackageName);
            }
        }
        catch (ClientException e) {
            Logger.info(methodTag, "ResultBundle does not contain BrokerResult. So, this is not likely a broker version supported issue. Continuing.");
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BrokerMsalController)) {
            return false;
        }
        BrokerMsalController other = (BrokerMsalController)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof BrokerMsalController;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

