/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.os.Bundle;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/IpcStrategyWithBackup;", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;", "primary", "backup", "", "(Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;Ljava/util/List;)V", "communicateToBroker", "Landroid/os/Bundle;", "bundle", "Lcom/microsoft/identity/common/internal/broker/ipc/BrokerOperationBundle;", "getType", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy$Type;", "Companion", "common_distRelease"})
public final class IpcStrategyWithBackup
implements IIpcStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IIpcStrategy primary;
    @NotNull
    private final List<IIpcStrategy> backup;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(IpcStrategyWithBackup.class).getSimpleName();

    public IpcStrategyWithBackup(@NotNull IIpcStrategy primary, @NotNull List<? extends IIpcStrategy> backup) {
        Intrinsics.checkNotNullParameter((Object)primary, (String)"primary");
        Intrinsics.checkNotNullParameter(backup, (String)"backup");
        this.primary = primary;
        this.backup = backup;
    }

    @Override
    @Nullable
    public Bundle communicateToBroker(@NotNull BrokerOperationBundle bundle) {
        Bundle bundle2;
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        String methodTag = TAG + ":communicateToBroker";
        try {
            bundle2 = this.primary.communicateToBroker(bundle);
        }
        catch (Throwable t) {
            for (IIpcStrategy ipc : this.backup) {
                try {
                    Bundle result = ipc.communicateToBroker(bundle);
                    SpanExtension.current().setAttribute(AttributeName.backup_ipc_used.name(), ipc.getType().name);
                    Logger.info((String)methodTag, (String)(ipc.getType().name + " backup ipc succeeded."));
                    return result;
                }
                catch (Throwable t2) {
                    Logger.info((String)methodTag, (String)(ipc.getType().name + " backup ipc failed : " + t2.getMessage()));
                }
            }
            throw t;
        }
        return bundle2;
    }

    @Override
    @NotNull
    public IIpcStrategy.Type getType() {
        IIpcStrategy.Type type = this.primary.getType();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"primary.type");
        return type;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/IpcStrategyWithBackup$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

