/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.fido;

import com.microsoft.identity.common.internal.fido.AuthFidoChallenge;
import com.microsoft.identity.common.internal.fido.IFidoChallenge;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.UrlUtil;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/microsoft/identity/common/internal/fido/FidoChallengeFactory;", "", "()V", "Companion", "common_distRelease"})
public final class FidoChallengeFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DELIMITER = ",";
    @NotNull
    public static final String DEFAULT_USER_VERIFICATION_POLICY = "required";
    @NotNull
    private static final String PASSKEY_PROTOCOL_REQUEST_INVALID = "Passkey protocol request is invalid";

    @JvmStatic
    @NotNull
    public static final IFidoChallenge createFidoChallengeFromRedirect(@NotNull String redirectUri) throws ClientException {
        return Companion.createFidoChallengeFromRedirect(redirectUri);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J'\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u000eJ!\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u0010J'\u0010\u0011\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013J\u001f\u0010\u0014\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/microsoft/identity/common/internal/fido/FidoChallengeFactory$Companion;", "", "()V", "DEFAULT_USER_VERIFICATION_POLICY", "", "DELIMITER", "PASSKEY_PROTOCOL_REQUEST_INVALID", "createFidoChallengeFromRedirect", "Lcom/microsoft/identity/common/internal/fido/IFidoChallenge;", "redirectUri", "validateOptionalListParameter", "", "field", "value", "validateOptionalListParameter$common_distRelease", "validateOptionalParameter", "validateOptionalParameter$common_distRelease", "validateParameterOrReturnDefault", "defaultValue", "validateParameterOrReturnDefault$common_distRelease", "validateRequiredParameter", "validateRequiredParameter$common_distRelease", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IFidoChallenge createFidoChallengeFromRedirect(@NotNull String redirectUri) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)redirectUri, (String)"redirectUri");
            Map map = UrlUtil.getParameters((String)redirectUri);
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getParameters(redirectUri)");
            Map parameters = map;
            String string = this.validateRequiredParameter$common_distRelease("Challenge", (String)parameters.get("Challenge"));
            String string2 = this.validateRequiredParameter$common_distRelease("RelyingPartyIdentifier", (String)parameters.get("RelyingPartyIdentifier"));
            String string3 = this.validateParameterOrReturnDefault$common_distRelease("UserVerificationPolicy", (String)parameters.get("UserVerificationPolicy"), FidoChallengeFactory.DEFAULT_USER_VERIFICATION_POLICY);
            String string4 = this.validateRequiredParameter$common_distRelease("Version", (String)parameters.get("Version"));
            String string5 = this.validateRequiredParameter$common_distRelease("SubmitUrl", (String)parameters.get("SubmitUrl"));
            List<String> list = this.validateOptionalListParameter$common_distRelease("KeyTypes", (String)parameters.get("KeyTypes"));
            String string6 = this.validateRequiredParameter$common_distRelease("Context", (String)parameters.get("Context"));
            List<String> list2 = this.validateOptionalListParameter$common_distRelease("AllowedCredentials", (String)parameters.get("AllowedCredentials"));
            return new AuthFidoChallenge(string, string2, string3, string4, string5, string6, list, list2);
        }

        @NotNull
        public final String validateRequiredParameter$common_distRelease(@NotNull String field, @Nullable String value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (value == null) {
                throw new ClientException(FidoChallengeFactory.PASSKEY_PROTOCOL_REQUEST_INVALID, field + " not provided");
            }
            if (StringsKt.isBlank((CharSequence)value)) {
                throw new ClientException(FidoChallengeFactory.PASSKEY_PROTOCOL_REQUEST_INVALID, field + " is empty");
            }
            return value;
        }

        @Nullable
        public final String validateOptionalParameter$common_distRelease(@NotNull String field, @Nullable String value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            if (value != null && StringsKt.isBlank((CharSequence)value)) {
                throw new ClientException(FidoChallengeFactory.PASSKEY_PROTOCOL_REQUEST_INVALID, field + " is empty");
            }
            return value;
        }

        @Nullable
        public final List<String> validateOptionalListParameter$common_distRelease(@NotNull String field, @Nullable String value) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            String param = this.validateOptionalParameter$common_distRelease(field, value);
            if (param != null) {
                String[] stringArray = new String[]{FidoChallengeFactory.DELIMITER};
                return CollectionsKt.toList((Iterable)StringsKt.split$default((CharSequence)param, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            }
            return (List)((Object)param);
        }

        @NotNull
        public final String validateParameterOrReturnDefault$common_distRelease(@NotNull String field, @Nullable String value, @NotNull String defaultValue) throws ClientException {
            Intrinsics.checkNotNullParameter((Object)field, (String)"field");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            if (value == null) {
                return defaultValue;
            }
            if (StringsKt.isBlank((CharSequence)value)) {
                throw new ClientException(FidoChallengeFactory.PASSKEY_PROTOCOL_REQUEST_INVALID, field + " is empty");
            }
            return value;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

