/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.commands;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import java.util.List;

public class GenerateShrCommand
extends BaseCommand<GenerateShrResult> {
    private static final String TAG = GenerateShrCommand.class.getSimpleName();

    public GenerateShrCommand(@NonNull GenerateShrCommandParameters parameters, @NonNull List<BaseController> controllers, @NonNull CommandCallback<GenerateShrResult, BaseException> callback, @NonNull String publicApiId) {
        super((CommandParameters)parameters, controllers, callback, publicApiId);
    }

    public GenerateShrResult execute() throws Exception {
        String methodTag = TAG + ":execute";
        GenerateShrResult result = null;
        GenerateShrCommandParameters parameters = (GenerateShrCommandParameters)this.getParameters();
        for (int ii = 0; ii < this.getControllers().size(); ++ii) {
            BaseController controller = (BaseController)this.getControllers().get(ii);
            Logger.verbose(methodTag, "Executing with controller: " + controller.getClass().getSimpleName());
            result = controller.generateSignedHttpRequest(parameters);
            if (null == result.getErrorCode()) continue;
            String errorCode = result.getErrorCode();
            String errorMessage = result.getErrorMessage();
            if ("no_account_found".equalsIgnoreCase(errorCode)) {
                if (this.getControllers().size() > ii + 1) continue;
                throw new UiRequiredException(errorCode, errorMessage);
            }
            throw new ClientException(errorCode, errorMessage);
        }
        return result;
    }

    public boolean isEligibleForEstsTelemetry() {
        return false;
    }

    protected GenerateShrCommand(GenerateShrCommandBuilder<?, ?> b) {
        super(b);
    }

    public static GenerateShrCommandBuilder<?, ?> builder() {
        return new GenerateShrCommandBuilderImpl();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerateShrCommand)) {
            return false;
        }
        GenerateShrCommand other = (GenerateShrCommand)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenerateShrCommand;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    private static final class GenerateShrCommandBuilderImpl
    extends GenerateShrCommandBuilder<GenerateShrCommand, GenerateShrCommandBuilderImpl> {
        private GenerateShrCommandBuilderImpl() {
        }

        @Override
        protected GenerateShrCommandBuilderImpl self() {
            return this;
        }

        @Override
        public GenerateShrCommand build() {
            return new GenerateShrCommand(this);
        }
    }

    public static abstract class GenerateShrCommandBuilder<C extends GenerateShrCommand, B extends GenerateShrCommandBuilder<C, B>>
    extends BaseCommand.BaseCommandBuilder<GenerateShrResult, C, B> {
        protected abstract B self();

        public abstract C build();

        public String toString() {
            return "GenerateShrCommand.GenerateShrCommandBuilder(super=" + super.toString() + ")";
        }
    }
}

