/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.os.Bundle;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH$J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/AbstractIpcStrategyWithServiceValidation;", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;", "shouldBypassSupportValidation", "", "(Z)V", "communicateToBroker", "Landroid/os/Bundle;", "bundle", "Lcom/microsoft/identity/common/internal/broker/ipc/BrokerOperationBundle;", "communicateToBrokerAfterValidation", "isSupportedByTargetedBroker", "targetedBrokerPackageName", "", "Companion", "common_distRelease"})
public abstract class AbstractIpcStrategyWithServiceValidation
implements IIpcStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean shouldBypassSupportValidation;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(AbstractIpcStrategyWithServiceValidation.class).getSimpleName();

    public AbstractIpcStrategyWithServiceValidation(boolean shouldBypassSupportValidation) {
        this.shouldBypassSupportValidation = shouldBypassSupportValidation;
    }

    public /* synthetic */ AbstractIpcStrategyWithServiceValidation(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @Nullable
    protected abstract Bundle communicateToBrokerAfterValidation(@NotNull BrokerOperationBundle var1) throws BrokerCommunicationException;

    public abstract boolean isSupportedByTargetedBroker(@NotNull String var1);

    @Override
    @Nullable
    public Bundle communicateToBroker(@NotNull BrokerOperationBundle bundle) {
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        String methodTag = TAG + ":communicateToBroker";
        if (!this.shouldBypassSupportValidation) {
            String string = bundle.targetBrokerAppPackageName;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"bundle.targetBrokerAppPackageName");
            if (!this.isSupportedByTargetedBroker(string)) {
                String message = "Operation " + (Object)((Object)this.getType()) + " is not supported on " + bundle.targetBrokerAppPackageName;
                Logger.info(methodTag, message);
                IIpcStrategy.Type type = this.getType();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)type), (String)"type");
                throw new BrokerCommunicationException(BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE, type, message, null);
            }
        }
        return this.communicateToBrokerAfterValidation(bundle);
    }

    public AbstractIpcStrategyWithServiceValidation() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/identity/common/internal/broker/ipc/AbstractIpcStrategyWithServiceValidation$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

