/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.activebrokerdiscovery;

import android.content.Context;
import android.os.Bundle;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.activebrokerdiscovery.AccountManagerBrokerDiscoveryUtil;
import com.microsoft.identity.common.internal.activebrokerdiscovery.BrokerDiscoveryClient;
import com.microsoft.identity.common.internal.activebrokerdiscovery.IBrokerDiscoveryClient;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.ContentProviderStrategy;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.cache.IClientActiveBrokerCache;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B[\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u001b\u0010\u0015\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0010H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient;", "Lcom/microsoft/identity/common/internal/activebrokerdiscovery/IBrokerDiscoveryClient;", "context", "Landroid/content/Context;", "cache", "Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;", "(Landroid/content/Context;Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;)V", "brokerCandidates", "", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "getActiveBrokerFromAccountManager", "Lkotlin/Function0;", "ipcStrategy", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;", "isPackageInstalled", "Lkotlin/Function1;", "", "isValidBroker", "(Ljava/util/Set;Lkotlin/jvm/functions/Function0;Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;Lcom/microsoft/identity/common/internal/cache/IClientActiveBrokerCache;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getActiveBroker", "shouldSkipCache", "getActiveBrokerAsync", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "common_distRelease"})
public final class BrokerDiscoveryClient
implements IBrokerDiscoveryClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<BrokerData> brokerCandidates;
    @NotNull
    private final Function0<BrokerData> getActiveBrokerFromAccountManager;
    @NotNull
    private final IIpcStrategy ipcStrategy;
    @NotNull
    private final IClientActiveBrokerCache cache;
    @NotNull
    private final Function1<BrokerData, Boolean> isPackageInstalled;
    @NotNull
    private final Function1<BrokerData, Boolean> isValidBroker;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(BrokerDiscoveryClient.class).getSimpleName();
    @NotNull
    private static final CoroutineDispatcher dispatcher = Dispatchers.getIO().limitedParallelism(10);
    @NotNull
    public static final String ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY = "ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY";
    @NotNull
    public static final String ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY = "ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY";
    @NotNull
    public static final String ERROR_BUNDLE_KEY = "ERROR_BUNDLE_KEY";
    @NotNull
    private static final Mutex classLevelLock = MutexKt.Mutex$default((boolean)false, (int)1, null);

    public BrokerDiscoveryClient(@NotNull Set<BrokerData> brokerCandidates, @NotNull Function0<BrokerData> getActiveBrokerFromAccountManager, @NotNull IIpcStrategy ipcStrategy, @NotNull IClientActiveBrokerCache cache, @NotNull Function1<? super BrokerData, Boolean> isPackageInstalled, @NotNull Function1<? super BrokerData, Boolean> isValidBroker) {
        Intrinsics.checkNotNullParameter(brokerCandidates, (String)"brokerCandidates");
        Intrinsics.checkNotNullParameter(getActiveBrokerFromAccountManager, (String)"getActiveBrokerFromAccountManager");
        Intrinsics.checkNotNullParameter((Object)ipcStrategy, (String)"ipcStrategy");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        Intrinsics.checkNotNullParameter(isPackageInstalled, (String)"isPackageInstalled");
        Intrinsics.checkNotNullParameter(isValidBroker, (String)"isValidBroker");
        this.brokerCandidates = brokerCandidates;
        this.getActiveBrokerFromAccountManager = getActiveBrokerFromAccountManager;
        this.ipcStrategy = ipcStrategy;
        this.cache = cache;
        this.isPackageInstalled = isPackageInstalled;
        this.isValidBroker = isValidBroker;
    }

    public BrokerDiscoveryClient(final @NotNull Context context, @NotNull IClientActiveBrokerCache cache) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        this(BrokerData.Companion.getKnownBrokerApps(), (Function0<BrokerData>)((Function0)new Function0<BrokerData>(){

            @Nullable
            public final BrokerData invoke() {
                return new AccountManagerBrokerDiscoveryUtil(context).getActiveBrokerFromAccountManager();
            }
        }), new ContentProviderStrategy(context), cache, (Function1<? super BrokerData, Boolean>)((Function1)new Function1<BrokerData, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull BrokerData brokerData2) {
                Intrinsics.checkNotNullParameter((Object)brokerData2, (String)"brokerData");
                return new PackageHelper(context).isPackageInstalledAndEnabled(brokerData2.getPackageName());
            }
        }), (Function1<? super BrokerData, Boolean>)((Function1)new Function1<BrokerData, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull BrokerData brokerData2) {
                Intrinsics.checkNotNullParameter((Object)brokerData2, (String)"brokerData");
                return new BrokerValidator(context).isSignedByKnownKeys(brokerData2);
            }
        }));
    }

    @Override
    @Nullable
    public BrokerData getActiveBroker(boolean shouldSkipCache) {
        return (BrokerData)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>(this, shouldSkipCache, null){
            int label;
            final /* synthetic */ BrokerDiscoveryClient this$0;
            final /* synthetic */ boolean $shouldSkipCache;
            {
                this.this$0 = $receiver;
                this.$shouldSkipCache = $shouldSkipCache;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = BrokerDiscoveryClient.access$getActiveBrokerAsync(this.this$0, this.$shouldSkipCache, (Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object getActiveBrokerAsync(boolean var1_1, Continuation<? super BrokerData> var2_2) {
        if (!(var2_2 instanceof getActiveBrokerAsync.1)) ** GOTO lbl-1000
        var18_3 = var2_2;
        if ((var18_3.label & -2147483648) != 0) {
            var18_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ BrokerDiscoveryClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BrokerDiscoveryClient.access$getActiveBrokerAsync(this.this$0, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var19_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                methodTag = BrokerDiscoveryClient.TAG + ":getActiveBrokerAsync";
                $this$withLock_u24default$iv = BrokerDiscoveryClient.classLevelLock;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = methodTag;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.Z$0 = shouldSkipCache;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var19_5) {
                    return var19_5;
                }
                ** GOTO lbl36
            }
            case 1: {
                $i$f$withLock = false;
                shouldSkipCache = $continuation.Z$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                methodTag = (String)$continuation.L$1;
                this = (BrokerDiscoveryClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl36:
                // 3 sources

                $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBrokerAsync$2 = false;
                if (shouldSkipCache) ** GOTO lbl62
                if (!this.cache.shouldUseAccountManager()) ** GOTO lbl44
                var16_14 = this.getActiveBrokerFromAccountManager.invoke();
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var16_14;
lbl44:
                // 2 sources

                v1 = this.cache.getCachedActiveBroker();
                if (v1 == null) ** GOTO lbl62
                it = v1;
                $i$a$-let-BrokerDiscoveryClient$getActiveBrokerAsync$2$1 = false;
                if (((Boolean)this.isPackageInstalled.invoke((Object)it)).booleanValue()) ** GOTO lbl52
                Logger.info((String)methodTag, (String)("There is a cached broker: " + it + ", but the app is no longer installed."));
                this.cache.clearCachedActiveBroker();
                ** GOTO lbl61
lbl52:
                // 1 sources

                if (((Boolean)this.isValidBroker.invoke((Object)it)).booleanValue()) ** GOTO lbl56
                Logger.info((String)methodTag, (String)"Clearing cache as the installed app does not have a matching signature hash.");
                this.cache.clearCachedActiveBroker();
                ** GOTO lbl61
lbl56:
                // 1 sources

                Logger.info((String)methodTag, (String)("Returning cached broker: " + it));
                var15_17 = it;
                $this$withLock_u24default$iv.unlock(owner$iv);
                return var15_17;
lbl61:
                // 3 sources

lbl62:
                // 3 sources

                $continuation.L$0 = this;
                $continuation.L$1 = methodTag;
                $continuation.L$2 = $this$withLock_u24default$iv;
                $continuation.label = 2;
                v2 = BrokerDiscoveryClient.Companion.queryFromBroker$common_distRelease(this.brokerCandidates, this.ipcStrategy, this.isPackageInstalled, this.isValidBroker, (Function0<Unit>)((Function0)new Function0<Unit>(methodTag, this){
                    final /* synthetic */ String $methodTag;
                    final /* synthetic */ BrokerDiscoveryClient this$0;
                    {
                        this.$methodTag = $methodTag;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        Logger.info((String)this.$methodTag, (String)"Will skip broker discovery via IPC and fall back to AccountManager for the next 60 minutes.");
                        BrokerDiscoveryClient.access$getCache$p(this.this$0).clearCachedActiveBroker();
                        BrokerDiscoveryClient.access$getCache$p(this.this$0).setShouldUseAccountManagerForTheNextMilliseconds(TimeUnit.MINUTES.toMillis(60L));
                    }
                }), (Continuation<? super BrokerData>)$continuation);
                ** if (v2 != var19_5) goto lbl69
lbl68:
                // 1 sources

                return var19_5;
lbl69:
                // 1 sources

                ** GOTO lbl81
            }
            case 2: {
                $i$a$-withLock$default-BrokerDiscoveryClient$getActiveBrokerAsync$2 = false;
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$2;
                methodTag = (String)$continuation.L$1;
                this = (BrokerDiscoveryClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl81:
                // 2 sources

                if ((brokerData = (BrokerData)v2) != null) {
                    this.cache.setCachedActiveBroker(brokerData);
                    var14_19 = brokerData;
                    return var14_19;
                }
                accountManagerResult = (BrokerData)this.getActiveBrokerFromAccountManager.invoke();
                v3 = accountManagerResult;
                Logger.info((String)methodTag, (String)("Tried getting active broker from account manager, get " + (v3 != null ? v3.getPackageName() : null) + '.'));
                var13_21 = accountManagerResult;
                return var13_21;
            }
            catch (Throwable var12_22) {
                throw var12_22;
            }
            {
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$getActiveBrokerAsync(BrokerDiscoveryClient $this, boolean shouldSkipCache, Continuation $completion) {
        return $this.getActiveBrokerAsync(shouldSkipCache, (Continuation<? super BrokerData>)$completion);
    }

    public static final /* synthetic */ IClientActiveBrokerCache access$getCache$p(BrokerDiscoveryClient $this) {
        return $this.cache;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J(\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002Ja\u0010\u001c\u001a\u0004\u0018\u00010\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020!0 2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020!0 2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b#\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\u00020\r\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u0002\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006%"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/BrokerDiscoveryClient$Companion;", "", "()V", "ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY", "", "ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY", "ERROR_BUNDLE_KEY", "TAG", "getTAG", "()Ljava/lang/String;", "classLevelLock", "Lkotlinx/coroutines/sync/Mutex;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getDispatcher$annotations", "getDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "extractResult", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "bundle", "Landroid/os/Bundle;", "makeRequest", "candidate", "ipcStrategy", "Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;", "shouldStopQueryForAWhile", "Lkotlin/Function0;", "", "queryFromBroker", "brokerCandidates", "", "isPackageInstalled", "Lkotlin/Function1;", "", "isValidBroker", "queryFromBroker$common_distRelease", "(Ljava/util/Set;Lcom/microsoft/identity/common/internal/broker/ipc/IIpcStrategy;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final CoroutineDispatcher getDispatcher() {
            return dispatcher;
        }

        public static /* synthetic */ void getDispatcher$annotations() {
        }

        @Nullable
        public final Object queryFromBroker$common_distRelease(@NotNull Set<BrokerData> brokerCandidates, @NotNull IIpcStrategy ipcStrategy, @NotNull Function1<? super BrokerData, Boolean> isPackageInstalled, @NotNull Function1<? super BrokerData, Boolean> isValidBroker, @NotNull Function0<Unit> shouldStopQueryForAWhile, @NotNull Continuation<? super BrokerData> $completion) {
            return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>(brokerCandidates, isPackageInstalled, isValidBroker, ipcStrategy, shouldStopQueryForAWhile, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ Set<BrokerData> $brokerCandidates;
                final /* synthetic */ Function1<BrokerData, Boolean> $isPackageInstalled;
                final /* synthetic */ Function1<BrokerData, Boolean> $isValidBroker;
                final /* synthetic */ IIpcStrategy $ipcStrategy;
                final /* synthetic */ Function0<Unit> $shouldStopQueryForAWhile;
                {
                    this.$brokerCandidates = $brokerCandidates;
                    this.$isPackageInstalled = $isPackageInstalled;
                    this.$isValidBroker = $isValidBroker;
                    this.$ipcStrategy = $ipcStrategy;
                    this.$shouldStopQueryForAWhile = $shouldStopQueryForAWhile;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void $this$mapTo$iv$iv;
                            Iterable $this$filterTo$iv$iv;
                            Iterable $this$filter$iv;
                            ResultKt.throwOnFailure((Object)object);
                            CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                            Iterable iterable = this.$brokerCandidates;
                            Function1<BrokerData, Boolean> function1 = this.$isPackageInstalled;
                            boolean $i$f$filter = false;
                            Function0<Unit> function0 = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList<E>();
                            boolean $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                if (!((Boolean)function1.invoke(element$iv$iv)).booleanValue()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            Function1<BrokerData, Boolean> function12 = this.$isValidBroker;
                            $i$f$filter = false;
                            $this$filterTo$iv$iv = $this$filter$iv;
                            destination$iv$iv = new ArrayList<E>();
                            $i$f$filterTo = false;
                            for (T element$iv$iv : $this$filterTo$iv$iv) {
                                if (!((Boolean)function12.invoke(element$iv$iv)).booleanValue()) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List installedCandidates = (List)destination$iv$iv;
                            Iterable iterable2 = installedCandidates;
                            IIpcStrategy iIpcStrategy = this.$ipcStrategy;
                            function0 = this.$shouldStopQueryForAWhile;
                            boolean $i$f$map = false;
                            Iterable $i$f$filterTo2 = iterable2;
                            Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void candidate;
                                BrokerData brokerData2 = (BrokerData)item$iv$iv;
                                Collection collection = destination$iv$iv2;
                                boolean bl = false;
                                collection.add(BuildersKt.async$default((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)BrokerDiscoveryClient.Companion.getDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super BrokerData>, Object>((BrokerData)candidate, iIpcStrategy, function0, null){
                                    int label;
                                    final /* synthetic */ BrokerData $candidate;
                                    final /* synthetic */ IIpcStrategy $ipcStrategy;
                                    final /* synthetic */ Function0<Unit> $shouldStopQueryForAWhile;
                                    {
                                        this.$candidate = $candidate;
                                        this.$ipcStrategy = $ipcStrategy;
                                        this.$shouldStopQueryForAWhile = $shouldStopQueryForAWhile;
                                        super(2, $completion);
                                    }

                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                return com.microsoft.identity.common.internal.activebrokerdiscovery.BrokerDiscoveryClient$Companion.access$makeRequest(BrokerDiscoveryClient.Companion, this.$candidate, this.$ipcStrategy, this.$shouldStopQueryForAWhile);
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    @Nullable
                                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)2, null));
                            }
                            List deferredResults2 = (List)destination$iv$iv2;
                            this.label = 1;
                            Object object3 = AwaitKt.awaitAll((Collection)deferredResults2, (Continuation)((Continuation)this));
                            if (object3 != object2) return CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((Iterable)object3)));
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return CollectionsKt.firstOrNull((List)CollectionsKt.filterNotNull((Iterable)((Iterable)object3)));
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<CoroutineScope, Continuation<? super BrokerData>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super BrokerData> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final BrokerData makeRequest(BrokerData candidate, IIpcStrategy ipcStrategy, Function0<Unit> shouldStopQueryForAWhile) {
            BrokerData brokerData2;
            String methodTag = this.getTAG() + ":makeRequest";
            BrokerOperationBundle operationBundle = new BrokerOperationBundle(BrokerOperationBundle.Operation.BROKER_DISCOVERY_FROM_SDK, candidate.getPackageName(), new Bundle());
            try {
                Bundle result = ipcStrategy.communicateToBroker(operationBundle);
                brokerData2 = this.extractResult(result);
            }
            catch (Throwable t) {
                if (t instanceof BrokerCommunicationException && BrokerCommunicationException.Category.OPERATION_NOT_SUPPORTED_ON_SERVER_SIDE == ((BrokerCommunicationException)((Object)t)).getCategory()) {
                    Logger.info((String)methodTag, (String)("Tried broker discovery on " + candidate + ". It doesn't support the IPC mechanism."));
                    shouldStopQueryForAWhile.invoke();
                } else if (t instanceof ClientException && Intrinsics.areEqual((Object)"ONLY_SUPPORTS_ACCOUNT_MANAGER_ERROR_CODE", (Object)((ClientException)t).getErrorCode())) {
                    Logger.info((String)methodTag, (String)("Tried broker discovery on " + candidate + ". The Broker side indicates that only AccountManager is supported."));
                    shouldStopQueryForAWhile.invoke();
                } else {
                    Logger.error((String)methodTag, (String)("Tried broker discovery on " + candidate + ", get an error"), (Throwable)t);
                }
                brokerData2 = null;
            }
            return brokerData2;
        }

        private final BrokerData extractResult(Bundle bundle) throws NoSuchElementException {
            if (bundle == null) {
                return null;
            }
            Serializable errorData = bundle.getSerializable(BrokerDiscoveryClient.ERROR_BUNDLE_KEY);
            if (errorData != null) {
                throw (Throwable)errorData;
            }
            String string = bundle.getString(BrokerDiscoveryClient.ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY);
            if (string == null) {
                throw new NoSuchElementException("ACTIVE_BROKER_PACKAGE_NAME_BUNDLE_KEY must not be null");
            }
            String pkgName = string;
            String string2 = bundle.getString(BrokerDiscoveryClient.ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY);
            if (string2 == null) {
                throw new NoSuchElementException("ACTIVE_BROKER_SIGNING_CERTIFICATE_THUMBPRINT_BUNDLE_KEY must not be null");
            }
            String signatureHash = string2;
            return new BrokerData(pkgName, signatureHash);
        }

        public static final /* synthetic */ BrokerData access$makeRequest(Companion $this, BrokerData candidate, IIpcStrategy ipcStrategy, Function0 shouldStopQueryForAWhile) {
            return $this.makeRequest(candidate, ipcStrategy, (Function0<Unit>)shouldStopQueryForAWhile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

