/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.LruCache;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.KeyAccessorStringAdapter;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ported.Predicate;
import com.microsoft.identity.common.logging.Logger;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SharedPreferencesFileManager
implements IMultiTypeNameValueStorage {
    private static final String TAG = SharedPreferencesFileManager.class.getSimpleName();
    private final Object cacheLock = new Object();
    @GuardedBy(value="cacheLock")
    private final LruCache<String, String> fileCache = new LruCache(256);
    @GuardedBy(value="cacheLock")
    private final SharedPreferences mSharedPreferences;
    private final KeyAccessorStringAdapter mEncryptionManager;
    @VisibleForTesting
    private final String mSharedPreferencesFileName;
    private static final ConcurrentMap<String, SharedPreferencesFileManager> objectCache = new ConcurrentHashMap<String, SharedPreferencesFileManager>(16, 0.75f, 1);

    public static SharedPreferencesFileManager getSharedPreferences(Context context, String name, IKeyAccessor encryptionManager) {
        String key = name + "/" + context.getPackageName() + "/" + 0 + "/" + (encryptionManager == null ? "clear" : encryptionManager.getClass().getCanonicalName());
        SharedPreferencesFileManager cachedFileManager = (SharedPreferencesFileManager)objectCache.get(key);
        if (cachedFileManager == null && (cachedFileManager = objectCache.putIfAbsent(key, new SharedPreferencesFileManager(context, name, encryptionManager))) == null) {
            cachedFileManager = (SharedPreferencesFileManager)objectCache.get(key);
        }
        return cachedFileManager;
    }

    public static void clearSingletonCache() {
        objectCache.clear();
    }

    public SharedPreferencesFileManager(Context context, String name, IKeyAccessor encryptionManager) {
        if (encryptionManager == null) {
            Logger.verbose(TAG, "Init: ");
        } else {
            Logger.verbose(TAG, "Init with storage helper:  " + TAG);
        }
        this.mSharedPreferences = context.getSharedPreferences(name, 0);
        this.mSharedPreferencesFileName = name;
        this.mEncryptionManager = encryptionManager != null ? new KeyAccessorStringAdapter(encryptionManager) : null;
    }

    public final String getSharedPreferencesFileName() {
        return this.mSharedPreferencesFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putString(String key, String value) {
        Object object = this.cacheLock;
        synchronized (object) {
            if (value != null) {
                this.fileCache.put((Object)key, (Object)value);
            } else {
                this.fileCache.remove((Object)key);
            }
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            if (null == this.mEncryptionManager || StringUtil.isNullOrEmpty((String)value)) {
                editor.putString(key, value);
            } else {
                String encryptedValue = this.encrypt(value);
                editor.putString(key, encryptedValue);
            }
            editor.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getString(String key) {
        Object object = this.cacheLock;
        synchronized (object) {
            String memCache = (String)this.fileCache.get((Object)key);
            if (memCache != null) {
                return memCache;
            }
            String restoredValue = this.mSharedPreferences.getString(key, null);
            if (null != this.mEncryptionManager && !StringUtil.isNullOrEmpty((String)restoredValue) && StringUtil.isNullOrEmpty((String)(restoredValue = this.decrypt(restoredValue)))) {
                this.logWarningAndRemoveKey(key);
            }
            return restoredValue;
        }
    }

    public void putLong(String key, long value) {
        this.putString(key, String.valueOf(value));
    }

    public long getLong(String key) {
        String result = this.getString(key);
        if (!StringUtil.isNullOrEmpty((String)result)) {
            return Long.parseLong(result);
        }
        return 0L;
    }

    private void logWarningAndRemoveKey(String key) {
        String methodTag = TAG + ":logWarningAndRemoveKey";
        Logger.warn(methodTag, "Failed to decrypt value! This usually signals an issue with KeyStore or the provided SecretKeys.");
        this.remove(key);
    }

    public final Map<String, String> getAll() {
        Map entries = this.mSharedPreferences.getAll();
        if (null != this.mEncryptionManager) {
            for (Map.Entry entry : entries.entrySet()) {
                String decryptedValue = this.getString((String)entry.getKey());
                if (StringUtil.isNullOrEmpty((String)decryptedValue)) continue;
                entry.setValue(decryptedValue);
            }
        }
        return entries;
    }

    public final Iterator<Map.Entry<String, String>> getAllFilteredByKey(final @NonNull Predicate<String> keyFilter) {
        final Map entries = this.mSharedPreferences.getAll();
        return new Iterator<Map.Entry<String, String>>(){
            final Iterator<Map.Entry<String, String>> iterator;
            Map.Entry<String, String> nextEntry;
            {
                this.iterator = entries.entrySet().iterator();
                this.nextEntry = null;
            }

            @Override
            public boolean hasNext() {
                if (this.nextEntry != null) {
                    return true;
                }
                if (!this.iterator.hasNext()) {
                    return false;
                }
                do {
                    Map.Entry<String, String> nextElement;
                    if (!keyFilter.test((Object)(nextElement = this.iterator.next()).getKey())) continue;
                    if (SharedPreferencesFileManager.this.mEncryptionManager != null) {
                        String decryptedValue = SharedPreferencesFileManager.this.getString(nextElement.getKey());
                        if (StringUtil.isNullOrEmpty((String)decryptedValue)) continue;
                        this.nextEntry = new AbstractMap.SimpleEntry<String, String>(nextElement.getKey(), decryptedValue);
                        continue;
                    }
                    this.nextEntry = nextElement;
                } while (this.nextEntry == null && this.iterator.hasNext());
                return this.nextEntry != null;
            }

            @Override
            public Map.Entry<String, String> next() {
                if (this.nextEntry == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<String, String> tmp = this.nextEntry;
                this.nextEntry = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal is not supported");
            }
        };
    }

    public final boolean contains(String key) {
        return !StringUtil.isNullOrEmpty((String)this.getString(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        Object object = this.cacheLock;
        synchronized (object) {
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.clear();
            this.fileCache.evictAll();
            editor.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        String methodTag = TAG + ":remove";
        Logger.info(methodTag, "Removing cache key");
        Object object = this.cacheLock;
        synchronized (object) {
            this.fileCache.remove((Object)key);
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            editor.remove(key);
            editor.apply();
        }
        Logger.infoPII(methodTag, "Removed cache key [" + key + "]");
    }

    @Nullable
    private String encrypt(@NonNull String clearText) {
        return this.encryptDecryptInternal(clearText, true);
    }

    @Nullable
    private String decrypt(@NonNull String encryptedBlob) {
        return this.encryptDecryptInternal(encryptedBlob, false);
    }

    @Nullable
    private String encryptDecryptInternal(@NonNull String inputText, boolean encrypt) {
        String result;
        String methodTag = TAG + ":encryptDecryptInternal";
        try {
            result = encrypt ? this.mEncryptionManager.encrypt(inputText) : this.mEncryptionManager.decrypt(inputText);
        }
        catch (ClientException e) {
            Logger.error(methodTag, "Failed to " + (encrypt ? "encrypt" : "decrypt") + " value", encrypt ? null : e);
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushSharedPreference() {
        Object object = this.cacheLock;
        synchronized (object) {
            SharedPreferences.Editor editor = this.mSharedPreferences.edit();
            return editor.commit();
        }
    }
}

