/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.migration;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.migration.IMigrationOperationResult;
import java.util.HashMap;
import java.util.Map;

class MigrationOperationResult
implements IMigrationOperationResult {
    private int mCountOfTotalRecords;
    private int mCountOfFailedRecords;
    private Map<String, Integer> mFailures = new HashMap<String, Integer>();

    MigrationOperationResult() {
    }

    void addFailure(@NonNull Exception exception) {
        String exceptionKey = MigrationOperationResult.createExceptionKey(exception);
        Integer currentCountOfException = this.mFailures.get(exceptionKey);
        if (null == currentCountOfException) {
            this.mFailures.put(exceptionKey, 1);
        } else {
            this.mFailures.put(exceptionKey, currentCountOfException + 1);
        }
        ++this.mCountOfFailedRecords;
    }

    private static String createExceptionKey(@NonNull Exception exception) {
        String simpleName = exception.getClass().getSimpleName();
        String msg = exception.getMessage();
        return simpleName + "::" + msg;
    }

    @Override
    public int getCountOfTotalRecords() {
        return this.mCountOfTotalRecords;
    }

    public void setCountOfTotalRecords(int mCountOfTotalRecords) {
        this.mCountOfTotalRecords = mCountOfTotalRecords;
    }

    @Override
    public int getCountOfFailedRecords() {
        return this.mCountOfFailedRecords;
    }

    @Override
    public Map<String, Integer> getFailures() {
        return this.mFailures;
    }
}

