/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import com.microsoft.identity.common.logging.Logger;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\r\u0010\u0011\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0014"}, d2={"Lcom/microsoft/identity/common/internal/cache/HelloCacheResult;", "", "negotiatedProtocolVersion", "", "error", "timeStamp", "", "(Ljava/lang/String;Ljava/lang/String;J)V", "getError", "()Ljava/lang/String;", "getNegotiatedProtocolVersion", "getTimeStamp$common_localRelease", "()J", "isError", "", "isHandShakeError", "isSuccess", "serialize", "serialize$common_localRelease", "Companion", "common_localRelease"})
public final class HelloCacheResult {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String negotiatedProtocolVersion;
    @Nullable
    private final String error;
    private final long timeStamp;
    private static final String TAG = HelloCacheResult.class.getSimpleName();
    @NotNull
    private static final String SEPARATOR = ",";
    @NotNull
    private static final String ERROR_PREFIX = "E";
    @NotNull
    private static final String SUCCESS_PREFIX = "S";
    @NotNull
    private static final String SUCCESS_CACHE_VALUE_FORMAT = "S,%s,%d";
    @NotNull
    private static final String ERROR_CACHE_VALUE_FORMAT = "E,%s,%d";
    @NotNull
    private static final String HANDSHAKE_ERROR = "handshake_error";

    public HelloCacheResult(@Nullable String negotiatedProtocolVersion, @Nullable String error, long timeStamp) {
        this.negotiatedProtocolVersion = negotiatedProtocolVersion;
        this.error = error;
        this.timeStamp = timeStamp;
        CharSequence charSequence = this.negotiatedProtocolVersion;
        boolean bl = charSequence == null || charSequence.length() == 0;
        charSequence = this.error;
        if (!(bl ^ (charSequence == null || charSequence.length() == 0))) {
            throw new IllegalStateException("Either both parameters provided or none provided.");
        }
    }

    @Nullable
    public final String getNegotiatedProtocolVersion() {
        return this.negotiatedProtocolVersion;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public final long getTimeStamp$common_localRelease() {
        return this.timeStamp;
    }

    public final boolean isHandShakeError() {
        return this.isError() && Intrinsics.areEqual((Object)this.error, (Object)HANDSHAKE_ERROR);
    }

    public final boolean isSuccess() {
        CharSequence charSequence = this.negotiatedProtocolVersion;
        return !(charSequence == null || charSequence.length() == 0);
    }

    public final boolean isError() {
        CharSequence charSequence = this.error;
        return !(charSequence == null || charSequence.length() == 0);
    }

    @NotNull
    public final String serialize$common_localRelease() {
        String string2;
        CharSequence charSequence = this.error;
        if (!(charSequence == null || charSequence.length() == 0)) {
            String string3 = ERROR_CACHE_VALUE_FORMAT;
            Object[] objectArray = new Object[]{this.error, this.timeStamp};
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
        } else {
            String string5 = SUCCESS_CACHE_VALUE_FORMAT;
            Object[] objectArray = new Object[]{this.negotiatedProtocolVersion, this.timeStamp};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(format, *args)");
        }
        return string2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0015\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0013J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\r\u0010\u0014\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0015J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0017\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u000b*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/identity/common/internal/cache/HelloCacheResult$Companion;", "", "()V", "ERROR_CACHE_VALUE_FORMAT", "", "ERROR_PREFIX", "HANDSHAKE_ERROR", "SEPARATOR", "SUCCESS_CACHE_VALUE_FORMAT", "SUCCESS_PREFIX", "TAG", "kotlin.jvm.PlatformType", "createError", "Lcom/microsoft/identity/common/internal/cache/HelloCacheResult;", "error", "timeStamp", "", "createFromNegotiatedProtocolVersion", "negotiatedProtocolVersion", "createFromNegotiatedProtocolVersion$common_localRelease", "createHandshakeError", "createHandshakeError$common_localRelease", "deserialize", "value", "deserialize$common_localRelease", "common_localRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final HelloCacheResult deserialize$common_localRelease(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            String methodTag = TAG + ":deserialize";
            Object object = new String[]{HelloCacheResult.SEPARATOR};
            List values = StringsKt.split$default((CharSequence)value, (String[])object, (boolean)false, (int)0, (int)6, null);
            if (values.size() != 3) {
                Logger.warn(methodTag, "Legacy or Invalid cache entry. " + value);
                return null;
            }
            try {
                long timeStamp = Long.parseLong((String)values.get(2));
                object = Intrinsics.areEqual(values.get(0), (Object)HelloCacheResult.ERROR_PREFIX) ? this.createError((String)values.get(1), timeStamp) : this.createFromNegotiatedProtocolVersion((String)values.get(1), timeStamp);
            }
            catch (NumberFormatException e) {
                Logger.error(methodTag, "Invalid cache entry. " + value, e);
                object = null;
            }
            return object;
        }

        @NotNull
        public final HelloCacheResult createFromNegotiatedProtocolVersion$common_localRelease(@NotNull String negotiatedProtocolVersion) {
            Intrinsics.checkNotNullParameter((Object)negotiatedProtocolVersion, (String)"negotiatedProtocolVersion");
            return this.createFromNegotiatedProtocolVersion(negotiatedProtocolVersion, System.currentTimeMillis());
        }

        @NotNull
        public final HelloCacheResult createHandshakeError$common_localRelease() {
            return this.createError(HelloCacheResult.HANDSHAKE_ERROR, System.currentTimeMillis());
        }

        private final HelloCacheResult createFromNegotiatedProtocolVersion(String negotiatedProtocolVersion, long timeStamp) {
            return new HelloCacheResult(negotiatedProtocolVersion, null, timeStamp);
        }

        private final HelloCacheResult createError(String error, long timeStamp) {
            return new HelloCacheResult(null, error, timeStamp);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

