/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.cache.HelloCacheResult;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.logging.Logger;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005J\u001a\u0010\u0017\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0018\u0010\u0018\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005J \u0010\u0019\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u0005J*\u0010\u001b\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0005H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u00058WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/identity/common/internal/cache/HelloCache;", "", "context", "Landroid/content/Context;", "protocolName", "", "targetAppPackageName", "components", "Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;", "cacheExpiryTimeInMs", "", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;J)V", "fileManager", "Lcom/microsoft/identity/common/java/interfaces/INameValueStorage;", "versionCode", "getVersionCode", "()Ljava/lang/String;", "clearCache", "", "getHelloCacheResult", "Lcom/microsoft/identity/common/internal/cache/HelloCacheResult;", "clientMinimumProtocolVersion", "clientMaximumProtocolVersion", "getNegotiatedProtocolVersionCacheKey", "saveHandshakeError", "saveNegotiatedProtocolVersion", "negotiatedProtocolVersion", "saveNegotiatedValue", "result", "callerMethodTag", "Companion", "common_localRelease"})
public class HelloCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String protocolName;
    @NotNull
    private final String targetAppPackageName;
    private final long cacheExpiryTimeInMs;
    @NotNull
    private final INameValueStorage<String> fileManager;
    private static final String TAG = HelloCache.class.getSimpleName();
    @NotNull
    private static final String SHARED_PREFERENCE_NAME = "com.microsoft.common.ipc.hello.cache";
    private static boolean sIsEnabled = true;
    private static final long DEFAULT_CACHE_EXPIRY_MILLIS = TimeUnit.HOURS.toMillis(4L);

    public HelloCache(@NotNull Context context, @NotNull String protocolName, @NotNull String targetAppPackageName, @NotNull IPlatformComponents components, long cacheExpiryTimeInMs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)protocolName, (String)"protocolName");
        Intrinsics.checkNotNullParameter((Object)targetAppPackageName, (String)"targetAppPackageName");
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        this.context = context;
        this.protocolName = protocolName;
        this.targetAppPackageName = targetAppPackageName;
        this.cacheExpiryTimeInMs = cacheExpiryTimeInMs;
        this.fileManager = components.getStorageSupplier().getUnencryptedNameValueStore(SHARED_PREFERENCE_NAME, String.class);
    }

    public /* synthetic */ HelloCache(Context context, String string2, String string3, IPlatformComponents iPlatformComponents, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            l = DEFAULT_CACHE_EXPIRY_MILLIS;
        }
        this(context, string2, string3, iPlatformComponents, l);
    }

    @Nullable
    public final HelloCacheResult getHelloCacheResult(@Nullable String clientMinimumProtocolVersion, @NotNull String clientMaximumProtocolVersion) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)clientMaximumProtocolVersion, (String)"clientMaximumProtocolVersion");
        String methodTag = TAG + ":tryGetNegotiatedProtocolVersion";
        if (!sIsEnabled) {
            Logger.infoPII(methodTag, "hello cache is not enabled.");
            return null;
        }
        try {
            string2 = this.getNegotiatedProtocolVersionCacheKey(clientMinimumProtocolVersion, clientMaximumProtocolVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(methodTag, "Failed to retrieve key", e);
            return null;
        }
        String key = string2;
        String cachedRawValue = (String)this.fileManager.get(key);
        CharSequence e = cachedRawValue;
        if (e == null || e.length() == 0) {
            return null;
        }
        HelloCacheResult cacheResult = HelloCacheResult.Companion.deserialize$common_localRelease(cachedRawValue);
        if (cacheResult == null) {
            Logger.info(methodTag, "Legacy or invalid cache value.");
            this.fileManager.remove(key);
            return null;
        }
        if (System.currentTimeMillis() - cacheResult.getTimeStamp$common_localRelease() > this.cacheExpiryTimeInMs) {
            Logger.info(methodTag, "Cache entry is expired.");
            this.fileManager.remove(key);
            return null;
        }
        return cacheResult;
    }

    public final void saveNegotiatedProtocolVersion(@Nullable String clientMinimumProtocolVersion, @NotNull String clientMaximumProtocolVersion, @NotNull String negotiatedProtocolVersion) {
        Intrinsics.checkNotNullParameter((Object)clientMaximumProtocolVersion, (String)"clientMaximumProtocolVersion");
        Intrinsics.checkNotNullParameter((Object)negotiatedProtocolVersion, (String)"negotiatedProtocolVersion");
        String methodTag = TAG + ":saveNegotiatedProtocolVersion";
        this.saveNegotiatedValue(clientMinimumProtocolVersion, clientMaximumProtocolVersion, HelloCacheResult.Companion.createFromNegotiatedProtocolVersion$common_localRelease(negotiatedProtocolVersion), methodTag);
    }

    public final void saveHandshakeError(@Nullable String clientMinimumProtocolVersion, @NotNull String clientMaximumProtocolVersion) {
        Intrinsics.checkNotNullParameter((Object)clientMaximumProtocolVersion, (String)"clientMaximumProtocolVersion");
        String methodTag = TAG + ":saveHandShakeError";
        this.saveNegotiatedValue(clientMinimumProtocolVersion, clientMaximumProtocolVersion, HelloCacheResult.Companion.createHandshakeError$common_localRelease(), methodTag);
    }

    private final void saveNegotiatedValue(String clientMinimumProtocolVersion, String clientMaximumProtocolVersion, HelloCacheResult result, String callerMethodTag) {
        String string2;
        String methodTag = TAG + callerMethodTag + ":saveNegotiatedProtocolVersion";
        if (!sIsEnabled) {
            Logger.infoPII(methodTag, "hello cache is not enabled.");
            return;
        }
        try {
            string2 = this.getNegotiatedProtocolVersionCacheKey(clientMinimumProtocolVersion, clientMaximumProtocolVersion);
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(methodTag, "Failed to retrieve key", e);
            return;
        }
        String key = string2;
        this.fileManager.put(key, (Object)result.serialize$common_localRelease());
    }

    private final String getNegotiatedProtocolVersionCacheKey(String clientMinimumProtocolVersion, String clientMaximumProtocolVersion) throws PackageManager.NameNotFoundException {
        return this.protocolName + '[' + clientMinimumProtocolVersion + ',' + clientMaximumProtocolVersion + "]:" + this.targetAppPackageName + '[' + this.getVersionCode() + ']';
    }

    @VisibleForTesting
    public final void clearCache() {
        this.fileManager.clear();
    }

    @VisibleForTesting
    @NotNull
    public String getVersionCode() throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = this.context.getPackageManager().getPackageInfo(this.targetAppPackageName, 0);
        return Build.VERSION.SDK_INT >= 28 ? String.valueOf(packageInfo.getLongVersionCode()) : String.valueOf(packageInfo.versionCode);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \b*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/identity/common/internal/cache/HelloCache$Companion;", "", "()V", "DEFAULT_CACHE_EXPIRY_MILLIS", "", "SHARED_PREFERENCE_NAME", "", "TAG", "kotlin.jvm.PlatformType", "sIsEnabled", "", "setIsEnabled", "", "value", "common_localRelease"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void setIsEnabled(boolean value) {
            Class<HelloCache> clazz = HelloCache.class;
            synchronized (clazz) {
                boolean bl = false;
                sIsEnabled = value;
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

