/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.activebrokerdiscovery;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.Context;
import com.microsoft.identity.common.internal.activebrokerdiscovery.IBrokerDiscoveryClient;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/LegacyBrokerDiscoveryClient;", "Lcom/microsoft/identity/common/internal/activebrokerdiscovery/IBrokerDiscoveryClient;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "getActiveBroker", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "shouldSkipCache", "", "Companion", "common_localRelease"})
public final class LegacyBrokerDiscoveryClient
implements IBrokerDiscoveryClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(LegacyBrokerDiscoveryClient.class).getSimpleName();

    public LegacyBrokerDiscoveryClient(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @Nullable
    public BrokerData getActiveBroker(boolean shouldSkipCache) {
        BrokerData brokerData2;
        String methodTag = TAG + ":getActiveBroker";
        try {
            Object v1;
            block4: {
                String string2 = LegacyBrokerDiscoveryClient.Companion.getActiveBrokerPackageName(this.context);
                if (string2 == null) {
                    return null;
                }
                String activeBrokerPkgName = string2;
                Iterable $this$firstOrNull$iv = BrokerData.Companion.getKnownBrokerApps();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    BrokerData it = (BrokerData)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getPackageName(), (Object)activeBrokerPkgName)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            brokerData2 = v1;
        }
        catch (Exception e) {
            Logger.error(methodTag, "Failed to get active broker", e);
            brokerData2 = null;
        }
        return brokerData2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/LegacyBrokerDiscoveryClient$Companion;", "", "()V", "TAG", "", "getActiveBrokerPackageName", "context", "Landroid/content/Context;", "common_localRelease"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final String getActiveBrokerPackageName(Context context) {
            String methodTag = TAG + ":getActiveBrokerPackageName";
            AuthenticatorDescription[] authenticators = AccountManager.get((Context)context).getAuthenticatorTypes();
            Logger.info(methodTag, authenticators.length + " Authenticators registered.");
            BrokerValidator brokerValidator = new BrokerValidator(context);
            Intrinsics.checkNotNullExpressionValue((Object)authenticators, (String)"authenticators");
            for (AuthenticatorDescription authenticator : authenticators) {
                void $this$trim$iv;
                Logger.info(methodTag, "Authenticator: " + authenticator.packageName + " type: " + authenticator.type);
                Intrinsics.checkNotNullExpressionValue((Object)authenticator.type, (String)"authenticator.type");
                String string2 = "com.microsoft.workaccount";
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                if (!StringsKt.equals((String)string2, (String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (boolean)true)) continue;
                Logger.info(methodTag, "Verify: " + authenticator.packageName);
                brokerValidator.verifySignatureAndThrow(authenticator.packageName);
                return authenticator.packageName;
            }
            Logger.info(methodTag, "None of the authenticators, is type: com.microsoft.workaccount");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

