/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.components;

import android.content.Context;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.util.SharedPrefStringNameValueStorage;
import com.microsoft.identity.common.internal.util.SharedPreferenceLongStorage;
import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.crypto.StorageEncryptionManager;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IStorageSupplier;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/identity/common/components/AndroidStorageSupplier;", "Lcom/microsoft/identity/common/java/interfaces/IStorageSupplier;", "context", "Landroid/content/Context;", "storageEncryptionManager", "Lcom/microsoft/identity/common/java/crypto/StorageEncryptionManager;", "(Landroid/content/Context;Lcom/microsoft/identity/common/java/crypto/StorageEncryptionManager;)V", "getEncryptedFileStore", "Lcom/microsoft/identity/common/java/cache/IMultiTypeNameValueStorage;", "storeName", "", "getEncryptedNameValueStore", "Lcom/microsoft/identity/common/java/interfaces/INameValueStorage;", "T", "clazz", "Ljava/lang/Class;", "getUnencryptedFileStore", "getUnencryptedNameValueStore", "Companion", "common_localRelease"})
public final class AndroidStorageSupplier
implements IStorageSupplier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final StorageEncryptionManager storageEncryptionManager;

    public AndroidStorageSupplier(@NotNull Context context, @NotNull StorageEncryptionManager storageEncryptionManager) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)storageEncryptionManager, (String)"storageEncryptionManager");
        this.context = context;
        this.storageEncryptionManager = storageEncryptionManager;
    }

    @NotNull
    public <T> INameValueStorage<T> getUnencryptedNameValueStore(@NotNull String storeName, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return AndroidStorageSupplier.Companion.getNameValueStore(this.context, storeName, clazz, null);
    }

    @NotNull
    public <T> INameValueStorage<T> getEncryptedNameValueStore(@NotNull String storeName, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return AndroidStorageSupplier.Companion.getNameValueStore(this.context, storeName, clazz, this.storageEncryptionManager);
    }

    @NotNull
    public IMultiTypeNameValueStorage getUnencryptedFileStore(@NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        SharedPreferencesFileManager sharedPreferencesFileManager = SharedPreferencesFileManager.getSharedPreferences(this.context, storeName, null);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferencesFileManager, (String)"getSharedPreferences(context, storeName, null)");
        return sharedPreferencesFileManager;
    }

    @NotNull
    public IMultiTypeNameValueStorage getEncryptedFileStore(@NotNull String storeName) {
        Intrinsics.checkNotNullParameter((Object)storeName, (String)"storeName");
        SharedPreferencesFileManager sharedPreferencesFileManager = SharedPreferencesFileManager.getSharedPreferences(this.context, storeName, (IKeyAccessor)this.storageEncryptionManager);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferencesFileManager, (String)"getSharedPreferences(con\u2026storageEncryptionManager)");
        return sharedPreferencesFileManager;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/microsoft/identity/common/components/AndroidStorageSupplier$Companion;", "", "()V", "getNameValueStore", "Lcom/microsoft/identity/common/java/interfaces/INameValueStorage;", "T", "context", "Landroid/content/Context;", "storeName", "", "clazz", "Ljava/lang/Class;", "storageEncryptionManager", "Lcom/microsoft/identity/common/java/crypto/StorageEncryptionManager;", "common_localRelease"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> INameValueStorage<T> getNameValueStore(Context context, String storeName, Class<T> clazz, StorageEncryptionManager storageEncryptionManager) {
            SharedPreferencesFileManager sharedPreferencesFileManager = SharedPreferencesFileManager.getSharedPreferences(context, storeName, (IKeyAccessor)storageEncryptionManager);
            Intrinsics.checkNotNullExpressionValue((Object)sharedPreferencesFileManager, (String)"getSharedPreferences(con\u2026storageEncryptionManager)");
            IMultiTypeNameValueStorage mgr = sharedPreferencesFileManager;
            if (Long.TYPE.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)) {
                return new SharedPreferenceLongStorage(mgr);
            }
            if (String.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz)) {
                return new SharedPrefStringNameValueStorage(mgr);
            }
            throw new UnsupportedOperationException("Only Long and String are natively supported as types");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

