/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import com.microsoft.identity.common.internal.util.AbstractSharedPrefNameValueStorage;
import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.util.ported.Predicate;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import lombok.NonNull;

public class SharedPreferenceLongStorage
extends AbstractSharedPrefNameValueStorage<Long> {
    public SharedPreferenceLongStorage(@NonNull IMultiTypeNameValueStorage mManager) {
        super(mManager);
        if (mManager == null) {
            throw new NullPointerException("mManager is marked non-null but is null");
        }
    }

    public Long get(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.mManager.getLong(name);
    }

    @NonNull
    public Map<String, Long> getAll() {
        HashMap<String, Long> allLongs = new HashMap<String, Long>();
        for (Map.Entry e : this.mManager.getAll().entrySet()) {
            try {
                allLongs.put((String)e.getKey(), Long.parseLong((String)e.getValue()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return allLongs;
    }

    public void put(@NonNull String name, @Nullable Long value) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (value == null) {
            this.mManager.putString(name, null);
        } else {
            this.mManager.putLong(name, value.longValue());
        }
    }

    public Iterator<Map.Entry<String, Long>> getAllFilteredByKey(final @NonNull Predicate<String> keyFilter) {
        if (keyFilter == null) {
            throw new NullPointerException("keyFilter is marked non-null but is null");
        }
        return new Iterator<Map.Entry<String, Long>>(){
            final Iterator<Map.Entry<String, String>> iterator;
            Map.Entry<String, Long> nextEntry;
            {
                this.iterator = SharedPreferenceLongStorage.this.mManager.getAllFilteredByKey(keyFilter);
                this.nextEntry = null;
            }

            @Override
            public boolean hasNext() {
                if (this.nextEntry != null) {
                    return true;
                }
                if (!this.iterator.hasNext()) {
                    return false;
                }
                do {
                    Map.Entry<String, String> nextElement = this.iterator.next();
                    try {
                        long parsedValue = Long.parseLong(nextElement.getValue());
                        this.nextEntry = new AbstractMap.SimpleEntry<String, Long>(nextElement.getKey(), parsedValue);
                    }
                    catch (NumberFormatException nfe) {
                        this.nextEntry = null;
                    }
                } while (this.nextEntry == null && this.iterator.hasNext());
                return this.nextEntry != null;
            }

            @Override
            public Map.Entry<String, Long> next() {
                if (this.nextEntry == null && !this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Map.Entry<String, Long> tmp = this.nextEntry;
                this.nextEntry = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Removal of elements is not supported");
            }
        };
    }
}

