/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.java.exception.ClientException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public final class PackageUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("([A-Fa-f0-9]{2}:)*[A-Fa-f0-9]{2}");

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public static List<X509Certificate> readCertDataForApp(String packageName, Context context) throws PackageManager.NameNotFoundException, ClientException, IOException, GeneralSecurityException {
        PackageInfo packageInfo = PackageHelper.getPackageInfo(context.getPackageManager(), packageName);
        if (packageInfo == null) {
            throw new ClientException("App package name is not found in the package manager.", "No broker package existed.");
        }
        Signature[] signatures = PackageHelper.getSignatures(packageInfo);
        if (signatures == null || signatures.length == 0) {
            throw new ClientException("Calling app could not be verified", "No signature associated with the broker package.");
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(signatures.length);
        for (Signature signature : signatures) {
            byte[] rawCert = signature.toByteArray();
            ByteArrayInputStream certStream = new ByteArrayInputStream(rawCert);
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(certStream);
                certificates.add(x509Certificate);
            }
            catch (CertificateException e) {
                throw new ClientException("Calling app could not be verified");
            }
        }
        return certificates;
    }

    public static String verifySignatureHash(@NonNull List<X509Certificate> certs, @NonNull Iterator<String> validHashes) throws NoSuchAlgorithmException, CertificateEncodingException, ClientException {
        StringBuilder hashListStringBuilder = new StringBuilder();
        for (X509Certificate x509Certificate : certs) {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update(x509Certificate.getEncoded());
            String sha512SignatureHash = Base64.encodeToString((byte[])messageDigest.digest(), (int)2);
            hashListStringBuilder.append(sha512SignatureHash);
            hashListStringBuilder.append(',');
            while (validHashes.hasNext()) {
                String hash = validHashes.next();
                if (HEX_PATTERN.matcher(hash).matches()) {
                    hash = PackageUtils.convertToBase64(hash);
                }
                if (TextUtils.isEmpty((CharSequence)hash) || !hash.equals(sha512SignatureHash)) continue;
                return sha512SignatureHash;
            }
        }
        throw new ClientException("broker_app_verification_failed", "Calling app could not be verifiedSignatureHashes: " + hashListStringBuilder.toString());
    }

    public static String convertToBase64(@NonNull String hash) {
        String[] hexSegments = hash.split(":");
        byte[] values = new byte[hexSegments.length];
        int i = 0;
        String[] stringArray = hexSegments;
        int n = stringArray.length;
        for (int j = 0; j < n; ++j) {
            String hexString;
            String segment = hexString = stringArray[j];
            values[i++] = (byte)(Long.parseLong(segment, 16) & 0xFFL);
        }
        return Base64.encodeToString((byte[])values, (int)2);
    }

    public static void verifyCertificateChain(List<X509Certificate> certificates) throws GeneralSecurityException, ClientException {
        X509Certificate issuerCert = PackageUtils.getSelfSignedCert(certificates);
        TrustAnchor trustAnchor = new TrustAnchor(issuerCert, null);
        PKIXParameters pkixParameters = new PKIXParameters(Collections.singleton(trustAnchor));
        pkixParameters.setRevocationEnabled(false);
        CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(certificates);
        CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
        certPathValidator.validate(certPath, pkixParameters);
    }

    public static final X509Certificate getSelfSignedCert(List<X509Certificate> certs) throws ClientException {
        int count = 0;
        X509Certificate selfSignedCert = null;
        for (X509Certificate x509Certificate : certs) {
            if (!x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) continue;
            selfSignedCert = x509Certificate;
            ++count;
        }
        if (count > 1 || selfSignedCert == null) {
            throw new ClientException("Calling app could not be verified", "Multiple self signed certs found or no self signed cert existed.");
        }
        return selfSignedCert;
    }

    private PackageUtils() {
    }
}

