/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.util.PackageUtils;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BrokerValidator {
    private static final String TAG = "BrokerValidator";
    private static boolean sShouldTrustDebugBrokers = false;
    private final Context mContext;

    public static void setShouldTrustDebugBrokers(boolean shouldTrustDebugBrokers) {
        String methodTag = "BrokerValidator:setShouldTrustDebugBrokers";
        if (shouldTrustDebugBrokers) {
            Logger.warn("BrokerValidator:setShouldTrustDebugBrokers", "You are forcing to trust debug brokers in non-debug builds.");
        }
        sShouldTrustDebugBrokers = shouldTrustDebugBrokers;
    }

    public static boolean getShouldTrustDebugBrokers() {
        return sShouldTrustDebugBrokers;
    }

    public BrokerValidator(Context context) {
        this.mContext = context;
    }

    public String verifySignatureAndThrow(String brokerPackageName) throws ClientException {
        try {
            List<X509Certificate> certs = this.readCertDataForBrokerApp(brokerPackageName);
            String signatureHash = PackageUtils.verifySignatureHash(certs, this.getValidBrokerSignatures());
            if (certs.size() > 1) {
                PackageUtils.verifyCertificateChain(certs);
            }
            return signatureHash;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new ClientException("broker_app_verification_failed", "App package name is not found in the package manager. " + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ClientException("no_such_algorithm", e.getMessage(), (Throwable)e);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new ClientException("broker_app_verification_failed", e.getMessage(), (Throwable)e);
        }
    }

    public boolean verifySignature(String brokerPackageName) {
        String methodTag = "BrokerValidator:verifySignature";
        try {
            return this.verifySignatureAndThrow(brokerPackageName) != null;
        }
        catch (ClientException e) {
            Logger.error("BrokerValidator:verifySignature", e.getErrorCode() + ": " + e.getMessage(), e);
            return false;
        }
    }

    public Set<BrokerData> getValidBrokers() {
        return sShouldTrustDebugBrokers ? BrokerData.getAllBrokers() : BrokerData.getProdBrokers();
    }

    public Iterator<String> getValidBrokerSignatures() {
        final Iterator<BrokerData> itr = this.getValidBrokers().iterator();
        return new Iterator<String>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove operations are not supported");
            }

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public String next() {
                return ((BrokerData)itr.next()).getSignatureHash();
            }
        };
    }

    public boolean isValidBrokerPackage(@NonNull String packageName) {
        Set<BrokerData> validBrokers = this.getValidBrokers();
        for (BrokerData brokerData2 : validBrokers) {
            if (!brokerData2.getPackageName().equals(packageName) || !this.verifySignature(packageName)) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private List<X509Certificate> readCertDataForBrokerApp(String brokerPackageName) throws PackageManager.NameNotFoundException, ClientException, IOException, GeneralSecurityException {
        return PackageUtils.readCertDataForApp(brokerPackageName, this.mContext);
    }

    @NonNull
    public String getCurrentActiveBrokerPackageName() throws ClientException {
        AuthenticatorDescription[] authenticators;
        String methodTag = "BrokerValidator:getValidActiveBrokerPackageName";
        try {
            authenticators = AccountManager.get((Context)this.mContext).getAuthenticatorTypes();
        }
        catch (Exception exception) {
            ClientException clientException = new ClientException("account_manager_failed", exception.getMessage());
            Logger.error("BrokerValidator:getValidActiveBrokerPackageName", exception.getMessage(), exception);
            throw clientException;
        }
        int numberOfAuthenticators = authenticators.length;
        Logger.info("BrokerValidator:getValidActiveBrokerPackageName", numberOfAuthenticators + " Authenticators registered.");
        for (AuthenticatorDescription authenticator : authenticators) {
            Logger.info("BrokerValidator:getValidActiveBrokerPackageName", "Authenticator: " + authenticator.packageName + ",  type: " + authenticator.type);
            if (!"com.microsoft.workaccount".equalsIgnoreCase(authenticator.type.trim())) continue;
            Logger.info("BrokerValidator:getValidActiveBrokerPackageName", "Verify: " + authenticator.packageName);
            this.verifySignatureAndThrow(authenticator.packageName);
            return authenticator.packageName;
        }
        String errorMessage = "None of the " + numberOfAuthenticators + " authenticators, is type: " + "com.microsoft.workaccount";
        ClientException clientException = new ClientException("not_valid_broker_found", errorMessage);
        Logger.error("BrokerValidator:getValidActiveBrokerPackageName", errorMessage, clientException);
        throw clientException;
    }

    public static boolean isValidBrokerRedirect(@Nullable String redirectUri, @NonNull Context context, @NonNull String packageName) {
        String methodTag = "BrokerValidator:isValidBrokerRedirect";
        String expectedBrokerRedirectUri = BrokerValidator.getBrokerRedirectUri(context, packageName);
        boolean isValidBrokerRedirect = StringUtil.equalsIgnoreCase((String)redirectUri, (String)expectedBrokerRedirectUri);
        if (packageName.equals("com.azure.authenticator")) {
            PackageHelper info = new PackageHelper(context.getPackageManager());
            String signatureDigest = info.getSha512SignatureForPackage(packageName);
            if (BrokerData.getProdMicrosoftAuthenticator().getSignatureHash().equals(signatureDigest) || BrokerData.getDebugMicrosoftAuthenticator().getSignatureHash().equals(signatureDigest)) {
                isValidBrokerRedirect |= StringUtil.equalsIgnoreCase((String)redirectUri, (String)"urn:ietf:wg:oauth:2.0:oob");
            }
        }
        if (!isValidBrokerRedirect) {
            Logger.error("BrokerValidator:isValidBrokerRedirect", "Broker redirect uri is invalid. Expected: " + expectedBrokerRedirectUri + " Actual: " + redirectUri, null);
        }
        return isValidBrokerRedirect;
    }

    public static String getBrokerRedirectUri(Context context, String packageName) {
        PackageHelper info = new PackageHelper(context.getPackageManager());
        String signatureDigest = info.getSha1SignatureForPackage(packageName);
        return PackageHelper.getBrokerRedirectUrl(packageName, signatureDigest);
    }
}

