/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.activebrokerdiscovery;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.content.Context;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B;\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\t\u0012\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007R\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/AccountManagerBrokerDiscoveryUtil;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "knownBrokerApps", "", "Lcom/microsoft/identity/common/internal/broker/BrokerData;", "isSignedByKnownKeys", "Lkotlin/Function1;", "", "getAccountManagerApps", "Lkotlin/Function0;", "", "Landroid/accounts/AuthenticatorDescription;", "(Ljava/util/Set;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;)V", "getActiveBrokerFromAccountManager", "Companion", "common_localRelease"})
public final class AccountManagerBrokerDiscoveryUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<BrokerData> knownBrokerApps;
    @NotNull
    private final Function1<BrokerData, Boolean> isSignedByKnownKeys;
    @NotNull
    private final Function0<AuthenticatorDescription[]> getAccountManagerApps;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(AccountManagerBrokerDiscoveryUtil.class).getSimpleName();

    public AccountManagerBrokerDiscoveryUtil(@NotNull Set<BrokerData> knownBrokerApps, @NotNull Function1<? super BrokerData, Boolean> isSignedByKnownKeys, @NotNull Function0<AuthenticatorDescription[]> getAccountManagerApps) {
        Intrinsics.checkNotNullParameter(knownBrokerApps, (String)"knownBrokerApps");
        Intrinsics.checkNotNullParameter(isSignedByKnownKeys, (String)"isSignedByKnownKeys");
        Intrinsics.checkNotNullParameter(getAccountManagerApps, (String)"getAccountManagerApps");
        this.knownBrokerApps = knownBrokerApps;
        this.isSignedByKnownKeys = isSignedByKnownKeys;
        this.getAccountManagerApps = getAccountManagerApps;
    }

    public AccountManagerBrokerDiscoveryUtil(final @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(BrokerData.Companion.getKnownBrokerApps(), (Function1<? super BrokerData, Boolean>)((Function1)new Function1<BrokerData, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull BrokerData brokerData2) {
                Intrinsics.checkNotNullParameter((Object)brokerData2, (String)"brokerData");
                return BrokerData.Companion.isSignedByKnownKeys(brokerData2, context);
            }
        }), (Function0<AuthenticatorDescription[]>)((Function0)new Function0<AuthenticatorDescription[]>(){

            @NotNull
            public final AuthenticatorDescription[] invoke() {
                AuthenticatorDescription[] authenticatorDescriptionArray = AccountManager.get((Context)context).getAuthenticatorTypes();
                Intrinsics.checkNotNullExpressionValue((Object)authenticatorDescriptionArray, (String)"get(context).authenticatorTypes");
                return authenticatorDescriptionArray;
            }
        }));
    }

    @Nullable
    public final BrokerData getActiveBrokerFromAccountManager() {
        AuthenticatorDescription[] authenticatorDescriptionArray;
        String methodTag = TAG + ":getActiveBrokerFromAccountManager";
        try {
            authenticatorDescriptionArray = (AuthenticatorDescription[])this.getAccountManagerApps.invoke();
        }
        catch (Throwable t) {
            throw new ClientException("account_manager_failed", t.getMessage());
        }
        AuthenticatorDescription[] authenticators = authenticatorDescriptionArray;
        Logger.info((String)methodTag, (String)(authenticators.length + " Authenticators registered."));
        AuthenticatorDescription[] $this$forEach$iv = authenticators;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            boolean bl;
            Object v2;
            block6: {
                AuthenticatorDescription element$iv;
                AuthenticatorDescription authenticator = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                String string2 = authenticator.packageName;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"authenticator.packageName");
                String packageName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                String string3 = authenticator.type;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"authenticator.type");
                String accountType = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                Logger.info((String)methodTag, (String)("Authenticator: " + packageName + " type: " + accountType));
                if (!StringsKt.equals((String)"com.microsoft.workaccount", (String)accountType, (boolean)true)) continue;
                Logger.info((String)methodTag, (String)("Verify: " + packageName));
                Iterable iterable = this.knownBrokerApps;
                for (Object t : iterable) {
                    BrokerData it = (BrokerData)t;
                    boolean bl3 = false;
                    if (!StringsKt.equals((String)it.getPackageName(), (String)packageName, (boolean)true)) continue;
                    v2 = t;
                    break block6;
                }
                v2 = null;
            }
            BrokerData brokerData2 = v2;
            if (brokerData2 != null) {
                BrokerData it;
                boolean bl4 = false;
                bl = ((Boolean)this.isSignedByKnownKeys.invoke((Object)it)).booleanValue();
            } else {
                bl = false;
            }
            if (!bl) continue;
            return brokerData2;
        }
        Logger.info((String)methodTag, (String)"No valid broker is found");
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/microsoft/identity/common/internal/activebrokerdiscovery/AccountManagerBrokerDiscoveryUtil$Companion;", "", "()V", "TAG", "", "getTAG", "()Ljava/lang/String;", "common_localRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String getTAG() {
            return TAG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

