/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.os.Bundle;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.marker.CodeMarkerManager;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public class BrokerOperationExecutor {
    private static final String TAG = BrokerOperationExecutor.class.getSimpleName();
    private final List<IIpcStrategy> mStrategies;

    public BrokerOperationExecutor(@NonNull List<IIpcStrategy> strategies) {
        if (strategies == null) {
            throw new NullPointerException("strategies is marked non-null but is null");
        }
        this.mStrategies = strategies;
    }

    public <T extends CommandParameters, U> U execute(@Nullable T parameters, @NonNull BrokerOperation<U> operation) throws BaseException {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        CodeMarkerManager codeMarkerManager = CodeMarkerManager.getInstance();
        codeMarkerManager.markCode("10110");
        String methodTag = TAG + ":execute";
        this.emitOperationStartEvent(parameters, operation);
        if (this.mStrategies.size() == 0) {
            ClientException exception = new ClientException("Failed to bind the service in broker app", "No strategies can be used to connect to the broker.");
            this.emitOperationFailureEvent(operation, (BaseException)((Object)exception));
            throw exception;
        }
        ArrayList<BrokerCommunicationException> communicationExceptionStack = new ArrayList<BrokerCommunicationException>();
        for (IIpcStrategy strategy : this.mStrategies) {
            try {
                codeMarkerManager.markCode("10111");
                U result = this.performStrategy(strategy, operation);
                codeMarkerManager.markCode("10120");
                this.emitOperationSuccessEvent(operation, result);
                return result;
            }
            catch (BrokerCommunicationException communicationException) {
                communicationExceptionStack.add(communicationException);
            }
            catch (BaseException exception) {
                this.emitOperationFailureEvent(operation, exception);
                throw exception;
            }
        }
        ClientException exception = new ClientException("Failed to bind the service in broker app", "Unable to connect to the broker. Please refer to MSAL/Broker logs or suppressed exception (API 19+) for more details.");
        for (BrokerCommunicationException e : communicationExceptionStack) {
            Logger.error(methodTag, e.getMessage(), (Throwable)((Object)e));
            exception.addSuppressedException((Exception)((Object)e));
        }
        this.emitOperationFailureEvent(operation, (BaseException)((Object)exception));
        throw exception;
    }

    private <T extends CommandParameters, U> void emitOperationStartEvent(@Nullable T parameters, @NonNull BrokerOperation<U> operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        String telemetryApiId = operation.getTelemetryApiId();
        if (!StringUtil.isNullOrEmpty((String)telemetryApiId)) {
            Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties(parameters).putApiId(telemetryApiId));
        }
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private <U> void emitOperationSuccessEvent(@NonNull BrokerOperation<U> operation, U result) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        String telemetryApiId = operation.getTelemetryApiId();
        if (telemetryApiId != null) {
            ApiEndEvent apiEndEvent = new ApiEndEvent();
            ApiEndEvent successEvent = (ApiEndEvent)apiEndEvent.putApiId(telemetryApiId).isApiCallSuccessful(Boolean.TRUE);
            operation.putValueInSuccessEvent(successEvent, result);
            Telemetry.emit((BaseEvent)successEvent);
        }
    }

    private <U> void emitOperationFailureEvent(@NonNull BrokerOperation<U> operation, BaseException exception) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        String telemetryApiId = operation.getTelemetryApiId();
        if (!StringUtil.isNullOrEmpty((String)telemetryApiId)) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)exception)).putApiId(telemetryApiId));
        }
    }

    private <T> T performStrategy(@NonNull IIpcStrategy strategy, @NonNull BrokerOperation<T> operation) throws BaseException {
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        com.microsoft.identity.common.internal.logging.Logger.info(TAG + operation.getMethodName(), "Executing with IIpcStrategy: " + strategy.getClass().getSimpleName());
        Span span = OTelUtility.createSpan((String)SpanName.MSAL_PerformIpcStrategy.name());
        try {
            T t;
            block13: {
                Scope scope = SpanExtension.makeCurrentSpan((Span)span);
                try {
                    span.setAttribute(AttributeName.ipc_strategy.name(), strategy.getType().name());
                    operation.performPrerequisites(strategy);
                    BrokerOperationBundle brokerOperationBundle = operation.getBundle();
                    Bundle resultBundle = strategy.communicateToBroker(brokerOperationBundle);
                    span.setStatus(StatusCode.OK);
                    t = operation.extractResultBundle(resultBundle);
                    if (scope == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        span.setStatus(StatusCode.ERROR);
                        span.recordException(throwable3);
                        throw throwable3;
                    }
                }
                scope.close();
            }
            return t;
        }
        finally {
            span.end();
        }
    }

    public static interface BrokerOperation<T> {
        public void performPrerequisites(@NonNull IIpcStrategy var1) throws BaseException;

        @NonNull
        public BrokerOperationBundle getBundle() throws ClientException;

        @NonNull
        public T extractResultBundle(@Nullable Bundle var1) throws BaseException;

        @NonNull
        public String getMethodName();

        @Nullable
        public String getTelemetryApiId();

        public void putValueInSuccessEvent(@NonNull ApiEndEvent var1, @NonNull T var2);
    }
}

