/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.os.Build;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.java.broker.IBrokerAccount;
import com.microsoft.identity.common.logging.Logger;
import lombok.NonNull;

public class AndroidBrokerAccount
implements IBrokerAccount {
    private static final String TAG = AndroidBrokerAccount.class.getSimpleName();
    @NonNull
    private final Account mAccount;

    @NonNull
    public String getUsername() {
        return this.mAccount.name;
    }

    @NonNull
    public String getType() {
        return this.mAccount.type;
    }

    @NonNull
    public static AndroidBrokerAccount cast(@NonNull IBrokerAccount account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        String methodTag = TAG + ":cast";
        try {
            return (AndroidBrokerAccount)account;
        }
        catch (ClassCastException e) {
            Logger.error(methodTag, "Expected an AndroidBrokerAccount, but got " + e.getClass().getSimpleName(), e);
            throw e;
        }
    }

    @NonNull
    public static AndroidBrokerAccount adapt(@NonNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        return new AndroidBrokerAccount(account);
    }

    @NonNull
    public static AndroidBrokerAccount create(@NonNull AccountManager accountManager, @NonNull String accountName, @NonNull String accountType) {
        if (accountManager == null) {
            throw new NullPointerException("accountManager is marked non-null but is null");
        }
        if (accountName == null) {
            throw new NullPointerException("accountName is marked non-null but is null");
        }
        if (accountType == null) {
            throw new NullPointerException("accountType is marked non-null but is null");
        }
        String methodTag = TAG + ":create";
        Account account = AndroidBrokerAccount.getAccount(accountManager, accountName, accountType);
        if (account == null) {
            account = new Account(accountName, accountType);
            Logger.verbose(methodTag, "Creating account.");
            Logger.verbosePII(methodTag, "Creating account with name :" + account.name);
            accountManager.addAccountExplicitly(account, null, null);
        } else {
            Logger.verbose(methodTag, "Account found.");
            Logger.verbosePII(methodTag, "account.name:" + account.name);
        }
        if (Build.VERSION.SDK_INT >= 26) {
            accountManager.setAccountVisibility(account, "com.azure.authenticator", 1);
            accountManager.setAccountVisibility(account, "com.microsoft.windowsintune.companyportal", 1);
            accountManager.setAccountVisibility(account, "com.microsoft.identity.testuserapp", 1);
        }
        return AndroidBrokerAccount.adapt(account);
    }

    @Nullable
    public static Account getAccount(@NonNull AccountManager accountManager, @Nullable String accountName, @NonNull String accountType) {
        if (accountManager == null) {
            throw new NullPointerException("accountManager is marked non-null but is null");
        }
        if (accountType == null) {
            throw new NullPointerException("accountType is marked non-null but is null");
        }
        String methodTag = TAG + ":getAccount";
        if (accountName == null) {
            return null;
        }
        Account[] accountList = accountManager.getAccountsByType(accountType);
        if (accountList != null) {
            for (Account existingAcct : accountList) {
                if (!existingAcct.name.equalsIgnoreCase(accountName)) continue;
                Logger.verbose(methodTag, "Account found.");
                return existingAcct;
            }
        } else {
            Logger.verbose(methodTag, "Account list null.");
        }
        return null;
    }

    @NonNull
    public Account getAccount() {
        return this.mAccount;
    }

    private AndroidBrokerAccount(@NonNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.mAccount = account;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AndroidBrokerAccount)) {
            return false;
        }
        AndroidBrokerAccount other = (AndroidBrokerAccount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Account this$mAccount = this.getAccount();
        Account other$mAccount = other.getAccount();
        return !(this$mAccount == null ? other$mAccount != null : !this$mAccount.equals(other$mAccount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AndroidBrokerAccount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Account $mAccount = this.getAccount();
        result = result * 59 + ($mAccount == null ? 43 : $mAccount.hashCode());
        return result;
    }
}

