/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.result;

import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.microsoft.identity.common.adal.internal.AuthenticationConstants;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.adal.internal.util.JsonExtensions;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.request.AuthenticationSchemeTypeAdapter;
import com.microsoft.identity.common.internal.result.IBrokerResultAdapter;
import com.microsoft.identity.common.internal.util.GzipUtil;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.AcquirePrtSsoTokenResult;
import com.microsoft.identity.common.java.dto.AccessTokenRecord;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.exception.UnsupportedBrokerException;
import com.microsoft.identity.common.java.exception.UserCancelException;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.util.BrokerProtocolVersionUtil;
import com.microsoft.identity.common.java.util.HeaderSerializationUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.json.JSONException;

public class MsalBrokerResultAdapter
implements IBrokerResultAdapter {
    private static final String TAG = MsalBrokerResultAdapter.class.getSimpleName();
    public static final Gson GSON = new Gson();

    @Override
    @NonNull
    public Bundle bundleFromAuthenticationResult(@NonNull ILocalAuthenticationResult authenticationResult, @Nullable String negotiatedBrokerProtocolVersion) {
        String methodTag = TAG + ":bundleFromAuthenticationResult";
        Logger.info(methodTag, "Constructing result bundle from ILocalAuthenticationResult");
        IAccountRecord accountRecord = authenticationResult.getAccountRecord();
        AccessTokenRecord accessTokenRecord = authenticationResult.getAccessTokenRecord();
        long expiresOn = Long.parseLong(accessTokenRecord.getExpiresOn());
        long extendedExpiresOn = accessTokenRecord.getExtendedExpiresOn() == null ? expiresOn : Long.parseLong(accessTokenRecord.getExtendedExpiresOn());
        BrokerResult brokerResult = new BrokerResult.Builder().tenantProfileRecords(authenticationResult.getCacheRecordWithTenantProfileData()).accessToken(authenticationResult.getAccessToken()).idToken(authenticationResult.getIdToken()).refreshToken(authenticationResult.getRefreshToken()).homeAccountId(accountRecord.getHomeAccountId()).localAccountId(accountRecord.getLocalAccountId()).userName(accountRecord.getUsername()).tokenType(accessTokenRecord.getAccessTokenType()).clientId(accessTokenRecord.getClientId()).familyId(authenticationResult.getFamilyId()).scope(accessTokenRecord.getTarget()).clientInfo(accountRecord.getClientInfo()).authority(accessTokenRecord.getAuthority()).environment(accessTokenRecord.getEnvironment()).tenantId(authenticationResult.getTenantId()).expiresOn(expiresOn).extendedExpiresOn(extendedExpiresOn).cachedAt(Long.parseLong(accessTokenRecord.getCachedAt())).speRing(authenticationResult.getSpeRing()).refreshTokenAge(authenticationResult.getRefreshTokenAge()).success(true).servicedFromCache(authenticationResult.isServicedFromCache()).build();
        Bundle resultBundle = this.bundleFromBrokerResult(brokerResult, negotiatedBrokerProtocolVersion);
        resultBundle.putBoolean("broker_request_v2_success", true);
        return resultBundle;
    }

    @Override
    @NonNull
    public Bundle bundleFromBaseException(@NonNull BaseException exception, @Nullable String negotiatedBrokerProtocolVersion) {
        String methodTag = TAG + ":bundleFromBaseException";
        Logger.info(methodTag, "Constructing result bundle from ClientException");
        BrokerResult.Builder builder = new BrokerResult.Builder().success(false).errorCode(exception.getErrorCode()).errorMessage(exception.getMessage()).exceptionType(exception.getExceptionName()).correlationId(exception.getCorrelationId()).cliTelemErrorCode(exception.getCliTelemErrorCode()).cliTelemSubErrorCode(exception.getCliTelemSubErrorCode()).speRing(exception.getSpeRing()).refreshTokenAge(exception.getRefreshTokenAge());
        if (exception instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)((Object)exception);
            builder.oauthSubErrorCode(serviceException.getOAuthSubErrorCode()).httpStatusCode(serviceException.getHttpStatusCode()).httpResponseBody(AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)serviceException.getHttpResponseBody()));
            if (serviceException.getHttpResponseHeaders() != null) {
                builder.httpResponseHeaders(HeaderSerializationUtil.toJson((Map)((ServiceException)((Object)exception)).getHttpResponseHeaders()));
            }
            if (serviceException.getHttpResponseBody() != null) {
                builder.httpResponseBody(AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)serviceException.getHttpResponseBody()));
            }
        }
        if (exception instanceof IntuneAppProtectionPolicyRequiredException) {
            builder.userName(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUpn()).localAccountId(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUserId()).authority(((IntuneAppProtectionPolicyRequiredException)exception).getAuthorityUrl()).tenantId(((IntuneAppProtectionPolicyRequiredException)exception).getTenantId());
        }
        Bundle resultBundle = this.bundleFromBrokerResult(builder.build(), negotiatedBrokerProtocolVersion);
        resultBundle.putBoolean("broker_request_v2_success", false);
        return resultBundle;
    }

    @Override
    @NonNull
    public ILocalAuthenticationResult authenticationResultFromBundle(@NonNull Bundle resultBundle) throws ClientException {
        String methodTag = TAG + ":authenticationResultFromBundle";
        BrokerResult brokerResult = this.brokerResultFromBundle(resultBundle);
        Logger.info(methodTag, "Broker Result returned from Bundle, constructing authentication result");
        List<ICacheRecord> tenantProfileCacheRecords = brokerResult.getTenantProfileData();
        if (tenantProfileCacheRecords == null) {
            Logger.error(methodTag, "getTenantProfileData is null", null);
            throw new ClientException("invalid_broker_bundle", "getTenantProfileData is null.");
        }
        return new LocalAuthenticationResult(tenantProfileCacheRecords.get(0), tenantProfileCacheRecords, SdkType.MSAL, brokerResult.isServicedFromCache());
    }

    @Override
    @NonNull
    public BaseException getBaseExceptionFromBundle(@NonNull Bundle resultBundle) {
        BrokerResult brokerResult;
        String methodTag = TAG + ":getBaseExceptionFromBundle";
        Logger.info(methodTag, "Constructing exception from result bundle");
        try {
            brokerResult = this.brokerResultFromBundle(resultBundle);
        }
        catch (ClientException e) {
            return e;
        }
        String exceptionType = brokerResult.getExceptionType();
        if (!StringUtil.isNullOrEmpty((String)exceptionType)) {
            return this.getBaseExceptionFromExceptionType(exceptionType, brokerResult);
        }
        Logger.info(methodTag, "Exception type is not returned from the broker, using error codes to transform to the right exception");
        return this.getBaseExceptionFromErrorCodes(brokerResult);
    }

    @Override
    @NonNull
    public AcquirePrtSsoTokenResult getAcquirePrtSsoTokenResultFromBundle(Bundle resultBundle) {
        return (AcquirePrtSsoTokenResult)GSON.fromJson(resultBundle.getString("broker_generate_sso_token"), AcquirePrtSsoTokenResult.class);
    }

    @NonNull
    public Bundle bundleFromBrokerResult(@NonNull BrokerResult brokerResult, @Nullable String negotiatedBrokerProtocolVersion) {
        String methodTag = TAG + ":bundleFromBrokerResult";
        Bundle resultBundle = new Bundle();
        String brokerResultString = AuthenticationSchemeTypeAdapter.getGsonInstance().toJson((Object)brokerResult, BrokerResult.class);
        if (BrokerProtocolVersionUtil.canCompressBrokerPayloads((String)negotiatedBrokerProtocolVersion)) {
            try {
                byte[] compressedBytes = GzipUtil.compressString(brokerResultString);
                Logger.info(methodTag, "Broker Result, raw payload size:" + brokerResultString.getBytes(AuthenticationConstants.CHARSET_UTF8).length + " ,compressed bytes " + compressedBytes.length);
                resultBundle.putByteArray("broker_result_v2_compressed", compressedBytes);
            }
            catch (IOException e) {
                Logger.error(methodTag, "Failed to compress Broker Result, sending as jsonString ", e);
                resultBundle.putString("broker_result_v2", brokerResultString);
            }
        } else {
            Logger.info(methodTag, "Broker protocol version: " + negotiatedBrokerProtocolVersion + " lower than compression changes, sending as string");
            resultBundle.putString("broker_result_v2", brokerResultString);
        }
        return resultBundle;
    }

    @NonNull
    public BrokerResult brokerResultFromBundle(@NonNull Bundle resultBundle) throws ClientException {
        String brokerResultString;
        String methodTag = TAG + ":brokerResultFromBundle";
        byte[] compressedBytes = resultBundle.getByteArray("broker_result_v2_compressed");
        if (compressedBytes != null) {
            try {
                brokerResultString = GzipUtil.decompressBytesToString(compressedBytes);
            }
            catch (IOException e) {
                Logger.error(methodTag, "Failed to decompress broker result :", e);
                throw new ClientException("invalid_broker_bundle", "Failed to decompress broker result", (Throwable)e);
            }
        } else {
            brokerResultString = resultBundle.getString("broker_result_v2");
        }
        if (StringUtil.isNullOrEmpty((String)brokerResultString)) {
            Logger.error(methodTag, "Broker Result not returned from Broker", null);
            throw new ClientException("invalid_broker_bundle", "Broker Result not returned from Broker", null);
        }
        return JsonExtensions.getBrokerResultFromJsonString(brokerResultString);
    }

    @NonNull
    private BaseException getBaseExceptionFromExceptionType(@NonNull String exceptionType, @NonNull BrokerResult brokerResult) {
        Object baseException;
        String methodTag = TAG + ":getBaseExceptionFromExceptionType";
        Logger.warn(methodTag, "Received a " + exceptionType + " from Broker : " + brokerResult.getErrorCode());
        if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.UiRequiredException")) {
            baseException = this.getUiRequiredException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.ServiceException")) {
            baseException = this.getServiceException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException")) {
            baseException = this.getIntuneProtectionRequiredException(brokerResult);
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.UserCancelException")) {
            baseException = new UserCancelException();
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.ClientException")) {
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        } else if (exceptionType.equalsIgnoreCase("com.microsoft.identity.common.exception.ArgumentException")) {
            baseException = new ArgumentException("brokerTokenRequest", brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        } else {
            Logger.warn(methodTag, " Exception type is unknown : " + exceptionType + brokerResult.getErrorCode() + ", defaulting to Client Exception ");
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        baseException.setCliTelemErrorCode(brokerResult.getCliTelemErrorCode());
        baseException.setCliTelemSubErrorCode(brokerResult.getCliTelemSubErrorCode());
        baseException.setCorrelationId(brokerResult.getCorrelationId());
        baseException.setSpeRing(brokerResult.getSpeRing());
        baseException.setRefreshTokenAge(brokerResult.getRefreshTokenAge());
        return baseException;
    }

    @NonNull
    private BaseException getBaseExceptionFromErrorCodes(@NonNull BrokerResult brokerResult) {
        Object baseException;
        String methodTag = TAG + ":getBaseExceptionFromErrorCodes";
        String errorCode = brokerResult.getErrorCode();
        if ("interaction_required".equalsIgnoreCase(errorCode) || "invalid_grant".equalsIgnoreCase(errorCode) || "Broker refresh token is invalid".equalsIgnoreCase(errorCode) || "no_account_found".equalsIgnoreCase(errorCode) || "no_tokens_found".equalsIgnoreCase(errorCode)) {
            Logger.warn(methodTag, "Received a UIRequired exception from Broker : " + errorCode);
            baseException = this.getUiRequiredException(brokerResult);
        } else if ("unauthorized_client".equalsIgnoreCase(errorCode) && "protection_policy_required".equalsIgnoreCase(brokerResult.getSubErrorCode())) {
            Logger.warn(methodTag, "Received a IntuneAppProtectionPolicyRequiredException exception from Broker : " + errorCode);
            baseException = this.getIntuneProtectionRequiredException(brokerResult);
        } else if ("User cancelled".equalsIgnoreCase(errorCode)) {
            Logger.warn(methodTag, "Received a User cancelled exception from Broker : " + errorCode);
            baseException = new UserCancelException();
        } else if ("illegal_argument_exception".equalsIgnoreCase(errorCode)) {
            Logger.warn(methodTag, "Received a Argument exception from Broker : " + errorCode);
            baseException = new ArgumentException("brokerTokenRequest", errorCode, brokerResult.getErrorMessage());
        } else if (!StringUtil.isNullOrEmpty((String)brokerResult.getHttpResponseHeaders()) || !StringUtil.isNullOrEmpty((String)brokerResult.getHttpResponseBody())) {
            Logger.warn(methodTag, "Received a Service exception from Broker : " + errorCode);
            baseException = this.getServiceException(brokerResult);
        } else {
            Logger.warn(methodTag, "Received a Client exception from Broker : " + errorCode);
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        baseException.setCliTelemErrorCode(brokerResult.getCliTelemErrorCode());
        baseException.setCliTelemSubErrorCode(brokerResult.getCliTelemSubErrorCode());
        baseException.setCorrelationId(brokerResult.getCorrelationId());
        baseException.setSpeRing(brokerResult.getSpeRing());
        baseException.setRefreshTokenAge(brokerResult.getRefreshTokenAge());
        return baseException;
    }

    @NonNull
    private IntuneAppProtectionPolicyRequiredException getIntuneProtectionRequiredException(@NonNull BrokerResult brokerResult) {
        String methodTag = TAG + ":getIntuneProtectionRequiredException";
        IntuneAppProtectionPolicyRequiredException exception = new IntuneAppProtectionPolicyRequiredException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        exception.setTenantId(brokerResult.getTenantId());
        exception.setAuthorityUrl(brokerResult.getAuthority());
        exception.setAccountUserId(brokerResult.getLocalAccountId());
        exception.setAccountUpn(brokerResult.getUserName());
        exception.setOauthSubErrorCode(brokerResult.getSubErrorCode());
        try {
            exception.setHttpResponseBody(HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()));
            if (brokerResult.getHttpResponseHeaders() != null) {
                exception.setHttpResponseHeaders(HeaderSerializationUtil.fromJson((String)brokerResult.getHttpResponseHeaders()));
            }
        }
        catch (JSONException e) {
            Logger.warn(methodTag, "Unable to parse json");
        }
        return exception;
    }

    @NonNull
    private ServiceException getServiceException(@NonNull BrokerResult brokerResult) {
        String methodTag = TAG + ":getServiceException";
        ServiceException serviceException = new ServiceException(brokerResult.getErrorCode(), brokerResult.getErrorMessage(), null);
        serviceException.setOauthSubErrorCode(brokerResult.getSubErrorCode());
        try {
            serviceException.setHttpResponseBody(brokerResult.getHttpResponseBody() != null ? HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()) : null);
            serviceException.setHttpResponseHeaders(brokerResult.getHttpResponseHeaders() != null ? HeaderSerializationUtil.fromJson((String)brokerResult.getHttpResponseHeaders()) : null);
        }
        catch (JSONException e) {
            Logger.warn(methodTag, "Unable to parse json");
        }
        return serviceException;
    }

    @NonNull
    private UiRequiredException getUiRequiredException(@NonNull BrokerResult brokerResult) {
        String errorCode = brokerResult.getErrorCode();
        UiRequiredException exception = new UiRequiredException(errorCode, brokerResult.getErrorMessage());
        if ("interaction_required".equalsIgnoreCase(errorCode) || "invalid_grant".equalsIgnoreCase(errorCode)) {
            exception.setOauthSubErrorCode(brokerResult.getSubErrorCode());
        }
        return exception;
    }

    @NonNull
    public String verifyHelloFromResultBundle(@NonNull String activeBrokerPackageName, @Nullable Bundle bundle) throws BaseException {
        String methodTag = TAG + ":verifyHelloFromResultBundle";
        if (bundle == null) {
            Logger.warn(methodTag, "The hello result bundle is null.");
            throw new UnsupportedBrokerException(activeBrokerPackageName);
        }
        String negotiatedBrokerProtocolVersion = bundle.getString("common.broker.protocol.version.name");
        if (!StringUtil.isNullOrEmpty((String)negotiatedBrokerProtocolVersion)) {
            Logger.info(methodTag, "Able to establish the connect, the broker protocol version in common is [" + negotiatedBrokerProtocolVersion + "]");
            return negotiatedBrokerProtocolVersion;
        }
        if (!StringUtil.isNullOrEmpty((String)bundle.getString("error"))) {
            String errorCode = bundle.getString("error");
            String errorMessage = bundle.getString("error_description");
            throw new UnsupportedBrokerException(activeBrokerPackageName, errorCode, errorMessage);
        }
        Object resultObject = bundle.get("broker_result_v2");
        if (resultObject instanceof BrokerResult) {
            BrokerResult brokerResult = (BrokerResult)resultObject;
            throw new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        Logger.warn(methodTag, "The result bundle is not in a recognizable format.");
        throw new UnsupportedBrokerException(activeBrokerPackageName);
    }

    @NonNull
    public Intent getIntentForInteractiveRequestFromResultBundle(@NonNull Bundle resultBundle, @NonNull String negotiatedBrokerProtocolVersion) throws ClientException {
        Bundle interactiveRequestBundle = this.extractInteractiveRequestBundleFromResultBundle(resultBundle);
        String packageName = interactiveRequestBundle.getString("broker.package.name");
        String className = interactiveRequestBundle.getString("broker.activity.name");
        if (StringUtil.isNullOrEmpty((String)packageName) || StringUtil.isNullOrEmpty((String)className)) {
            throw new ClientException("invalid_broker_bundle", "Content of Authorization Intent's package and class name should not be null.");
        }
        Intent intent = new Intent();
        intent.setPackage(packageName);
        intent.setClassName(packageName, className);
        intent.putExtras(interactiveRequestBundle);
        intent.putExtra("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
        return intent;
    }

    public Bundle extractInteractiveRequestBundleFromResultBundle(@NonNull Bundle resultBundle) {
        Intent interactiveRequestIntent = (Intent)resultBundle.getParcelable("intent");
        if (interactiveRequestIntent != null) {
            return interactiveRequestIntent.getExtras();
        }
        return resultBundle;
    }

    @NonNull
    public AcquireTokenResult getAcquireTokenResultFromResultBundle(@NonNull Bundle resultBundle) throws BaseException {
        MsalBrokerResultAdapter resultAdapter = new MsalBrokerResultAdapter();
        if (resultBundle.getBoolean("broker_request_v2_success")) {
            AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
            acquireTokenResult.setLocalAuthenticationResult(resultAdapter.authenticationResultFromBundle(resultBundle));
            return acquireTokenResult;
        }
        throw this.getBaseExceptionFromBundle(resultBundle);
    }

    @NonNull
    public Bundle bundleFromAccounts(@NonNull List<ICacheRecord> cacheRecords, @Nullable String negotiatedProtocolVersion) {
        String methodTag = TAG + ":bundleFromAccounts";
        Bundle resultBundle = new Bundle();
        String jsonString = JsonExtensions.getJsonStringFromICacheRecordList(cacheRecords);
        if (BrokerProtocolVersionUtil.canCompressBrokerPayloads((String)negotiatedProtocolVersion)) {
            try {
                byte[] bytes = GzipUtil.compressString(jsonString);
                Logger.info(methodTag, "Get accounts, raw payload size :" + jsonString.getBytes(AuthenticationConstants.CHARSET_UTF8).length + " compressed size " + bytes.length);
                resultBundle.putByteArray("broker_accounts_compressed", bytes);
            }
            catch (IOException e) {
                Logger.error(methodTag, " Failed to compress account list to bytes, sending as jsonString", e);
                resultBundle.putString("broker_accounts", jsonString);
            }
        } else {
            Logger.info(methodTag, "Broker protocol version: " + negotiatedProtocolVersion + " lower than compression changes, sending as string");
            resultBundle.putString("broker_accounts", jsonString);
        }
        return resultBundle;
    }

    @NonNull
    public List<ICacheRecord> getAccountsFromResultBundle(@NonNull Bundle bundle) throws BaseException {
        String accountJson;
        String methodTag = TAG + ":getAccountsFromResultBundle";
        byte[] compressedData = bundle.getByteArray("broker_accounts_compressed");
        if (compressedData != null) {
            try {
                accountJson = GzipUtil.decompressBytesToString(compressedData);
            }
            catch (IOException e) {
                Logger.error(methodTag, " Failed to decompress account list to bytes", e);
                throw new ClientException("invalid_broker_bundle", " Failed to decompress account list to bytes.");
            }
        } else {
            accountJson = bundle.getString("broker_accounts");
        }
        if (StringUtil.isNullOrEmpty((String)accountJson)) {
            throw new MsalBrokerResultAdapter().getBaseExceptionFromBundle(bundle);
        }
        return JsonExtensions.getICacheRecordListFromJsonString(accountJson);
    }

    public void verifyRemoveAccountResultFromBundle(@Nullable Bundle bundle) throws BaseException {
        String methodTag = TAG + ":verifyRemoveAccountResultFromBundle";
        if (bundle == null) {
            return;
        }
        String brokerResultString = bundle.getString("broker_result_v2");
        if (StringUtil.isNullOrEmpty((String)brokerResultString)) {
            throw this.getBaseExceptionFromBundle(bundle);
        }
        BrokerResult brokerResult = JsonExtensions.getBrokerResultFromJsonString(brokerResultString);
        if (brokerResult != null && brokerResult.isSuccess()) {
            return;
        }
        Logger.warn(methodTag, "Failed to remove account.");
        throw this.getBaseExceptionFromBundle(bundle);
    }

    @NonNull
    public Bundle bundleFromDeviceMode(boolean isSharedDevice) {
        Bundle resultBundle = new Bundle();
        resultBundle.putBoolean("broker_device_mode", isSharedDevice);
        return resultBundle;
    }

    public boolean getDeviceModeFromResultBundle(@NonNull Bundle bundle) throws BaseException {
        if (!bundle.containsKey("broker_device_mode")) {
            throw new MsalBrokerResultAdapter().getBaseExceptionFromBundle(bundle);
        }
        return bundle.getBoolean("broker_device_mode");
    }

    @NonNull
    public ClientException getExceptionForEmptyResultBundle() {
        return new ClientException("invalid_broker_bundle", "Broker Result not returned from Broker.");
    }

    public GenerateShrResult getGenerateShrResultFromResultBundle(@NonNull Bundle resultBundle) {
        String resultJson = resultBundle.getString("broker_generate_shr_result");
        GenerateShrResult shrResult = (GenerateShrResult)AuthenticationSchemeTypeAdapter.getGsonInstance().fromJson(resultJson, GenerateShrResult.class);
        return shrResult;
    }
}

