/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.components;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.util.SharedPrefStringNameValueStorage;
import com.microsoft.identity.common.internal.util.SharedPreferenceLongStorage;
import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.interfaces.INameValueStorage;
import com.microsoft.identity.common.java.interfaces.IStorageSupplier;
import com.microsoft.identity.common.java.util.ported.Predicate;
import java.util.Iterator;
import java.util.Map;
import lombok.NonNull;

public class AndroidStorageSupplier
implements IStorageSupplier {
    @NonNull
    private final Context mContext;

    @NonNull
    public <T> INameValueStorage<T> getEncryptedNameValueStore(@NonNull String storeName, @Nullable IKeyAccessor helper, @NonNull Class<T> clazz) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        SharedPreferencesFileManager mgr = SharedPreferencesFileManager.getSharedPreferences(this.mContext, storeName, helper);
        if (Long.class.isAssignableFrom(clazz)) {
            return new SharedPreferenceLongStorage(mgr);
        }
        if (String.class.isAssignableFrom(clazz)) {
            return new SharedPrefStringNameValueStorage(mgr);
        }
        throw new UnsupportedOperationException("Only Long and String are natively supported as types");
    }

    @NonNull
    public IMultiTypeNameValueStorage getEncryptedFileStore(@NonNull String storeName, @NonNull IKeyAccessor helper) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        if (helper == null) {
            throw new NullPointerException("helper is marked non-null but is null");
        }
        return SharedPreferencesFileManager.getSharedPreferences(this.mContext, storeName, helper);
    }

    @NonNull
    public IMultiTypeNameValueStorage getFileStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        return SharedPreferencesFileManager.getSharedPreferences(this.mContext, storeName, null);
    }

    @NonNull
    public INameValueStorage<String> getMultiProcessStringStore(@NonNull String storeName) {
        if (storeName == null) {
            throw new NullPointerException("storeName is marked non-null but is null");
        }
        final SharedPreferences sharedPreferences = this.mContext.getSharedPreferences(storeName, 4);
        return new SharedPrefStringNameValueStorage(new IMultiTypeNameValueStorage(){

            public void putString(String key, String value) {
                sharedPreferences.edit().putString(key, value).apply();
            }

            public String getString(String key) {
                return sharedPreferences.getString(key, null);
            }

            public void putLong(String key, long value) {
                sharedPreferences.edit().putString(key, Long.toString(value)).apply();
            }

            public long getLong(String key) {
                try {
                    if (!sharedPreferences.contains(key)) {
                        return 0L;
                    }
                    return Long.parseLong(sharedPreferences.getString(key, "0"));
                }
                catch (NumberFormatException nfe) {
                    return 0L;
                }
            }

            public Map<String, String> getAll() {
                return sharedPreferences.getAll();
            }

            public Iterator<Map.Entry<String, String>> getAllFilteredByKey(Predicate<String> keyFilter) {
                return null;
            }

            public boolean contains(String key) {
                return sharedPreferences.contains(key);
            }

            public void clear() {
                sharedPreferences.edit().clear().commit();
            }

            public void remove(String key) {
                sharedPreferences.edit().remove(key).commit();
            }
        });
    }

    public AndroidStorageSupplier(@NonNull Context mContext) {
        if (mContext == null) {
            throw new NullPointerException("mContext is marked non-null but is null");
        }
        this.mContext = mContext;
    }
}

